/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;

public class VehicleConfigHelper {
    public static ResourceLocation[] loadTexturesFromConfig(String configPath) {
        try {
            InputStream stream = VehicleConfigHelper.class.getResourceAsStream("/assets/vvp/" + configPath);
            if (stream == null) {
                return new ResourceLocation[0];
            }
            JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
            JsonObject model = json.getAsJsonObject("Model");
            ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
            if (model.has("Texture")) {
                textures.add(VehicleConfigHelper.parseResourceLocation(model.get("Texture").getAsString()));
            }
            int i = 2;
            while (model.has("Texture_" + i)) {
                textures.add(VehicleConfigHelper.parseResourceLocation(model.get("Texture_" + i).getAsString()));
                ++i;
            }
            stream.close();
            return textures.toArray(new ResourceLocation[0]);
        }
        catch (Exception e) {
            return new ResourceLocation[0];
        }
    }

    private static ResourceLocation parseResourceLocation(String str) {
        if (str.contains(":")) {
            String[] parts = str.split(":", 2);
            return new ResourceLocation(parts[0], parts[1]);
        }
        return new ResourceLocation("vvp", str);
    }
}

