/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.entity.vehicle;

import java.lang.reflect.Field;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import tech.vvp.vvp.entity.vehicle.CamoVehicleBase;

public class Mi8Entity
extends CamoVehicleBase {
    private static final EntityDataAccessor<Boolean> LEFT_DOOR_OPEN = SynchedEntityData.m_135353_(Mi8Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RIGHT_DOOR_OPEN = SynchedEntityData.m_135353_(Mi8Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float leftDoorProgress = 0.0f;
    private float leftDoorProgressO = 0.0f;
    private float rightDoorProgress = 0.0f;
    private float rightDoorProgressO = 0.0f;
    private static final ResourceLocation[] CAMO_TEXTURES = new ResourceLocation[]{new ResourceLocation("vvp", "textures/entity/mi8_default.png"), new ResourceLocation("vvp", "textures/entity/mi8_pepeshneyna.png"), new ResourceLocation("vvp", "textures/entity/mi8_rf2.png"), new ResourceLocation("vvp", "textures/entity/mi8_rf3.png"), new ResourceLocation("vvp", "textures/entity/mi8_rf4.png"), new ResourceLocation("vvp", "textures/entity/mi8_ukr.png"), new ResourceLocation("vvp", "textures/entity/mi8_ukr2.png")};
    private static final String[] CAMO_NAMES = new String[]{"Default", "Pepeshneyna", "RF2", "RF3", "RF4", "Ukraine", "Ukraine2"};
    private static Field propellerRotField;
    private static Field propellerRotOField;

    public Mi8Entity(EntityType<Mi8Entity> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LEFT_DOOR_OPEN, (Object)false);
        this.f_19804_.m_135372_(RIGHT_DOOR_OPEN, (Object)false);
    }

    @Override
    public ResourceLocation[] getCamoTextures() {
        return CAMO_TEXTURES;
    }

    @Override
    public String[] getCamoNames() {
        return CAMO_NAMES;
    }

    public boolean isLeftDoorOpen() {
        return (Boolean)this.f_19804_.m_135370_(LEFT_DOOR_OPEN);
    }

    public void setLeftDoorOpen(boolean open) {
        this.f_19804_.m_135381_(LEFT_DOOR_OPEN, (Object)open);
    }

    public boolean isRightDoorOpen() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT_DOOR_OPEN);
    }

    public void setRightDoorOpen(boolean open) {
        this.f_19804_.m_135381_(RIGHT_DOOR_OPEN, (Object)open);
    }

    public float getLeftDoorProgress(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.leftDoorProgressO, (float)this.leftDoorProgress);
    }

    public float getRightDoorProgress(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.rightDoorProgressO, (float)this.rightDoorProgress);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_146895_() == null) {
            try {
                Field powerField = Class.forName("com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity").getDeclaredField("power");
                powerField.setAccessible(true);
                float currentPower = powerField.getFloat(this);
                if (currentPower > 1.0E-4f) {
                    powerField.setFloat(this, currentPower * 0.98f);
                }
            }
            catch (Exception powerField) {
                // empty catch block
            }
        }
        if (!this.m_9236_().f_46443_) {
            boolean isFlying;
            float propellerSpeed = Math.abs(this.getPropellerRot() - this.getPropellerRotO());
            boolean bl = isFlying = !this.m_20096_() || propellerSpeed > 0.5f;
            if (isFlying) {
                if (this.isLeftDoorOpen()) {
                    this.setLeftDoorOpen(false);
                }
                if (this.isRightDoorOpen()) {
                    this.setRightDoorOpen(false);
                }
            }
        }
        this.leftDoorProgressO = this.leftDoorProgress;
        this.rightDoorProgressO = this.rightDoorProgress;
        float doorSpeed = 0.1f;
        this.leftDoorProgress = this.isLeftDoorOpen() ? Math.min(1.0f, this.leftDoorProgress + doorSpeed) : Math.max(0.0f, this.leftDoorProgress - doorSpeed);
        this.rightDoorProgress = this.isRightDoorOpen() ? Math.min(1.0f, this.rightDoorProgress + doorSpeed) : Math.max(0.0f, this.rightDoorProgress - doorSpeed);
    }

    public float getPropellerRot() {
        try {
            return propellerRotField != null ? ((Float)propellerRotField.get(this)).floatValue() : 0.0f;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public float getPropellerRotO() {
        try {
            return propellerRotOField != null ? ((Float)propellerRotOField.get(this)).floatValue() : 0.0f;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41619_() && !player.m_20159_()) {
            boolean inMiddleSection;
            double relativeX = player.m_20185_() - this.m_20185_();
            double relativeZ = player.m_20189_() - this.m_20189_();
            float yaw = (float)Math.toRadians(-this.m_146908_());
            double localX = relativeX * Math.cos(yaw) - relativeZ * Math.sin(yaw);
            double localZ = relativeX * Math.sin(yaw) + relativeZ * Math.cos(yaw);
            boolean onLeftSide = localX > 1.0;
            boolean onRightSide = localX < -1.0;
            boolean bl = inMiddleSection = localZ > -1.0 && localZ < 2.0;
            if (inMiddleSection && (onLeftSide || onRightSide)) {
                if (player.m_6144_()) {
                    if (onLeftSide) {
                        if (!this.m_9236_().f_46443_) {
                            this.setLeftDoorOpen(!this.isLeftDoorOpen());
                            player.m_5661_((Component)Component.m_237113_((String)(this.isLeftDoorOpen() ? "Left door opened" : "Left door closed")).m_130940_(ChatFormatting.YELLOW), true);
                            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12056_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        player.m_6674_(hand);
                        return InteractionResult.SUCCESS;
                    }
                    if (onRightSide) {
                        if (!this.m_9236_().f_46443_) {
                            this.setRightDoorOpen(!this.isRightDoorOpen());
                            player.m_5661_((Component)Component.m_237113_((String)(this.isRightDoorOpen() ? "Right door opened" : "Right door closed")).m_130940_(ChatFormatting.YELLOW), true);
                            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12056_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        player.m_6674_(hand);
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    if (onLeftSide && !this.isLeftDoorOpen()) {
                        if (!this.m_9236_().f_46443_) {
                            player.m_5661_((Component)Component.m_237113_((String)"Open the door first! (Shift+RMB)").m_130940_(ChatFormatting.RED), true);
                        }
                        return InteractionResult.FAIL;
                    }
                    if (onRightSide && !this.isRightDoorOpen()) {
                        if (!this.m_9236_().f_46443_) {
                            player.m_5661_((Component)Component.m_237113_((String)"Open the door first! (Shift+RMB)").m_130940_(ChatFormatting.RED), true);
                        }
                        return InteractionResult.FAIL;
                    }
                    return super.m_6096_(player, hand);
                }
            }
            if (!this.isLeftDoorOpen() && !this.isRightDoorOpen()) {
                if (!this.m_9236_().f_46443_) {
                    player.m_5661_((Component)Component.m_237113_((String)"Open the door first!").m_130940_(ChatFormatting.RED), true);
                }
                return InteractionResult.FAIL;
            }
        }
        return super.m_6096_(player, hand);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("LeftDoorOpen", this.isLeftDoorOpen());
        compound.m_128379_("RightDoorOpen", this.isRightDoorOpen());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("LeftDoorOpen")) {
            this.setLeftDoorOpen(compound.m_128471_("LeftDoorOpen"));
        }
        if (compound.m_128441_("RightDoorOpen")) {
            this.setRightDoorOpen(compound.m_128471_("RightDoorOpen"));
        }
    }

    static {
        try {
            Class<?> vehicleClass = Class.forName("com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity");
            propellerRotField = vehicleClass.getDeclaredField("propellerRot");
            propellerRotField.setAccessible(true);
            propellerRotOField = vehicleClass.getDeclaredField("propellerRotO");
            propellerRotOField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

