/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.entity.projectile;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.MissileProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.vvp.vvp.entity.vehicle.PantsirS1Entity;

public class PantsirMissileEntity
extends MissileProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final double MISSILE_SPEED = 10.0;
    private static final double INITIAL_SPEED = 8.0;
    private static final double ACCELERATION = 0.25;
    private static final float MAX_TURN_RATE = 5.0f;
    private static final float BOOST_TURN_RATE = 6.0f;
    private static final float MAX_LEAD_ANGLE = 45.0f;
    private static final double PROXIMITY_FUSE_MISSILE = 2.5;
    private static final double PROXIMITY_FUSE_AIRCRAFT = 3.5;
    private static final double SHRAPNEL_RANGE = 12.0;
    private static final float SHRAPNEL_MAX_DAMAGE = 60.0f;
    private static final int MAX_LIFETIME = 400;
    private static final int BOOST_PHASE_TICKS = 25;
    private static final int MAX_TURN_ANGLE = 75;
    private static final int TARGET_UPDATE_INTERVAL = 3;
    private static final double FLARE_CONE_ANGLE = 15.0;
    private int launcherEntityId = -1;
    private int targetEntityId = -1;
    private boolean targetIsMissile = false;
    private double lastDistanceToTarget = Double.MAX_VALUE;
    private double minDistanceReached = Double.MAX_VALUE;
    private boolean lostTargetFromManeuver = false;
    private boolean hasRadarLink = true;
    private int noSignalTicks = 0;
    private static final int MAX_NO_SIGNAL_TICKS = 80;
    private static final int MAX_REACQUIRE_TICKS = 40;
    private static final double MAX_REACQUIRE_ANGLE = 20.0;
    private static final double RADAR_TRACK_RANGE = 1100.0;
    private Vec3 lastKnownDirection = null;
    private boolean lostPermanently = false;
    private int reacquireTicks = 0;
    private static final int REACQUIRE_SMOOTH_TICKS = 10;
    private Vec3 cachedTargetPos = null;
    private Vec3 smoothedTargetVelocity = Vec3.f_82478_;
    private int targetUpdateCooldown = 0;

    public PantsirMissileEntity(EntityType<? extends PantsirMissileEntity> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.MEDIUM_ANTI_AIR_MISSILE.get();
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.launcherEntityId = compound.m_128451_("LauncherId");
        this.targetEntityId = compound.m_128451_("TargetEntityId");
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("LauncherId", this.launcherEntityId);
        compound.m_128405_("TargetEntityId", this.targetEntityId);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.targetPos != null);
        if (this.targetPos != null) {
            buffer.writeDouble(this.targetPos.f_82479_);
            buffer.writeDouble(this.targetPos.f_82480_);
            buffer.writeDouble(this.targetPos.f_82481_);
        }
        buffer.writeInt(this.launcherEntityId);
        buffer.writeInt(this.targetEntityId);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            this.targetPos = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
        this.launcherEntityId = buffer.readInt();
        this.targetEntityId = buffer.readInt();
    }

    public void m_8119_() {
        super.m_8119_();
        this.spawnTrailParticles();
        if (!this.m_9236_().f_46443_ && this.m_9236_() instanceof ServerLevel) {
            if (this.f_19797_ <= 5) {
                this.forceUpdateTargetFromRadar();
            }
            this.checkForDecoy();
            this.tickGuidance();
        }
        if (this.f_19797_ > 400 || this.m_20069_()) {
            this.explodeAndDiscard();
        }
    }

    private void checkForDecoy() {
        List decoy = SeekTool.seekLivingEntities((Entity)this, (double)32.0, (double)90.0);
        for (Entity e : decoy) {
            if (!e.m_6095_().m_204039_(ModTags.EntityTypes.DECOY) || this.distracted || !this.isFlareOnPath(e)) continue;
            double distractionChance = this.calculateDistractionChance(e);
            if (!(this.f_19796_.m_188500_() < distractionChance)) continue;
            this.f_19804_.m_135381_(TARGET_UUID, (Object)e.m_20149_());
            this.distracted = true;
            break;
        }
    }

    private boolean isFlareOnPath(Entity flare) {
        double maxLateralDist;
        Vec3 toFlareNorm;
        if (this.targetPos == null) {
            return true;
        }
        Vec3 missileVelocity = this.m_20184_();
        if (missileVelocity.m_82556_() < 0.01) {
            return true;
        }
        Vec3 missilePos = this.m_20182_();
        Vec3 flarePos = flare.m_20182_();
        Vec3 toFlare = flarePos.m_82546_(missilePos);
        Vec3 missileDirection = missileVelocity.m_82541_();
        double dot = missileDirection.m_82526_(toFlareNorm = toFlare.m_82541_());
        double angle = Math.toDegrees(Math.acos(Mth.m_14008_((double)dot, (double)-1.0, (double)1.0)));
        if (angle > 15.0) {
            return false;
        }
        double distToFlare = toFlare.m_82553_();
        Vec3 projectionOnPath = missileDirection.m_82490_(distToFlare * dot);
        Vec3 lateralOffset = toFlare.m_82546_(projectionOnPath);
        double lateralDist = lateralOffset.m_82553_();
        return lateralDist <= (maxLateralDist = distToFlare * Math.tan(Math.toRadians(15.0)));
    }

    private double calculateDistractionChance(Entity flare) {
        Vec3 toFlare;
        Vec3 toTarget;
        double dot;
        double angle;
        double baseChance = 0.725;
        double distanceToFlare = this.m_20270_(flare);
        double distanceBonus = distanceToFlare < 15.0 ? 0.1 : 0.0;
        double flightPhaseBonus = 0.0;
        if (this.targetPos != null && this.m_20182_().m_82554_(this.targetPos) < 20.0) {
            flightPhaseBonus = -0.1;
        }
        double anglePenalty = 0.0;
        if (this.targetPos != null && (angle = Math.toDegrees(Math.acos(Mth.m_14008_((double)(dot = (toTarget = this.targetPos.m_82546_(this.m_20182_()).m_82541_()).m_82526_(toFlare = flare.m_20182_().m_82546_(this.m_20182_()).m_82541_())), (double)-1.0, (double)1.0)))) > 70.0) {
            anglePenalty = -0.15;
        }
        double finalChance = baseChance + distanceBonus + flightPhaseBonus + anglePenalty;
        return Mth.m_14008_((double)finalChance, (double)0.6, (double)0.95);
    }

    private void tickGuidance() {
        double fuseRange;
        String targetUuid;
        this.checkRadarLink();
        if (!this.hasRadarLink) {
            ++this.noSignalTicks;
            if (this.noSignalTicks >= 80) {
                this.selfDestruct();
                return;
            }
            if (this.lastKnownDirection != null) {
                if (this.isValidDirection(this.lastKnownDirection)) {
                    Vec3 currentVel = this.m_20184_();
                    double currentSpeed = currentVel.m_82553_();
                    Vec3 inertialVelocity = this.lastKnownDirection.m_82541_().m_82490_(currentSpeed);
                    this.m_20256_(inertialVelocity);
                } else {
                    Vec3 currentVel = this.m_20184_();
                    this.lastKnownDirection = currentVel.m_82556_() > 1.0E-4 ? currentVel.m_82541_() : this.m_20154_();
                }
            }
            return;
        }
        if (this.reacquireTicks > 0) {
            ++this.reacquireTicks;
            if (this.reacquireTicks > 10) {
                this.reacquireTicks = 0;
            }
        }
        if (!this.lostTargetFromManeuver) {
            this.updateTargetFromRadar();
        }
        --this.targetUpdateCooldown;
        Entity target = null;
        if (this.targetEntityId != -1) {
            target = this.m_9236_().m_6815_(this.targetEntityId);
        }
        if (target == null && !this.lostTargetFromManeuver && (targetUuid = (String)this.f_19804_.m_135370_(TARGET_UUID)) != null && !targetUuid.equals("none") && (target = EntityFindUtil.findEntity((Level)this.m_9236_(), (String)targetUuid)) != null) {
            this.targetEntityId = target.m_19879_();
        }
        if (target != null && target.m_6084_()) {
            int warningInterval;
            if (this.isTargetManeuvering(target)) {
                float evasionChance = this.getManeuverEvasionChance(target);
                if (this.f_19796_.m_188501_() < evasionChance) {
                    this.lostTargetFromManeuver = true;
                    this.targetEntityId = -1;
                    this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                }
            }
            if (!this.lostTargetFromManeuver) {
                if (this.targetUpdateCooldown <= 0) {
                    Vec3 newTargetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0);
                    if (this.cachedTargetPos != null) {
                        Vec3 newVelocity = newTargetPos.m_82546_(this.cachedTargetPos).m_82490_(0.3333333333333333);
                        this.smoothedTargetVelocity = newVelocity.m_82490_(0.6).m_82549_(this.smoothedTargetVelocity.m_82490_(0.4));
                    } else {
                        this.smoothedTargetVelocity = target.m_20184_();
                    }
                    this.cachedTargetPos = newTargetPos;
                    this.targetUpdateCooldown = 3;
                }
                this.targetPos = this.calculateInterceptPoint(this.cachedTargetPos, this.smoothedTargetVelocity);
                this.targetIsMissile = this.isTargetMissile(target);
            }
            if (this.f_19797_ % (warningInterval = (int)Math.max(0.04 * (double)this.m_20270_(target), 2.0)) == 0) {
                boolean shouldWarn;
                boolean bl = shouldWarn = target instanceof VehicleEntity || !target.m_20197_().isEmpty() || target instanceof Player;
                if (shouldWarn) {
                    target.m_9236_().m_5594_(null, target.m_20097_(), target instanceof Pig ? SoundEvents.f_12235_ : (SoundEvent)ModSounds.MISSILE_WARNING.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
                }
            }
        }
        if (this.targetPos == null) {
            this.maintainSpeed();
            return;
        }
        double distanceToTarget = this.m_20182_().m_82554_(this.targetPos);
        if (distanceToTarget < this.minDistanceReached) {
            this.minDistanceReached = distanceToTarget;
        }
        double d = fuseRange = this.targetIsMissile ? 2.5 : 3.5;
        if (distanceToTarget < fuseRange) {
            this.explodeWithShrapnel();
            return;
        }
        if (distanceToTarget > this.lastDistanceToTarget + 0.5 && this.minDistanceReached < fuseRange * 2.0) {
            this.explodeWithShrapnel();
            return;
        }
        this.lastDistanceToTarget = distanceToTarget;
        float turnRate = this.f_19797_ < 25 ? 6.0f : 5.0f;
        this.turnToTarget(turnRate);
        this.maintainSpeed();
        this.updateRotationFromVelocity();
    }

    private Vec3 calculateInterceptPoint(Vec3 targetPos, Vec3 targetVelocity) {
        Vec3 missilePos = this.m_20182_();
        double currentSpeed = this.m_20184_().m_82553_();
        double missileSpeed = Math.max(currentSpeed, 5.0);
        double targetSpeed = targetVelocity.m_82553_();
        if (targetSpeed < 0.1) {
            return targetPos.m_82520_(0.0, 0.5, 0.0);
        }
        double distance = missilePos.m_82554_(targetPos);
        double timeToIntercept = distance / missileSpeed;
        for (int i = 0; i < 5; ++i) {
            Vec3 predictedPos = targetPos.m_82549_(targetVelocity.m_82490_(timeToIntercept));
            distance = missilePos.m_82554_(predictedPos);
            timeToIntercept = distance / missileSpeed;
        }
        double leadCoefficient = 1.0;
        if (distance < 40.0) {
            leadCoefficient = 0.3;
        }
        if (distance < 25.0) {
            leadCoefficient = 0.0;
        }
        Vec3 interceptPoint = targetPos.m_82549_(targetVelocity.m_82490_(timeToIntercept * leadCoefficient)).m_82520_(0.0, 0.3, 0.0);
        return interceptPoint;
    }

    private void forceUpdateTargetFromRadar() {
        Entity lockedTarget;
        List nearby;
        PantsirS1Entity p2;
        Entity vehicle;
        PantsirS1Entity pantsir = null;
        if (this.m_19749_() != null && (vehicle = this.m_19749_().m_20202_()) instanceof PantsirS1Entity && (p2 = (PantsirS1Entity)vehicle).hasLockedTarget()) {
            pantsir = p2;
            this.launcherEntityId = p2.m_19879_();
        }
        if (pantsir == null && this.m_19749_() != null && !(nearby = this.m_9236_().m_6443_(PantsirS1Entity.class, this.m_19749_().m_20191_().m_82400_(20.0), p -> p.hasLockedTarget())).isEmpty()) {
            pantsir = (PantsirS1Entity)nearby.get(0);
            this.launcherEntityId = pantsir.m_19879_();
        }
        if (pantsir == null && this.m_19749_() == null && !(nearby = this.m_9236_().m_6443_(PantsirS1Entity.class, this.m_20191_().m_82400_(50.0), p -> p.hasLockedTarget())).isEmpty()) {
            pantsir = nearby.stream().min((a, b) -> Double.compare(this.m_20270_((Entity)a), this.m_20270_((Entity)b))).orElse((PantsirS1Entity)nearby.get(0));
            this.launcherEntityId = pantsir.m_19879_();
        }
        if (pantsir != null && (lockedTarget = pantsir.getLockedTarget()) != null && lockedTarget.m_6084_()) {
            this.targetPos = lockedTarget.m_20182_().m_82520_(0.0, (double)lockedTarget.m_20206_() * 0.5, 0.0);
            this.targetEntityId = lockedTarget.m_19879_();
            this.f_19804_.m_135381_(TARGET_UUID, (Object)lockedTarget.m_20149_());
        }
    }

    private void updateTargetFromRadar() {
        Entity lockedTarget;
        List nearby;
        Entity vehicle;
        PantsirS1Entity p2;
        Entity launcher;
        PantsirS1Entity pantsir = null;
        if (this.launcherEntityId != -1 && (launcher = this.m_9236_().m_6815_(this.launcherEntityId)) instanceof PantsirS1Entity) {
            pantsir = p2 = (PantsirS1Entity)launcher;
        }
        if (pantsir == null && this.m_19749_() != null && (vehicle = this.m_19749_().m_20202_()) instanceof PantsirS1Entity) {
            pantsir = p2 = (PantsirS1Entity)vehicle;
            this.launcherEntityId = p2.m_19879_();
        }
        if (pantsir == null && !(nearby = this.m_9236_().m_6443_(PantsirS1Entity.class, this.m_20191_().m_82400_(100.0), p -> p.hasLockedTarget())).isEmpty()) {
            pantsir = (PantsirS1Entity)nearby.get(0);
            this.launcherEntityId = pantsir.m_19879_();
        }
        if (pantsir != null && (lockedTarget = pantsir.getLockedTarget()) != null && lockedTarget.m_6084_()) {
            this.targetPos = lockedTarget.m_20182_().m_82520_(0.0, (double)lockedTarget.m_20206_() * 0.5, 0.0);
            this.targetEntityId = lockedTarget.m_19879_();
            this.f_19804_.m_135381_(TARGET_UUID, (Object)lockedTarget.m_20149_());
        }
    }

    private boolean isTargetMissile(Entity target) {
        if (target == null) {
            return false;
        }
        if (target instanceof MissileProjectile) {
            return true;
        }
        String className = target.getClass().getSimpleName();
        return className.contains("Missile") || className.contains("Rocket") || className.contains("Bomb");
    }

    private boolean isTargetManeuvering(Entity target) {
        float oldYaw;
        if (target == null) {
            return false;
        }
        if (!(target instanceof VehicleEntity)) {
            return false;
        }
        Vec3 velocity = target.m_20184_();
        double speed = velocity.m_82553_();
        if (speed < 0.25) {
            return false;
        }
        double verticalSpeed = Math.abs(velocity.f_82480_);
        if (verticalSpeed > 0.4) {
            return true;
        }
        float currentYaw = target.m_146908_();
        float yawDelta = Math.abs(currentYaw - (oldYaw = target.f_19859_));
        if (yawDelta > 180.0f) {
            yawDelta = 360.0f - yawDelta;
        }
        return yawDelta > 10.0f && speed > 0.4;
    }

    private float getManeuverEvasionChance(Entity target) {
        if (target == null || this.targetPos == null) {
            return 0.05f;
        }
        double distance = this.m_20182_().m_82554_(target.m_20182_());
        if (distance < 30.0) {
            return 0.45f;
        }
        if (distance < 60.0) {
            return 0.25f;
        }
        if (distance < 100.0) {
            return 0.1f;
        }
        return 0.05f;
    }

    private void checkRadarLink() {
        Entity launcher;
        if (this.lostPermanently) {
            return;
        }
        PantsirS1Entity pantsir = null;
        if (this.launcherEntityId != -1 && (launcher = this.m_9236_().m_6815_(this.launcherEntityId)) instanceof PantsirS1Entity) {
            PantsirS1Entity p;
            pantsir = p = (PantsirS1Entity)launcher;
        }
        if (pantsir == null) {
            this.loseRadarLink();
            return;
        }
        if (!pantsir.hasLockedTarget()) {
            this.loseRadarLink();
            return;
        }
        Entity target = null;
        if (this.targetEntityId != -1) {
            target = this.m_9236_().m_6815_(this.targetEntityId);
        }
        if (target != null && target.m_6084_()) {
            Vec3 targetPos;
            Vec3 pantsirPos = pantsir.m_20182_().m_82520_(0.0, 2.5, 0.0);
            double distance = pantsirPos.m_82554_(targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0));
            if (distance > 1100.0) {
                this.loseRadarLink();
                return;
            }
            if (!this.hasLineOfSight(pantsirPos, targetPos)) {
                this.loseRadarLink();
                return;
            }
            if (!this.hasRadarLink && this.canReacquireTarget(targetPos)) {
                this.hasRadarLink = true;
                this.noSignalTicks = 0;
                this.reacquireTicks = 1;
            }
        } else {
            this.loseRadarLink();
            return;
        }
    }

    private boolean canReacquireTarget(Vec3 targetPos) {
        Vec3 toTarget;
        double dot;
        double angle;
        if (this.noSignalTicks > 40) {
            this.lostPermanently = true;
            return false;
        }
        if (this.lastKnownDirection != null && this.isValidDirection(this.lastKnownDirection) && (angle = Math.toDegrees(Math.acos(Mth.m_14008_((double)(dot = this.lastKnownDirection.m_82526_(toTarget = targetPos.m_82546_(this.m_20182_()).m_82541_())), (double)-1.0, (double)1.0)))) > 20.0) {
            this.lostPermanently = true;
            return false;
        }
        return true;
    }

    private boolean isValidDirection(Vec3 direction) {
        if (direction == null) {
            return false;
        }
        if (Double.isNaN(direction.f_82479_) || Double.isNaN(direction.f_82480_) || Double.isNaN(direction.f_82481_)) {
            return false;
        }
        return !(direction.m_82556_() < 1.0E-4);
    }

    private void loseRadarLink() {
        if (this.hasRadarLink) {
            Vec3 lookAngle;
            this.hasRadarLink = false;
            this.noSignalTicks = 0;
            Vec3 currentVel = this.m_20184_();
            this.lastKnownDirection = currentVel.m_82556_() > 1.0E-4 && !Double.isNaN(currentVel.f_82479_) ? currentVel.m_82541_() : (this.isValidDirection(lookAngle = this.m_20154_()) ? lookAngle : new Vec3(0.0, 0.0, 1.0));
        }
    }

    private boolean hasLineOfSight(Vec3 from, Vec3 to) {
        BlockHitResult hit = this.m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return hit.m_6662_() == HitResult.Type.MISS;
    }

    private void selfDestruct() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123755_, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (int)8, (double)0.3, (double)0.3, (double)0.3, (double)0.05, (boolean)false);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 0.5f, 0.8f);
        }
        this.m_146870_();
    }

    private void turnToTarget(float maxTurnRate) {
        if (this.targetPos == null) {
            return;
        }
        Vec3 currentVelocity = this.m_20184_();
        if (currentVelocity.m_82556_() < 0.001) {
            Vec3 toTarget = this.targetPos.m_82546_(this.m_20182_()).m_82541_();
            this.m_20256_(toTarget.m_82490_(8.0));
            return;
        }
        Vec3 toTarget = this.targetPos.m_82546_(this.m_20182_());
        Vec3 targetDirection = toTarget.m_82541_();
        Vec3 currentDirection = currentVelocity.m_82541_();
        double dot = currentDirection.m_82526_(targetDirection);
        double angle = Math.toDegrees(Math.acos(Mth.m_14008_((double)dot, (double)-1.0, (double)1.0)));
        if (angle > 75.0) {
            return;
        }
        float effectiveTurnRate = maxTurnRate;
        if (this.reacquireTicks > 0 && this.reacquireTicks <= 10) {
            float progress = (float)this.reacquireTicks / 10.0f;
            float turnRateMultiplier = 0.5f + 0.5f * progress;
            effectiveTurnRate = maxTurnRate * turnRateMultiplier;
        }
        double actualTurnRate = Math.min((double)effectiveTurnRate, angle);
        double turnFactor = actualTurnRate / Math.max(angle, 0.1);
        Vec3 newDirection = this.slerp(currentDirection, targetDirection, turnFactor);
        double speed = currentVelocity.m_82553_();
        Vec3 newVelocity = newDirection.m_82490_(speed);
        this.m_20256_(newVelocity);
        if (this.hasRadarLink && this.isValidDirection(newDirection)) {
            this.lastKnownDirection = newDirection;
        }
    }

    private Vec3 slerp(Vec3 start, Vec3 end, double t) {
        double dot = Mth.m_14008_((double)start.m_82526_(end), (double)-1.0, (double)1.0);
        double theta = Math.acos(dot) * t;
        Vec3 relative = end.m_82546_(start.m_82490_(dot)).m_82541_();
        return start.m_82490_(Math.cos(theta)).m_82549_(relative.m_82490_(Math.sin(theta)));
    }

    private void maintainSpeed() {
        double targetSpeed;
        Vec3 velocity = this.m_20184_();
        double currentSpeed = velocity.m_82553_();
        if (this.f_19797_ < 25) {
            double progress = (double)this.f_19797_ / 25.0;
            targetSpeed = 8.0 + 2.0 * progress;
        } else {
            targetSpeed = 10.0;
        }
        if (Math.abs(currentSpeed - targetSpeed) > 0.1) {
            double newSpeed = currentSpeed < targetSpeed ? Math.min(currentSpeed + 0.25, targetSpeed) : Math.max(currentSpeed - 0.125, targetSpeed);
            Vec3 direction = velocity.m_82556_() > 0.001 ? velocity.m_82541_() : this.m_20154_();
            this.m_20256_(direction.m_82490_(newSpeed));
        }
    }

    private void updateRotationFromVelocity() {
        Vec3 velocity = this.m_20184_();
        if (velocity.m_82556_() > 0.001) {
            double d0 = velocity.m_165924_();
            this.m_146922_((float)(-Mth.m_14136_((double)velocity.f_82479_, (double)velocity.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(-Mth.m_14136_((double)velocity.f_82480_, (double)d0) * 57.2957763671875));
        }
    }

    private void spawnTrailParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 pos = this.m_20182_();
            Vec3 velocity = this.m_20184_();
            Vec3 trailPos = pos.m_82546_(velocity.m_82541_().m_82490_(0.3));
            ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123777_, (double)trailPos.f_82479_, (double)trailPos.f_82480_, (double)trailPos.f_82481_, (int)3, (double)0.05, (double)0.05, (double)0.05, (double)0.001, (boolean)true);
            ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123762_, (double)trailPos.f_82479_, (double)trailPos.f_82480_, (double)trailPos.f_82481_, (int)2, (double)0.08, (double)0.08, (double)0.08, (double)0.01, (boolean)false);
            if (this.f_19797_ < 25) {
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123744_, (double)trailPos.f_82479_, (double)trailPos.f_82480_, (double)trailPos.f_82481_, (int)3, (double)0.03, (double)0.03, (double)0.03, (double)0.02, (boolean)false);
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123745_, (double)trailPos.f_82479_, (double)trailPos.f_82480_, (double)trailPos.f_82481_, (int)1, (double)0.02, (double)0.02, (double)0.02, (double)0.01, (boolean)false);
            } else if (this.f_19797_ % 2 == 0) {
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123744_, (double)trailPos.f_82479_, (double)trailPos.f_82480_, (double)trailPos.f_82481_, (int)1, (double)0.02, (double)0.02, (double)0.02, (double)0.01, (boolean)false);
            }
            if (this.f_19797_ % 5 == 0) {
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123756_, (double)trailPos.f_82479_, (double)trailPos.f_82480_, (double)trailPos.f_82481_, (int)1, (double)0.05, (double)0.05, (double)0.05, (double)0.02, (boolean)false);
            }
        }
    }

    private void explodeAndDiscard() {
        if (this.m_9236_() instanceof ServerLevel) {
            ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, (DamageSource)ModDamageTypes.causeProjectileExplosionDamage((RegistryAccess)this.m_9236_().m_9598_(), (Entity)this, (Entity)this.m_19749_()), (Entity)this, (float)this.explosionDamage, (float)this.explosionRadius);
        }
        this.m_146870_();
    }

    private void explodeWithShrapnel() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, (DamageSource)ModDamageTypes.causeProjectileExplosionDamage((RegistryAccess)this.m_9236_().m_9598_(), (Entity)this, (Entity)this.m_19749_()), (Entity)this, (float)this.explosionDamage, (float)this.explosionRadius);
            this.spawnShrapnelEffects(serverLevel);
            this.damageEntitiesWithShrapnel();
        }
        this.m_146870_();
    }

    private void spawnShrapnelEffects(ServerLevel serverLevel) {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123797_, (double)x, (double)y, (double)z, (int)100, (double)1.5, (double)1.5, (double)1.5, (double)1.2, (boolean)true);
        ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123744_, (double)x, (double)y, (double)z, (int)60, (double)1.0, (double)1.0, (double)1.0, (double)0.8, (boolean)true);
        ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123756_, (double)x, (double)y, (double)z, (int)40, (double)1.0, (double)1.0, (double)1.0, (double)0.6, (boolean)true);
        ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123755_, (double)x, (double)y, (double)z, (int)30, (double)1.0, (double)1.0, (double)1.0, (double)0.4, (boolean)true);
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11928_, SoundSource.PLAYERS, 2.0f, 0.8f);
    }

    private void damageEntitiesWithShrapnel() {
        AABB area = this.m_20191_().m_82400_(12.0);
        List entities = this.m_9236_().m_45933_((Entity)this, area);
        for (Entity entity : entities) {
            float damage;
            double dist;
            if (this.m_19749_() != null && (entity == this.m_19749_() || entity == this.m_19749_().m_20202_()) || (dist = (double)this.m_20270_(entity)) > 12.0 || !((damage = 60.0f * (float)(1.0 - dist / 12.0)) > 0.0f)) continue;
            entity.m_6469_(this.m_269291_().m_269036_((Entity)this, this.m_19749_()), damage);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            living.f_19802_ = 0;
        }
    }

    protected void m_5790_(@NotNull EntityHitResult result) {
        Entity entity = result.m_82443_();
        if (this.m_19749_() != null) {
            if (entity == this.m_19749_()) {
                return;
            }
            if (this.m_19749_().m_20202_() != null && entity == this.m_19749_().m_20202_()) {
                return;
            }
        }
        if (this.m_9236_() instanceof ServerLevel) {
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity2;
                player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
            }
            DamageHandler.doDamage((Entity)entity, (DamageSource)ModDamageTypes.causeProjectileHitDamage((RegistryAccess)this.m_9236_().m_9598_(), (Entity)this, (Entity)this.m_19749_()), (float)this.damage);
            if (entity instanceof LivingEntity) {
                entity.f_19802_ = 0;
            }
            this.explodeAndDiscard();
        }
    }

    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.m_9236_() instanceof ServerLevel) {
            BlockPos resultPos = blockHitResult.m_82425_();
            float hardness = this.m_9236_().m_8055_(resultPos).m_60734_().m_155943_();
            if (hardness != -1.0f && ((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() && ((Boolean)ExplosionConfig.EXTRA_EXPLOSION_EFFECT.get()).booleanValue()) {
                this.m_9236_().m_46961_(resultPos, true);
            }
            this.explodeAndDiscard();
        }
    }

    private PlayState movementPredicate(AnimationState<PantsirMissileEntity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.jvm.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.ROCKET_FLY.get();
    }

    public float getVolume() {
        return 0.5f;
    }

    public boolean forceLoadChunk() {
        return true;
    }

    public boolean m_20068_() {
        return true;
    }

    public float m_7139_() {
        return 0.0f;
    }

    public void setLauncherId(int id) {
        this.launcherEntityId = id;
    }

    public int getLauncherId() {
        return this.launcherEntityId;
    }

    public void setTargetEntityId(int id) {
        this.targetEntityId = id;
    }

    public int getTargetEntityId() {
        return this.targetEntityId;
    }

    public void setInitialRotation(Vec3 direction) {
        double horizontalDist = Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
        float yaw = (float)(-Math.atan2(direction.f_82479_, direction.f_82481_) * 180.0 / Math.PI);
        float pitch = (float)(-Math.atan2(direction.f_82480_, horizontalDist) * 180.0 / Math.PI);
        this.m_146922_(yaw);
        this.m_146926_(pitch);
        this.f_19859_ = yaw;
        this.f_19860_ = pitch;
    }
}

