/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.client.hud;

import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tech.vvp.vvp.client.ThermalVisionHandler;
import tech.vvp.vvp.entity.vehicle.Bmp2Entity;
import tech.vvp.vvp.entity.vehicle.Bmp2MEntity;
import tech.vvp.vvp.entity.vehicle.Btr4Entity;
import tech.vvp.vvp.entity.vehicle.M1A2Entity;
import tech.vvp.vvp.entity.vehicle.M1A2SepEntity;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="vvp", value={Dist.CLIENT})
public class ReticleOverlay {
    private static final Map<Class<? extends VehicleEntity>, Map<Integer, ReticleConfig>> RETICLE_CONFIGS = new HashMap<Class<? extends VehicleEntity>, Map<Integer, ReticleConfig>>();
    private static final ResourceLocation NOISE_TEXTURE = new ResourceLocation("vvp", "textures/reticles/noise1.png");
    private static final ResourceLocation COMPASS = new ResourceLocation("superbwarfare", "textures/overlay/vehicle/base/compass.png");
    private static final ResourceLocation ROLL_IND = new ResourceLocation("superbwarfare", "textures/overlay/vehicle/helicopter/roll_ind.png");
    private static final ResourceLocation BARREL = new ResourceLocation("superbwarfare", "textures/overlay/vehicle/land/line.png");
    private static final ResourceLocation BODY = new ResourceLocation("superbwarfare", "textures/overlay/vehicle/land/body.png");
    private static final ResourceLocation LEFT_WHEEL = new ResourceLocation("superbwarfare", "textures/overlay/vehicle/land/left_wheel.png");
    private static final ResourceLocation RIGHT_WHEEL = new ResourceLocation("superbwarfare", "textures/overlay/vehicle/land/right_wheel.png");
    private static final ResourceLocation ENGINE = new ResourceLocation("superbwarfare", "textures/overlay/vehicle/land/engine.png");
    private static final ResourceLocation TV_FRAME = new ResourceLocation("vvp", "textures/overlay/tv_frame.png");
    private static final ResourceLocation CHOSEN = new ResourceLocation("superbwarfare", "textures/gui/attachment/chosen.png");
    private static final ResourceLocation NOT_CHOSEN = new ResourceLocation("superbwarfare", "textures/gui/attachment/not_chosen.png");
    private static int noiseTimer = 0;
    private static int noiseDuration = 12;
    private static float noiseOffsetX = 0.0f;
    private static float noiseOffsetY = 0.0f;
    private static final Random random = new Random();
    private static boolean wasInVehicle = false;
    private static double lastRecoilShake = 0.0;
    private static final Map<String, Integer> lastShootAnimTimers = new HashMap<String, Integer>();
    private static boolean digitalSightActive = false;
    private static final int HUD_COLOR = 0x66FF00;
    private static final int HUD_COLOR_RED = 0xFF0000;

    private static void registerReticleConfigs() {
        ReticleOverlay.registerConfig(M1A2Entity.class, 0, new ReticleConfig().setOutline("vvp:textures/reticles/outline_digital-4x3.png").setReticle("vvp:textures/reticles/abrams_main.png").setReticleColor(1.0f, 1.0f, 1.0f, 1.0f).setReticleScale(1.0f).setZoomScale(1.5f).setNoiseEnabled(true).setDigital(true).setNoiseDuration(15).setNoiseAlpha(0.3f).setSeatIndex(0).setHudRightSide(false));
        ReticleOverlay.registerConfig(M1A2Entity.class, 1, new ReticleConfig().setOutline("vvp:textures/reticles/outline_stryker-rws.png").setReticle("vvp:textures/reticles/pn-b.png").setReticleColor(1.0f, 1.0f, 1.0f, 1.0f).setReticleScale(1.0f).setZoomScale(1.5f).setNoiseEnabled(true).setDigital(true).setNoiseDuration(15).setNoiseAlpha(0.3f).setSeatIndex(1).setHudRightSide(true));
        ReticleOverlay.registerConfig(M1A2SepEntity.class, 0, new ReticleConfig().setOutline("vvp:textures/reticles/outline_digital-4x3.png").setReticle("vvp:textures/reticles/abrams_main.png").setReticleColor(1.0f, 1.0f, 1.0f, 1.0f).setReticleScale(1.0f).setZoomScale(1.5f).setNoiseEnabled(true).setDigital(true).setNoiseDuration(15).setNoiseAlpha(0.3f).setSeatIndex(0).setHudRightSide(false));
        ReticleOverlay.registerConfig(M1A2SepEntity.class, 1, new ReticleConfig().setOutline("vvp:textures/reticles/outline_stryker-rws.png").setReticle("vvp:textures/reticles/pn-b.png").setReticleColor(1.0f, 1.0f, 1.0f, 1.0f).setReticleScale(1.0f).setZoomScale(1.5f).setDigital(true).setNoiseEnabled(true).setNoiseDuration(15).setNoiseAlpha(0.3f).setSeatIndex(1).setHudRightSide(true));
        ReticleOverlay.registerConfig(Btr4Entity.class, 0, new ReticleConfig().setOutline("vvp:textures/reticles/outline_sosna-u-thermal.png").setReticle("vvp:textures/reticles/sosna-u_4x.png").setReticleColor(1.0f, 1.0f, 1.0f, 1.0f).setReticleScale(1.0f).setZoomScale(3.0f).setNoiseEnabled(true).setDigital(true).setZoomScale(1.5f).setNoiseDuration(15).setNoiseAlpha(0.3f).setSeatIndex(0).setHudRightSide(false).setThermalReticle4x("vvp:textures/reticles/sosna-u-thermal_4x.png").setThermalReticle12x("vvp:textures/reticles/sosna-u-thermal_12x.png").setThermalOutline("vvp:textures/reticles/outline_sosna-u-thermal.png"));
        ReticleOverlay.registerConfig(Bmp2Entity.class, 0, new ReticleConfig().setOutline("vvp:textures/reticles/outline_digital-4x3.png").setReticle("vvp:textures/reticles/bmp2_2a42_zoom.png").setWeaponReticle("Cannon", "vvp:textures/reticles/bmp2_2a42_zoom.png").setWeaponReticle("Missile", "vvp:textures/reticles/bmp2_atgm_zoom.png").setReticleColor(1.0f, 1.0f, 1.0f, 1.0f).setReticleScale(1.33f).setThermalVisionAllowed(false).setZoomScale(1.5f).setNoiseEnabled(false).setNoiseDuration(15).setNoiseAlpha(0.3f).setSeatIndex(0).setHudRightSide(false));
        ReticleOverlay.registerConfig(Bmp2MEntity.class, 0, new ReticleConfig().setOutline("vvp:textures/reticles/outline_kord-rws.png").setReticle("vvp:textures/reticles/bmp2_2a42_zoom.png").setWeaponReticle("Cannon", "vvp:textures/reticles/bmp2_2a42_zoom.png").setWeaponReticle("Missile", "vvp:textures/reticles/bmp2_atgm_zoom.png").setReticleColor(1.0f, 1.0f, 1.0f, 1.0f).setReticleScale(1.0f).setZoomScale(1.5f).setThermalVisionAllowed(true).setNoiseEnabled(true).setDigital(true).setNoiseDuration(15).setNoiseAlpha(0.3f).setSeatIndex(0).setHudRightSide(false));
    }

    public static void registerConfig(Class<? extends VehicleEntity> vehicleClass, int seatIndex, ReticleConfig config) {
        RETICLE_CONFIGS.computeIfAbsent(vehicleClass, k -> new HashMap()).put(seatIndex, config);
    }

    @SubscribeEvent
    public static void onRenderGuiPre(RenderGuiEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91066_.f_92062_) {
            return;
        }
        boolean isFirstPerson = mc.f_91066_.m_92176_().m_90612_();
        boolean isZooming = ClientEventHandler.zoomVehicle;
        if (!isFirstPerson && !isZooming) {
            return;
        }
        Entity vehicle = player.m_20202_();
        if (!(vehicle instanceof VehicleEntity)) {
            return;
        }
        VehicleEntity vehicleEntity = (VehicleEntity)vehicle;
        int seatIndex = vehicleEntity.getSeatIndex((Entity)player);
        if (seatIndex < 0) {
            return;
        }
        ReticleConfig config = ReticleOverlay.getConfigForVehicle(vehicleEntity, seatIndex);
        if (config == null) {
            return;
        }
        if (seatIndex != config.seatIndex) {
            return;
        }
        ReticleOverlay.renderReticle(event.getGuiGraphics(), config, isZooming, vehicleEntity, (Player)player, event.getPartialTick());
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        boolean shouldBeDigital;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (noiseTimer > 0) {
            --noiseTimer;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            ReticleOverlay.resetState();
            return;
        }
        Entity vehicle = player.m_20202_();
        if (!(vehicle instanceof VehicleEntity)) {
            if (wasInVehicle) {
                ReticleOverlay.resetState();
            }
            wasInVehicle = false;
            return;
        }
        VehicleEntity vehicleEntity = (VehicleEntity)vehicle;
        int seatIndex = vehicleEntity.getSeatIndex((Entity)player);
        if (seatIndex < 0) {
            wasInVehicle = false;
            return;
        }
        ReticleConfig config = ReticleOverlay.getConfigForVehicle(vehicleEntity, seatIndex);
        if (config == null) {
            wasInVehicle = false;
            if (digitalSightActive) {
                ReticleOverlay.applyDigitalSightShader(false);
            }
            return;
        }
        wasInVehicle = true;
        if (seatIndex != config.seatIndex) {
            if (digitalSightActive) {
                ReticleOverlay.applyDigitalSightShader(false);
            }
            return;
        }
        boolean bl = shouldBeDigital = config.isDigital && !ThermalVisionHandler.isThermalVisionEnabled();
        if (shouldBeDigital != digitalSightActive) {
            ReticleOverlay.applyDigitalSightShader(shouldBeDigital);
        } else if (ThermalVisionHandler.isThermalVisionEnabled() && digitalSightActive) {
            ReticleOverlay.applyDigitalSightShader(false);
        }
        if (config.noiseEnabled && config.isDigital) {
            ReticleOverlay.detectShot(vehicleEntity, (Player)player, config);
        }
    }

    private static void detectShot(VehicleEntity vehicle, Player player, ReticleConfig config) {
        try {
            int seatIndex = vehicle.getSeatIndex((Entity)player);
            if (seatIndex < 0) {
                return;
            }
            GunData gunData = vehicle.getGunData((Entity)player);
            if (gunData == null) {
                return;
            }
            int currentShootAnimTimer = gunData.shootAnimationTimer.get();
            String key = seatIndex + "_current";
            Integer lastTimer = lastShootAnimTimers.get(key);
            int maxTimer = gunData.compute().shootAnimationTime;
            if (currentShootAnimTimer > 0) {
                if (lastTimer == null) {
                    lastShootAnimTimers.put(key, currentShootAnimTimer);
                } else if (currentShootAnimTimer > lastTimer || currentShootAnimTimer == maxTimer && lastTimer < maxTimer) {
                    ReticleOverlay.triggerNoiseEffect(config.noiseDuration);
                    lastShootAnimTimers.put(key, currentShootAnimTimer);
                } else {
                    lastShootAnimTimers.put(key, currentShootAnimTimer);
                }
            } else {
                lastShootAnimTimers.put(key, 0);
            }
            double currentRecoil = vehicle.getRecoilShake();
            if (currentRecoil > lastRecoilShake + 0.3 && currentRecoil > 0.5 && currentShootAnimTimer == 0) {
                ReticleOverlay.triggerNoiseEffect(config.noiseDuration);
            }
            lastRecoilShake = currentRecoil;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void renderReticle(GuiGraphics guiGraphics, ReticleConfig config, boolean isZooming, VehicleEntity vehicle, Player player, float partialTick) {
        ResourceLocation outlineToUse;
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        PoseStack poseStack = guiGraphics.m_280168_();
        if (config.noiseEnabled && config.isDigital && noiseTimer > 0) {
            poseStack.m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            ReticleOverlay.renderNoiseEffect(guiGraphics, screenWidth, screenHeight, poseStack, config);
            poseStack.m_85849_();
        }
        if (config.reticleTexture != null || ThermalVisionHandler.isThermalVisionEnabled() && config.hasThermalReticle() || !config.weaponReticles.isEmpty() || !config.thermalWeaponReticles.isEmpty()) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::m_172817_);
            ReticleOverlay.renderMainReticle(guiGraphics, config, screenWidth, screenHeight, isZooming, vehicle, player);
        }
        if (config.isDigital && digitalSightActive && !ThermalVisionHandler.isThermalVisionEnabled()) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ReticleOverlay.renderDigitalScopeFrame(guiGraphics, screenWidth, screenHeight);
        }
        ResourceLocation resourceLocation = outlineToUse = ThermalVisionHandler.isThermalVisionEnabled() && config.thermalOutlineTexture != null ? config.thermalOutlineTexture : config.outlineTexture;
        if (outlineToUse != null) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ReticleOverlay.renderOutline(guiGraphics, outlineToUse, screenWidth, screenHeight, config.outlineScale);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.m_85836_();
        ReticleOverlay.renderCustomHud(guiGraphics, poseStack, vehicle, player, screenWidth, screenHeight, partialTick, config);
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void renderCustomHud(GuiGraphics guiGraphics, PoseStack poseStack, VehicleEntity vehicle, Player player, int screenWidth, int screenHeight, float partialTick, ReticleConfig config) {
        Minecraft mc = Minecraft.m_91087_();
        boolean hudRightSide = config != null && config.hudRightSide;
        int leftX = hudRightSide ? screenWidth - 200 : 10;
        int rightX = hudRightSide ? screenWidth - 10 : screenWidth - 80;
        int bottomLeftY = screenHeight - 135;
        int bottomRightY = screenHeight - 70;
        int centerX = screenWidth / 2;
        ReticleOverlay.renderCompass(guiGraphics, poseStack, player, screenWidth);
        int hpX = hudRightSide ? rightX - 100 : leftX;
        int hpY = bottomLeftY;
        int healthPercent = (int)(vehicle.getHealth() / vehicle.getMaxHealth() * 100.0f);
        int healthColor = ReticleOverlay.getGradientColor(0x66FF00, 0xFF0000, 100 - healthPercent, 2);
        String hpText = "HP: " + healthPercent;
        int hpTextWidth = mc.f_91062_.m_92895_(hpText);
        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)hpText), hudRightSide ? hpX - hpTextWidth : hpX, hpY, healthColor, false);
        try {
            if (vehicle.hasDecoy() && player == vehicle.m_146895_()) {
                String smokeKey = ModKeyMappings.RELEASE_DECOY.getKey().m_84875_().getString();
                boolean decoyReady = ReticleOverlay.getEntityDataBoolean(vehicle, "DECOY_READY");
                Object smokeText = decoyReady ? "SMOKE READY [" + smokeKey + "]" : "SMOKE RELOADING";
                int smokeColor = decoyReady ? 0x66FF00 : 0xFF0000;
                int smokeTextWidth = mc.f_91062_.m_92895_((String)smokeText);
                guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)smokeText), hudRightSide ? hpX - smokeTextWidth : hpX, hpY + 12, smokeColor, false);
            }
        }
        catch (Exception smokeKey) {
            // empty catch block
        }
        try {
            boolean canConsume = (Boolean)vehicle.getClass().getMethod("canConsume", Integer.TYPE).invoke((Object)vehicle, 1);
            if (!canConsume) {
                String powerText = "NO POWER!";
                int powerTextWidth = mc.f_91062_.m_92895_(powerText);
                guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)powerText), hudRightSide ? hpX - powerTextWidth : hpX, hpY + 24, 0xFF0000, false);
            }
        }
        catch (Exception canConsume) {
            // empty catch block
        }
        if (ThermalVisionHandler.isThermalVisionEnabled()) {
            String tpvText = "\u0422\u041f\u0412";
            int tpvTextWidth = mc.f_91062_.m_92895_(tpvText);
            guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)tpvText), hudRightSide ? hpX - tpvTextWidth : hpX, hpY - 12, 0x66FF00, false);
        }
        double speed = vehicle.m_20184_().m_82526_(vehicle.m_20252_(partialTick)) * 72.0;
        String speedText = String.format("%.0f km/h", Math.abs(speed));
        int speedWidth = mc.f_91062_.m_92895_(speedText);
        int speedX = hudRightSide ? leftX : rightX - speedWidth;
        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)speedText), speedX, bottomRightY, 0x66FF00, false);
        double distance = ReticleOverlay.calculateDistance(player);
        String distanceText = distance > 500.0 ? "---m" : String.format("%.0f m", distance);
        int distWidth = mc.f_91062_.m_92895_(distanceText);
        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)distanceText), centerX - distWidth / 2, screenHeight - 50, 0x66FF00, false);
        ReticleOverlay.renderVehicleStatus(guiGraphics, poseStack, vehicle, screenWidth, screenHeight, partialTick, config);
        ReticleOverlay.renderWeaponInfo(guiGraphics, vehicle, player, screenWidth, screenHeight, mc);
        ReticleOverlay.renderAmmoSelection(guiGraphics, vehicle, player, screenWidth, screenHeight, mc);
    }

    private static void renderCompass(GuiGraphics guiGraphics, PoseStack poseStack, Player player, int screenWidth) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float yaw = player.m_146908_();
        int u = (int)(128.0f + 1.4222223f * yaw);
        int compassX = screenWidth / 2 - 128;
        int compassY = 10;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)COMPASS);
        guiGraphics.m_280163_(COMPASS, compassX, compassY, (float)u, 0.0f, 256, 16, 512, 16);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ROLL_IND);
        guiGraphics.m_280163_(ROLL_IND, screenWidth / 2 - 8, 30, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private static void renderVehicleStatus(GuiGraphics guiGraphics, PoseStack poseStack, VehicleEntity vehicle, int screenWidth, int screenHeight, float partialTick, ReticleConfig config) {
        float wheelMaxH;
        boolean hudRightSide = config != null && config.hudRightSide;
        int statusX = hudRightSide ? screenWidth - 42 : 10;
        int statusY = screenHeight - 190;
        float centerX = (float)statusX + 16.0f;
        float centerY = (float)statusY + 16.0f;
        float turretYaw = ReticleOverlay.getTurretYaw(vehicle, partialTick);
        int turretDamage = 0;
        try {
            float turretH = ReticleOverlay.getEntityDataFloat(vehicle, "TURRET_HEALTH");
            float turretMaxH = vehicle.getTurretMaxHealth();
            turretDamage = (int)((1.0f - turretH / turretMaxH) * 100.0f);
        }
        catch (Exception turretH) {
            // empty catch block
        }
        int barrelColor = ReticleOverlay.getGradientColor(0x66FF00, 0xFF0000, turretDamage, 2);
        ReticleOverlay.setShaderColorFromInt(barrelColor);
        RenderHelper.preciseBlit((GuiGraphics)guiGraphics, (ResourceLocation)BARREL, (float)(centerX - 0.5f), (float)((float)statusY - 3.0f), (float)0.0f, (float)0.0f, (float)1.0f, (float)16.0f, (float)1.0f, (float)16.0f);
        poseStack.m_85836_();
        poseStack.m_252880_(centerX, centerY, 0.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(turretYaw));
        poseStack.m_252880_(-centerX, -centerY, 0.0f);
        float bodyHealthPercent = vehicle.getHealth() / vehicle.getMaxHealth();
        int bodyDamage = (int)((1.0f - bodyHealthPercent) * 100.0f);
        int bodyColor = ReticleOverlay.getGradientColor(0x66FF00, 0xFF0000, bodyDamage, 2);
        ReticleOverlay.setShaderColorFromInt(bodyColor);
        guiGraphics.m_280163_(BODY, statusX, statusY, 0.0f, 0.0f, 32, 32, 32, 32);
        try {
            float leftWheelH = ReticleOverlay.getEntityDataFloat(vehicle, "L_WHEEL_HEALTH");
            wheelMaxH = vehicle.getWheelMaxHealth();
            int leftWheelDamage = (int)((1.0f - leftWheelH / wheelMaxH) * 100.0f);
            int leftColor = ReticleOverlay.getGradientColor(0x66FF00, 0xFF0000, leftWheelDamage, 2);
            ReticleOverlay.setShaderColorFromInt(leftColor);
            guiGraphics.m_280163_(LEFT_WHEEL, statusX, statusY, 0.0f, 0.0f, 32, 32, 32, 32);
        }
        catch (Exception e) {
            ReticleOverlay.setShaderColorFromInt(0x66FF00);
            guiGraphics.m_280163_(LEFT_WHEEL, statusX, statusY, 0.0f, 0.0f, 32, 32, 32, 32);
        }
        try {
            float rightWheelH = ReticleOverlay.getEntityDataFloat(vehicle, "R_WHEEL_HEALTH");
            wheelMaxH = vehicle.getWheelMaxHealth();
            int rightWheelDamage = (int)((1.0f - rightWheelH / wheelMaxH) * 100.0f);
            int rightColor = ReticleOverlay.getGradientColor(0x66FF00, 0xFF0000, rightWheelDamage, 2);
            ReticleOverlay.setShaderColorFromInt(rightColor);
            guiGraphics.m_280163_(RIGHT_WHEEL, statusX, statusY, 0.0f, 0.0f, 32, 32, 32, 32);
        }
        catch (Exception e) {
            ReticleOverlay.setShaderColorFromInt(0x66FF00);
            guiGraphics.m_280163_(RIGHT_WHEEL, statusX, statusY, 0.0f, 0.0f, 32, 32, 32, 32);
        }
        try {
            float engineH = ReticleOverlay.getEntityDataFloat(vehicle, "MAIN_ENGINE_HEALTH");
            float engineMaxH = vehicle.getEngineMaxHealth();
            int engineDamage = (int)((1.0f - engineH / engineMaxH) * 100.0f);
            int engineColor = ReticleOverlay.getGradientColor(0x66FF00, 0xFF0000, engineDamage, 2);
            ReticleOverlay.setShaderColorFromInt(engineColor);
            guiGraphics.m_280163_(ENGINE, statusX, statusY, 0.0f, 0.0f, 32, 32, 32, 32);
        }
        catch (Exception e) {
            ReticleOverlay.setShaderColorFromInt(0x66FF00);
            guiGraphics.m_280163_(ENGINE, statusX, statusY, 0.0f, 0.0f, 32, 32, 32, 32);
        }
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static float getTurretYaw(VehicleEntity vehicle, float partialTick) {
        try {
            Field turretYRotField = VehicleEntity.class.getDeclaredField("turretYRot");
            Field turretYRotOField = VehicleEntity.class.getDeclaredField("turretYRotO");
            turretYRotField.setAccessible(true);
            turretYRotOField.setAccessible(true);
            float turretYRot = turretYRotField.getFloat(vehicle);
            float turretYRotO = turretYRotOField.getFloat(vehicle);
            return Mth.m_14179_((float)partialTick, (float)turretYRotO, (float)turretYRot);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    private static float getEntityDataFloat(VehicleEntity vehicle, String accessorFieldName) {
        try {
            Field field = VehicleEntity.class.getDeclaredField(accessorFieldName);
            field.setAccessible(true);
            EntityDataAccessor accessor = (EntityDataAccessor)field.get(null);
            return ((Float)vehicle.m_20088_().m_135370_(accessor)).floatValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean getEntityDataBoolean(VehicleEntity vehicle, String accessorFieldName) {
        try {
            Field field = VehicleEntity.class.getDeclaredField(accessorFieldName);
            field.setAccessible(true);
            EntityDataAccessor accessor = (EntityDataAccessor)field.get(null);
            return (Boolean)vehicle.m_20088_().m_135370_(accessor);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static float getFieldFloat(Object obj, String fieldName) {
        try {
            Field field = obj.getClass().getField(fieldName);
            return field.getFloat(obj);
        }
        catch (NoSuchFieldException e) {
            try {
                Field field = obj.getClass().getSuperclass().getField(fieldName);
                return field.getFloat(obj);
            }
            catch (Exception ex) {
                return 0.0f;
            }
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    private static void renderWeaponInfo(GuiGraphics guiGraphics, VehicleEntity vehicle, Player player, int screenWidth, int screenHeight, Minecraft mc) {
        try {
            GunData gunData = vehicle.getGunData((Entity)player);
            if (gunData != null) {
                Component weaponComponent = vehicle.firstPersonAmmoComponent(gunData, player);
                int heat = vehicle.getWeaponHeat((LivingEntity)player);
                int weaponColor = ReticleOverlay.getGradientColor(0x66FF00, 0xFF0000, heat, 2);
                int textWidth = mc.f_91062_.m_92852_((FormattedText)weaponComponent);
                guiGraphics.m_280614_(mc.f_91062_, weaponComponent, (screenWidth - textWidth) / 2, screenHeight - 65, weaponColor, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void renderAmmoSelection(GuiGraphics guiGraphics, VehicleEntity vehicle, Player player, int screenWidth, int screenHeight, Minecraft mc) {
        try {
            GunData gunData = vehicle.getGunData((Entity)player);
            if (gunData == null) {
                return;
            }
            DefaultGunData data = gunData.compute();
            List ammoConsumers = data.getAmmoConsumers();
            int size = ammoConsumers.size();
            if (size <= 1) {
                return;
            }
            int selectedIndex = gunData.selectedAmmoType.get();
            int startX = screenWidth - 60;
            int startY = 30;
            for (int i = 0; i < size; ++i) {
                ResourceLocation indicator = i == selectedIndex ? CHOSEN : NOT_CHOSEN;
                int x = startX + i * 6;
                int y = startY;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                guiGraphics.m_280163_(indicator, x, y, 0.0f, 0.0f, 4, 4, 4, 4);
            }
            String switchKey = ModKeyMappings.FIRE_MODE.getKey().m_84875_().getString();
            String switchText = "[" + switchKey + "]";
            int textWidth = mc.f_91062_.m_92895_(switchText);
            guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)switchText), startX - textWidth / 2, startY + 8, 0xFFFFFF, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static double calculateDistance(Player player) {
        try {
            BlockHitResult result = player.m_9236_().m_45547_(new ClipContext(player.m_146892_(), player.m_146892_().m_82549_(player.m_20252_(1.0f).m_82490_(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            return player.m_20299_(1.0f).m_82554_(result.m_82450_());
        }
        catch (Exception e) {
            return 999.0;
        }
    }

    private static int getGradientColor(int startColor, int endColor, int percent, int power) {
        percent = Math.max(0, Math.min(100, percent));
        double ratio = Math.pow((double)percent / 100.0, power);
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        int r = (int)((double)startR + (double)(endR - startR) * ratio);
        int g = (int)((double)startG + (double)(endG - startG) * ratio);
        int b = (int)((double)startB + (double)(endB - startB) * ratio);
        return r << 16 | g << 8 | b;
    }

    private static void setShaderColorFromInt(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
    }

    private static void renderOutline(GuiGraphics guiGraphics, ResourceLocation outlineTexture, int screenWidth, int screenHeight, float outlineScale) {
        int targetWidth;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.preciseBlit((GuiGraphics)guiGraphics, (ResourceLocation)outlineTexture, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)screenWidth, (float)screenHeight, (float)screenWidth, (float)screenHeight);
        if (outlineTexture.m_135815_().contains("outline_digital-4x3") && (targetWidth = (int)((double)screenHeight * 4.0 / 3.0)) < screenWidth) {
            int blackBarWidth = (screenWidth - targetWidth) / 2;
            guiGraphics.m_280509_(0, 0, blackBarWidth, screenHeight, -16777216);
            guiGraphics.m_280509_(screenWidth - blackBarWidth, 0, screenWidth, screenHeight, -16777216);
        }
    }

    private static void renderDigitalScopeFrame(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        int textureWidth = 1920;
        int textureHeight = 1080;
        guiGraphics.m_280411_(TV_FRAME, 0, 0, screenWidth, screenHeight, 0.0f, 0.0f, textureWidth, textureHeight, textureWidth, textureHeight);
    }

    private static void renderMainReticle(GuiGraphics guiGraphics, ReticleConfig config, int screenWidth, int screenHeight, boolean isZooming, VehicleEntity vehicle, Player player) {
        RenderSystem.setShaderColor((float)config.reticleColorR, (float)config.reticleColorG, (float)config.reticleColorB, (float)config.reticleColorA);
        ResourceLocation reticleToUse = null;
        boolean isThermalVision = ThermalVisionHandler.isThermalVisionEnabled();
        String weaponName = null;
        if (vehicle != null && player != null) {
            try {
                weaponName = vehicle.getGunName(vehicle.getSeatIndex((Entity)player));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (isThermalVision && weaponName != null && !config.thermalWeaponReticles.isEmpty() && config.thermalWeaponReticles.containsKey(weaponName)) {
            reticleToUse = config.thermalWeaponReticles.get(weaponName);
        }
        if (reticleToUse == null && weaponName != null && !config.weaponReticles.isEmpty() && config.weaponReticles.containsKey(weaponName)) {
            reticleToUse = config.weaponReticles.get(weaponName);
        }
        if (reticleToUse == null && isThermalVision && config.hasThermalReticle()) {
            if (isZooming && config.thermalReticleTexture12x != null) {
                reticleToUse = config.thermalReticleTexture12x;
            } else if (config.thermalReticleTexture4x != null) {
                reticleToUse = config.thermalReticleTexture4x;
            }
        }
        if (reticleToUse == null) {
            reticleToUse = config.reticleTexture;
        }
        if (reticleToUse != null) {
            RenderHelper.preciseBlit((GuiGraphics)guiGraphics, (ResourceLocation)reticleToUse, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)screenWidth, (float)screenHeight, (float)screenWidth, (float)screenHeight);
        }
    }

    private static void renderNoiseEffect(GuiGraphics guiGraphics, int screenWidth, int screenHeight, PoseStack poseStack, ReticleConfig config) {
        float alpha = (float)noiseTimer / (float)noiseDuration * config.noiseAlpha;
        if (noiseTimer % 2 == 0) {
            noiseOffsetX = random.nextFloat() * 256.0f;
            noiseOffsetY = random.nextFloat() * 256.0f;
        }
        poseStack.m_85836_();
        float shakeX = (random.nextFloat() - 0.5f) * 4.0f;
        float shakeY = (random.nextFloat() - 0.5f) * 4.0f;
        poseStack.m_252880_(shakeX, shakeY, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)NOISE_TEXTURE);
        int tileSize = 256;
        for (int tx = 0; tx < screenWidth + tileSize; tx += tileSize) {
            for (int ty = 0; ty < screenHeight + tileSize; ty += tileSize) {
                int offsetX = (int)(((float)tx + noiseOffsetX) % (float)tileSize);
                int offsetY = (int)(((float)ty + noiseOffsetY) % (float)tileSize);
                guiGraphics.m_280163_(NOISE_TEXTURE, tx - offsetX, ty - offsetY, 0.0f, 0.0f, tileSize, tileSize, tileSize, tileSize);
            }
        }
        poseStack.m_85849_();
    }

    private static ReticleConfig getConfigForVehicle(VehicleEntity vehicle, int seatIndex) {
        ReticleConfig config;
        Map<Integer, ReticleConfig> seatConfigs = RETICLE_CONFIGS.get(vehicle.getClass());
        if (seatConfigs != null && (config = seatConfigs.get(seatIndex)) != null) {
            return config;
        }
        for (Map.Entry<Class<? extends VehicleEntity>, Map<Integer, ReticleConfig>> entry : RETICLE_CONFIGS.entrySet()) {
            ReticleConfig config2;
            if (!entry.getKey().isInstance(vehicle) || (config2 = entry.getValue().get(seatIndex)) == null) continue;
            return config2;
        }
        return null;
    }

    public static void triggerNoiseEffect(int duration) {
        noiseTimer = duration;
        noiseDuration = duration;
        noiseOffsetX = random.nextFloat() * 256.0f;
        noiseOffsetY = random.nextFloat() * 256.0f;
    }

    private static void applyDigitalSightShader(boolean enable) {
        digitalSightActive = enable;
    }

    private static void debugLog(String location, String message, Map<String, Object> data, String hypothesisId) {
        try {
            Path logPath = Paths.get("c:\\Users\\kniki\\OneDrive\\Desktop\\pack\\vvp-sourve\\.cursor\\debug.log", new String[0]);
            StringBuilder dataJson = new StringBuilder("{");
            if (data != null && !data.isEmpty()) {
                boolean first = true;
                for (Map.Entry<String, Object> entry : data.entrySet()) {
                    if (!first) {
                        dataJson.append(",");
                    }
                    first = false;
                    Object value = entry.getValue();
                    Object valueStr = value instanceof String ? "\"" + value.toString().replace("\"", "\\\"") + "\"" : (value instanceof Boolean || value instanceof Number ? value.toString() : "\"" + String.valueOf(value).replace("\"", "\\\"") + "\"");
                    dataJson.append("\"").append(entry.getKey()).append("\":").append((String)valueStr);
                }
            }
            dataJson.append("}");
            String logEntry = String.format("{\"id\":\"%s\",\"timestamp\":%d,\"location\":\"%s\",\"message\":\"%s\",\"data\":%s,\"sessionId\":\"debug-session\",\"runId\":\"run1\",\"hypothesisId\":\"%s\"}\n", UUID.randomUUID().toString(), Instant.now().toEpochMilli(), location.replace("\\", "\\\\").replace("\"", "\\\""), message.replace("\\", "\\\\").replace("\"", "\\\""), dataJson.toString(), hypothesisId);
            Files.write(logPath, logEntry.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void resetState() {
        noiseTimer = 0;
        lastRecoilShake = 0.0;
        lastShootAnimTimers.clear();
        if (digitalSightActive) {
            ReticleOverlay.applyDigitalSightShader(false);
        }
    }

    public static boolean hasCustomReticle(Class<? extends VehicleEntity> vehicleClass) {
        Map<Integer, ReticleConfig> seatConfigs;
        Minecraft mc = Minecraft.m_91087_();
        boolean isFirstPerson = mc.f_91066_.m_92176_().m_90612_();
        boolean isZooming = ClientEventHandler.zoomVehicle;
        if (!isFirstPerson && !isZooming) {
            return false;
        }
        if (RETICLE_CONFIGS.containsKey(vehicleClass) && (seatConfigs = RETICLE_CONFIGS.get(vehicleClass)) != null && !seatConfigs.isEmpty()) {
            return true;
        }
        for (Map.Entry<Class<? extends VehicleEntity>, Map<Integer, ReticleConfig>> entry : RETICLE_CONFIGS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(vehicleClass) || entry.getValue() == null || entry.getValue().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isThermalVisionAllowed(VehicleEntity vehicle, int seatIndex) {
        ReticleConfig config = ReticleOverlay.getConfigForVehicle(vehicle, seatIndex);
        if (config == null) {
            return true;
        }
        return config.thermalVisionAllowed;
    }

    static {
        ReticleOverlay.registerReticleConfigs();
    }

    public static class ReticleConfig {
        ResourceLocation outlineTexture;
        ResourceLocation reticleTexture;
        ResourceLocation thermalReticleTexture4x;
        ResourceLocation thermalReticleTexture12x;
        ResourceLocation thermalOutlineTexture;
        Map<String, ResourceLocation> weaponReticles = new HashMap<String, ResourceLocation>();
        Map<String, ResourceLocation> thermalWeaponReticles = new HashMap<String, ResourceLocation>();
        float reticleColorR = 1.0f;
        float reticleColorG = 1.0f;
        float reticleColorB = 1.0f;
        float reticleColorA = 1.0f;
        float reticleScale = 1.0f;
        float zoomScale = 1.5f;
        float outlineScale = 1.0f;
        boolean noiseEnabled = false;
        int noiseDuration = 15;
        float noiseAlpha = 0.3f;
        int seatIndex = 0;
        boolean hudRightSide = false;
        boolean thermalVisionAllowed = true;
        boolean isDigital = false;
        boolean fullscreenReticle = true;

        public ReticleConfig setOutline(String path) {
            this.outlineTexture = new ResourceLocation(path.split(":")[0], path.split(":")[1]);
            return this;
        }

        public ReticleConfig setReticle(String path) {
            this.reticleTexture = new ResourceLocation(path.split(":")[0], path.split(":")[1]);
            return this;
        }

        public ReticleConfig setReticleColor(float r, float g, float b, float a) {
            this.reticleColorR = r;
            this.reticleColorG = g;
            this.reticleColorB = b;
            this.reticleColorA = a;
            return this;
        }

        public ReticleConfig setReticleScale(float scale) {
            this.reticleScale = scale;
            return this;
        }

        public ReticleConfig setNoiseEnabled(boolean enabled) {
            this.noiseEnabled = enabled;
            return this;
        }

        public ReticleConfig setNoiseDuration(int ticks) {
            this.noiseDuration = ticks;
            return this;
        }

        public ReticleConfig setNoiseAlpha(float alpha) {
            this.noiseAlpha = alpha;
            return this;
        }

        public ReticleConfig setSeatIndex(int index) {
            this.seatIndex = index;
            return this;
        }

        public ReticleConfig setZoomScale(float scale) {
            this.zoomScale = scale;
            return this;
        }

        public ReticleConfig setHudRightSide(boolean rightSide) {
            this.hudRightSide = rightSide;
            return this;
        }

        public ReticleConfig setThermalReticle4x(String path) {
            this.thermalReticleTexture4x = new ResourceLocation(path.split(":")[0], path.split(":")[1]);
            return this;
        }

        public ReticleConfig setThermalReticle12x(String path) {
            this.thermalReticleTexture12x = new ResourceLocation(path.split(":")[0], path.split(":")[1]);
            return this;
        }

        public ReticleConfig setThermalOutline(String path) {
            this.thermalOutlineTexture = new ResourceLocation(path.split(":")[0], path.split(":")[1]);
            return this;
        }

        public boolean hasThermalReticle() {
            return this.thermalReticleTexture4x != null || this.thermalReticleTexture12x != null;
        }

        public ReticleConfig setWeaponReticle(String weaponName, String path) {
            this.weaponReticles.put(weaponName, new ResourceLocation(path.split(":")[0], path.split(":")[1]));
            return this;
        }

        public ReticleConfig setOutlineScale(float scale) {
            this.outlineScale = scale;
            return this;
        }

        public ReticleConfig setThermalWeaponReticle(String weaponName, String path) {
            this.thermalWeaponReticles.put(weaponName, new ResourceLocation(path.split(":")[0], path.split(":")[1]));
            return this;
        }

        public ReticleConfig setThermalVisionAllowed(boolean allowed) {
            this.thermalVisionAllowed = allowed;
            return this;
        }

        public ReticleConfig setDigital(boolean digital) {
            this.isDigital = digital;
            return this;
        }

        public ReticleConfig setFullscreenReticle(boolean fullscreen) {
            this.fullscreenReticle = fullscreen;
            return this;
        }
    }
}

