/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.client;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tech.vvp.vvp.client.hud.ReticleOverlay;
import tech.vvp.vvp.init.ModKeyMappings;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="vvp", value={Dist.CLIENT})
public class ThermalVisionHandler {
    private static boolean thermalVisionEnabled = false;
    private static final ResourceLocation THERMAL_SHADER = new ResourceLocation("vvp", "shaders/post/thermal.json");
    private static boolean wasKeyPressed = false;

    public static boolean isThermalVisionEnabled() {
        return thermalVisionEnabled;
    }

    public static void toggleThermalVision() {
        thermalVisionEnabled = !thermalVisionEnabled;
        ThermalVisionHandler.applyThermalShader();
    }

    private static void applyThermalShader() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91063_ == null) {
            return;
        }
        try {
            if (thermalVisionEnabled) {
                mc.f_91063_.m_109128_(THERMAL_SHADER);
                System.out.println("[VVP] Thermal Vision: ENABLED, shader: " + String.valueOf(THERMAL_SHADER));
            } else {
                mc.f_91063_.m_109086_();
                System.out.println("[VVP] Thermal Vision: DISABLED");
            }
        }
        catch (Exception e) {
            thermalVisionEnabled = false;
            System.err.println("[VVP] Error loading thermal shader: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        boolean isKeyPressed;
        LocalPlayer player;
        int seatIndex;
        VehicleEntity vehicleEntity;
        boolean thermalVisionAllowed;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91063_ == null || mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        Entity vehicle = mc.f_91074_.m_20201_();
        boolean isInVehicle = vehicle instanceof VehicleEntity && vehicle != mc.f_91074_;
        boolean isFirstPerson = mc.f_91066_.m_92176_().m_90612_();
        if (!(isInVehicle && isFirstPerson || !thermalVisionEnabled)) {
            thermalVisionEnabled = false;
            ThermalVisionHandler.applyThermalShader();
            if (!isInVehicle) {
                System.out.println("[VVP] Player exited vehicle, Thermal Vision disabled");
            } else {
                System.out.println("[VVP] Switched to third person, Thermal Vision disabled");
            }
        }
        if (isInVehicle && isFirstPerson && thermalVisionEnabled && !(thermalVisionAllowed = ReticleOverlay.isThermalVisionAllowed(vehicleEntity = (VehicleEntity)vehicle, seatIndex = vehicleEntity.getSeatIndex((Entity)(player = mc.f_91074_))))) {
            thermalVisionEnabled = false;
            ThermalVisionHandler.applyThermalShader();
            System.out.println("[VVP] Thermal Vision not allowed for this vehicle, disabling");
        }
        if ((isKeyPressed = ModKeyMappings.THERMAL_VISION.m_90857_()) && !wasKeyPressed) {
            if (isInVehicle && isFirstPerson) {
                VehicleEntity vehicleEntity2 = (VehicleEntity)vehicle;
                LocalPlayer player2 = mc.f_91074_;
                int seatIndex2 = vehicleEntity2.getSeatIndex((Entity)player2);
                boolean thermalVisionAllowed2 = ReticleOverlay.isThermalVisionAllowed(vehicleEntity2, seatIndex2);
                if (thermalVisionAllowed2) {
                    System.out.println("[VVP] Thermal Vision key pressed, current state: " + thermalVisionEnabled);
                    ThermalVisionHandler.toggleThermalVision();
                } else {
                    System.out.println("[VVP] Thermal Vision not allowed for this vehicle!");
                }
            } else if (!isInVehicle) {
                System.out.println("[VVP] Thermal Vision can only be enabled in a vehicle!");
            } else {
                System.out.println("[VVP] Thermal Vision can only be enabled in first person!");
            }
        }
        wasKeyPressed = isKeyPressed;
        if (!thermalVisionEnabled || !isInVehicle || isFirstPerson) {
            // empty if block
        }
    }
}

