/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tech.vvp.vvp.client.ThermalVisionHandler;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="vvp", value={Dist.CLIENT})
public class ThermalEntityGlowHandler {
    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (!ThermalVisionHandler.isThermalVisionEnabled()) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        EntityRenderDispatcher dispatcher = mc.m_91290_();
        poseStack.m_85836_();
        double viewDistance = (double)mc.f_91063_.m_109152_() * 16.0;
        for (Entity entity : mc.f_91073_.m_104735_()) {
            double distance;
            if (entity == mc.f_91074_ || !entity.m_6084_() || (distance = entity.m_20280_((Entity)mc.f_91074_)) > viewDistance * viewDistance || !(entity instanceof LivingEntity)) continue;
            ThermalEntityGlowHandler.renderEntityGlow(poseStack, bufferSource, dispatcher, entity, event.getPartialTick());
        }
        poseStack.m_85849_();
        bufferSource.m_109911_();
    }

    private static void renderEntityGlow(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, EntityRenderDispatcher dispatcher, Entity entity, float partialTick) {
        try {
            poseStack.m_85836_();
            double x = entity.m_20185_() - dispatcher.f_114358_.m_90583_().f_82479_;
            double y = entity.m_20186_() - dispatcher.f_114358_.m_90583_().f_82480_;
            double z = entity.m_20189_() - dispatcher.f_114358_.m_90583_().f_82481_;
            poseStack.m_85837_(x, y, z);
            dispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, (MultiBufferSource)bufferSource, 0xF000F0);
            poseStack.m_85849_();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

