/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class DebugUtil {
    public static String getItemDebug(ItemStack item) {
        return item.m_41613_() + "x " + ForgeRegistries.ITEMS.getKey((Object)item.m_41720_());
    }

    public static String getContainerDebug(Container container) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (!builder.isEmpty()) {
                builder.append('\n');
            }
            builder.append("Slot ").append(i).append(": ").append(DebugUtil.getItemDebug(stack));
        }
        return builder.toString();
    }

    public static String getSideText(Entity entity) {
        return DebugUtil.getSideText(entity.m_9236_());
    }

    public static String getSideText(Level level) {
        return DebugUtil.getSideText(level.f_46443_);
    }

    public static String getSideText(IClientTracker tracker) {
        return DebugUtil.getSideText(tracker.isClient());
    }

    public static String getSideText(boolean isClient) {
        return isClient ? "client" : "server";
    }

    public static String debugList(List<?> list) {
        return DebugUtil.debugList(list, Object::toString);
    }

    public static <T> String debugList(List<T> list, Function<T, String> writer) {
        StringBuilder string = new StringBuilder().append("[");
        boolean notFirst = false;
        for (T value : list) {
            if (notFirst) {
                string.append(",");
            }
            if (value == null) {
                string.append("null");
            } else {
                string.append(writer.apply(value));
            }
            notFirst = true;
        }
        return string.append("]").toString();
    }

    public static String debugMap(Map<?, ?> map) {
        return DebugUtil.debugMap(map, Object::toString, Object::toString);
    }

    public static <A, B> String debugMap(Map<A, B> map, Function<A, String> aWriter, Function<B, String> bWriter) {
        StringBuilder string = new StringBuilder("[");
        map.forEach((a, b) -> {
            if (string.length() > 1) {
                string.append(",");
            }
            if (a == null) {
                string.append("null");
            } else {
                string.append((String)aWriter.apply(a));
            }
            string.append(":");
            if (b == null) {
                string.append("null");
            } else {
                string.append((String)bWriter.apply(b));
            }
        });
        return string.append("]").toString();
    }
}

