/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.player;

import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.network.message.player.SPacketUpdatePlayerCache;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CPacketRequestID
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketRequestID> HANDLER = new H();
    private final String playerName;

    public CPacketRequestID(String playerName) {
        this.playerName = playerName;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.playerName);
    }

    private static class H
    extends CustomPacket.Handler<CPacketRequestID> {
        private H() {
        }

        @Override
        public CPacketRequestID decode(FriendlyByteBuf buffer) {
            return new CPacketRequestID(buffer.m_130277_());
        }

        @Override
        protected void handle(CPacketRequestID message, Player player) {
            UUID id = PlayerReference.getPlayerID(message.playerName);
            if (id != null) {
                String name = PlayerReference.getPlayerName(id);
                new SPacketUpdatePlayerCache(id, name == null ? message.playerName : name).sendTo(player);
            }
        }
    }
}

