/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.config;

import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SPacketSyncConfig
extends ServerToClientPacket {
    public static final CustomPacket.Handler<SPacketSyncConfig> HANDLER = new H();
    private final ResourceLocation configID;
    private final Map<String, String> data;

    public SPacketSyncConfig(ResourceLocation configID, Map<String, String> data) {
        this.configID = configID;
        this.data = data;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.configID);
        buffer.writeInt(this.data.size());
        this.data.forEach((id, dat) -> {
            buffer.m_130070_(id);
            buffer.m_130070_(dat);
        });
    }

    private static class H
    extends CustomPacket.Handler<SPacketSyncConfig> {
        private H() {
        }

        @Override
        public SPacketSyncConfig decode(FriendlyByteBuf buffer) {
            ResourceLocation configID = buffer.m_130281_();
            int count = buffer.readInt();
            HashMap<String, String> data = new HashMap<String, String>();
            for (int i = 0; i < count; ++i) {
                String id = buffer.m_130277_();
                String dat = buffer.m_130277_();
                data.put(id, dat);
            }
            return new SPacketSyncConfig(configID, data);
        }

        @Override
        protected void handle(SPacketSyncConfig message, Player player) {
            ConfigFile.handleSyncData(message.configID, message.data);
        }
    }
}

