/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.config;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.ListLikeOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SPacketEditListConfig
extends ServerToClientPacket {
    public static final CustomPacket.Handler<SPacketEditListConfig> HANDLER = new H();
    private final ResourceLocation fileID;
    private final String option;
    private final String input;
    private final int listIndex;
    private final boolean isEdit;

    public SPacketEditListConfig(ResourceLocation fileID, String option, String input, int listIndex, boolean isEdit) {
        this.fileID = fileID;
        this.option = option;
        this.input = input;
        this.listIndex = listIndex;
        this.isEdit = isEdit;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.fileID);
        buffer.m_130070_(this.option);
        buffer.writeInt(this.input.length());
        buffer.m_130072_(this.input, this.input.length());
        buffer.writeInt(this.listIndex);
        buffer.writeBoolean(this.isEdit);
    }

    private static class H
    extends CustomPacket.Handler<SPacketEditListConfig> {
        private H() {
        }

        @Override
        public SPacketEditListConfig decode(FriendlyByteBuf buffer) {
            ResourceLocation fileID = buffer.m_130281_();
            String option = buffer.m_130277_();
            int inputLength = buffer.readInt();
            return new SPacketEditListConfig(fileID, option, buffer.m_130136_(inputLength), buffer.readInt(), buffer.readBoolean());
        }

        @Override
        protected void handle(SPacketEditListConfig message, Player player) {
            ConfigFile file = ConfigFile.lookupFile(message.fileID);
            if (file != null && file.isClientOnly()) {
                ConfigOption<?> configOption;
                Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
                if (optionMap.containsKey(message.option) && (configOption = optionMap.get(message.option)) instanceof ListLikeOption) {
                    int listIndex;
                    ListLikeOption option = (ListLikeOption)configOption;
                    Pair<Boolean, ConfigParsingException> result = option.editList(message.input, message.listIndex, message.isEdit);
                    if (!((Boolean)result.getFirst()).booleanValue()) {
                        LightmansCurrency.getProxy().sendClientMessage((Component)LCText.COMMAND_CONFIG_EDIT_FAIL_PARSE.get(((ConfigParsingException)result.getSecond()).getMessage()).m_130940_(ChatFormatting.RED));
                        return;
                    }
                    if (!message.isEdit) {
                        LightmansCurrency.getProxy().sendClientMessage((Component)LCText.COMMAND_CONFIG_EDIT_LIST_REMOVE_SUCCESS.get(message.option + "[" + message.listIndex + "]"));
                    }
                    if ((listIndex = message.listIndex) < 0) {
                        listIndex = option.getSize() - 1;
                    }
                    LightmansCurrency.getProxy().sendClientMessage((Component)LCText.COMMAND_CONFIG_EDIT_SUCCESS.get(message.option + "[" + listIndex + "]", message.input));
                    return;
                }
                LightmansCurrency.getProxy().sendClientMessage((Component)LCText.COMMAND_CONFIG_FAIL_MISSING.get(message.option).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

