/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.cap;

import io.github.lightman314.lightmanscurrency.api.variants.block.builtin.VariantChunkDataStorageAttachment;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;

public class SPacketSyncVariantChunkCap
extends ServerToClientPacket {
    public static final CustomPacket.Handler<SPacketSyncVariantChunkCap> HANDLER = new H();
    private final ChunkPos pos;
    private final Map<BlockPos, VariantChunkDataStorageAttachment.DataHolder> data;

    public SPacketSyncVariantChunkCap(ChunkPos pos, Map<BlockPos, VariantChunkDataStorageAttachment.DataHolder> data) {
        this.pos = pos;
        this.data = data;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_178341_(this.pos);
        buffer.writeInt(this.data.size());
        this.data.forEach((pos, entry) -> {
            buffer.m_130064_(pos);
            entry.encode(buffer);
        });
    }

    private static class H
    extends CustomPacket.Handler<SPacketSyncVariantChunkCap> {
        private H() {
        }

        @Override
        public SPacketSyncVariantChunkCap decode(FriendlyByteBuf buffer) {
            ChunkPos chunk = buffer.m_178383_();
            HashMap<BlockPos, VariantChunkDataStorageAttachment.DataHolder> data = new HashMap<BlockPos, VariantChunkDataStorageAttachment.DataHolder>();
            int count = buffer.readInt();
            while (count-- > 0) {
                BlockPos pos = buffer.m_130135_();
                data.put(pos, VariantChunkDataStorageAttachment.DataHolder.decode(buffer));
            }
            return new SPacketSyncVariantChunkCap(chunk, data);
        }

        @Override
        protected void handle(SPacketSyncVariantChunkCap message, Player player) {
            if (player != null) {
                BlockPos pos = message.pos.m_45615_();
                if (player.m_9236_().m_46749_(pos)) {
                    LevelChunk chunk = player.m_9236_().m_6325_(message.pos.f_45578_, message.pos.f_45579_);
                    chunk.getCapability(VariantChunkDataStorageAttachment.CAP).ifPresent(data -> data.loadData(message.data));
                }
            }
        }
    }
}

