/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.auction;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.auction.AuctionBidTab;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SPacketStartBid
extends ServerToClientPacket {
    public static final CustomPacket.Handler<SPacketStartBid> HANDLER = new H();
    final long auctionHouseID;
    final int tradeIndex;

    public SPacketStartBid(long auctionHouseID, int tradeIndex) {
        this.auctionHouseID = auctionHouseID;
        this.tradeIndex = tradeIndex;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeLong(this.auctionHouseID);
        buffer.writeInt(this.tradeIndex);
    }

    private static class H
    extends CustomPacket.Handler<SPacketStartBid> {
        private H() {
        }

        @Override
        public SPacketStartBid decode(FriendlyByteBuf buffer) {
            return new SPacketStartBid(buffer.readLong(), buffer.readInt());
        }

        @Override
        protected void handle(SPacketStartBid message, Player player) {
            Minecraft mc = Minecraft.m_91087_();
            Screen screen = mc.f_91080_;
            if (screen instanceof TraderScreen) {
                TraderScreen screen2 = (TraderScreen)screen;
                screen2.setTab(new AuctionBidTab(screen2, message.auctionHouseID, message.tradeIndex));
            }
        }
    }
}

