/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network;

import io.github.lightman314.lightmanscurrency.network.message.CPacketRequestNBT;
import io.github.lightman314.lightmanscurrency.network.message.auction.CPacketSubmitBid;
import io.github.lightman314.lightmanscurrency.network.message.auction.SPacketStartBid;
import io.github.lightman314.lightmanscurrency.network.message.auction.SPacketSyncAuctionStandDisplay;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketATMSetPlayerAccount;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketBankInteraction;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketBankTransferAccount;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketBankTransferPlayer;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketOpenATM;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketSelectBankAccount;
import io.github.lightman314.lightmanscurrency.network.message.bank.SPacketATMPlayerAccountResponse;
import io.github.lightman314.lightmanscurrency.network.message.bank.SPacketBankTransferResponse;
import io.github.lightman314.lightmanscurrency.network.message.cap.SPacketSyncVariantBECap;
import io.github.lightman314.lightmanscurrency.network.message.cap.SPacketSyncVariantChunkCap;
import io.github.lightman314.lightmanscurrency.network.message.command.SPacketDebugTrader;
import io.github.lightman314.lightmanscurrency.network.message.command.SPacketSyncAdminList;
import io.github.lightman314.lightmanscurrency.network.message.config.CPacketEditConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.CPacketTrackServerFile;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketEditConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketEditListConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketEditMapConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketReloadConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketResetConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketSyncConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketViewConfig;
import io.github.lightman314.lightmanscurrency.network.message.data.SPacketSyncCoinData;
import io.github.lightman314.lightmanscurrency.network.message.data.SPacketSyncCustomData;
import io.github.lightman314.lightmanscurrency.network.message.emergencyejection.CPacketOpenEjectionMenu;
import io.github.lightman314.lightmanscurrency.network.message.enchantments.SPacketMoneyMendingClink;
import io.github.lightman314.lightmanscurrency.network.message.event.SPacketSyncEventUnlocks;
import io.github.lightman314.lightmanscurrency.network.message.interfacebe.CPacketInterfaceHandlerMessage;
import io.github.lightman314.lightmanscurrency.network.message.menu.CPacketLazyMenu;
import io.github.lightman314.lightmanscurrency.network.message.menu.SPacketLazyMenu;
import io.github.lightman314.lightmanscurrency.network.message.notifications.CPacketOpenNotifications;
import io.github.lightman314.lightmanscurrency.network.message.notifications.SPacketChatNotification;
import io.github.lightman314.lightmanscurrency.network.message.paygate.CPacketCollectTicketStubs;
import io.github.lightman314.lightmanscurrency.network.message.persistentdata.CPacketCreatePersistentAuction;
import io.github.lightman314.lightmanscurrency.network.message.persistentdata.CPacketCreatePersistentTrader;
import io.github.lightman314.lightmanscurrency.network.message.player.CPacketRequestID;
import io.github.lightman314.lightmanscurrency.network.message.player.CPacketRequestName;
import io.github.lightman314.lightmanscurrency.network.message.player.SPacketUpdatePlayerCache;
import io.github.lightman314.lightmanscurrency.network.message.playertrading.CPacketPlayerTradeInteraction;
import io.github.lightman314.lightmanscurrency.network.message.playertrading.SPacketSyncPlayerTrade;
import io.github.lightman314.lightmanscurrency.network.message.teams.CPacketOpenTeamManager;
import io.github.lightman314.lightmanscurrency.network.message.time.SPacketSyncTime;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketAddOrRemoveTrade;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketCollectCoins;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketExecuteTrade;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenNetworkTerminal;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenStorage;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenTrades;
import io.github.lightman314.lightmanscurrency.network.message.trader.SPacketSyncUsers;
import io.github.lightman314.lightmanscurrency.network.message.trader.SPacketTaxInfo;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketChestQuickCollect;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketOpenWallet;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketOpenWalletBank;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketWalletExchangeCoins;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketWalletQuickCollect;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketWalletToggleAutoExchange;
import io.github.lightman314.lightmanscurrency.network.message.wallet.SPacketPlayCoinSound;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.CPacketCreativeWalletEdit;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.CPacketSetVisible;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.SPacketSyncWallet;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LightmansCurrencyPacketHandler {
    public static final String PROTOCOL_VERSION = "1";
    public static SimpleChannel instance;
    private static int nextId;

    public static void init() {
        instance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)VersionUtil.lcResource("network")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).simpleChannel();
        LightmansCurrencyPacketHandler.registerC2S(CPacketOpenATM.class, CPacketOpenATM.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketSelectBankAccount.class, CPacketSelectBankAccount.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketBankInteraction.class, CPacketBankInteraction.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketBankTransferAccount.class, CPacketBankTransferAccount.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketBankTransferPlayer.class, CPacketBankTransferPlayer.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketBankTransferResponse.class, SPacketBankTransferResponse.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketATMSetPlayerAccount.class, CPacketATMSetPlayerAccount.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketATMPlayerAccountResponse.class, SPacketATMPlayerAccountResponse.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketExecuteTrade.class, CPacketExecuteTrade.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketCollectCoins.class, CPacketCollectCoins.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketOpenStorage.class, CPacketOpenStorage.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketOpenTrades.class, CPacketOpenTrades.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketOpenNetworkTerminal.class, CPacketOpenNetworkTerminal.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketSyncUsers.class, SPacketSyncUsers.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketAddOrRemoveTrade.class, CPacketAddOrRemoveTrade.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketTaxInfo.class, SPacketTaxInfo.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketCollectTicketStubs.class, CPacketCollectTicketStubs.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketPlayCoinSound.class, SPacketPlayCoinSound.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketWalletExchangeCoins.class, CPacketWalletExchangeCoins.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketWalletToggleAutoExchange.class, CPacketWalletToggleAutoExchange.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketOpenWallet.class, CPacketOpenWallet.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketOpenWalletBank.class, CPacketOpenWalletBank.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketWalletQuickCollect.class, CPacketWalletQuickCollect.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketChestQuickCollect.class, CPacketChestQuickCollect.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketSyncWallet.class, SPacketSyncWallet.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketSetVisible.class, CPacketSetVisible.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketCreativeWalletEdit.class, CPacketCreativeWalletEdit.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketStartBid.class, SPacketStartBid.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketSubmitBid.class, CPacketSubmitBid.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketSyncAuctionStandDisplay.class, SPacketSyncAuctionStandDisplay.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketInterfaceHandlerMessage.class, CPacketInterfaceHandlerMessage.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketOpenTeamManager.class, CPacketOpenTeamManager.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketLazyMenu.class, SPacketLazyMenu.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketLazyMenu.class, CPacketLazyMenu.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketChatNotification.class, SPacketChatNotification.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketOpenNotifications.class, CPacketOpenNotifications.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketRequestNBT.class, CPacketRequestNBT.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketSyncTime.class, SPacketSyncTime.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketSyncAdminList.class, SPacketSyncAdminList.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketDebugTrader.class, SPacketDebugTrader.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketSyncCoinData.class, SPacketSyncCoinData.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketMoneyMendingClink.class, SPacketMoneyMendingClink.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketCreatePersistentTrader.class, CPacketCreatePersistentTrader.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketCreatePersistentAuction.class, CPacketCreatePersistentAuction.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketOpenEjectionMenu.class, CPacketOpenEjectionMenu.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketSyncPlayerTrade.class, SPacketSyncPlayerTrade.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketPlayerTradeInteraction.class, CPacketPlayerTradeInteraction.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketSyncEventUnlocks.class, SPacketSyncEventUnlocks.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketEditConfig.class, CPacketEditConfig.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketTrackServerFile.class, CPacketTrackServerFile.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketSyncConfig.class, SPacketSyncConfig.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketReloadConfig.class, SPacketReloadConfig.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketEditConfig.class, SPacketEditConfig.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketEditListConfig.class, SPacketEditListConfig.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketEditMapConfig.class, SPacketEditMapConfig.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketResetConfig.class, SPacketResetConfig.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketViewConfig.class, SPacketViewConfig.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketRequestName.class, CPacketRequestName.HANDLER);
        LightmansCurrencyPacketHandler.registerC2S(CPacketRequestID.class, CPacketRequestID.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketUpdatePlayerCache.class, SPacketUpdatePlayerCache.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketSyncCustomData.class, SPacketSyncCustomData.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketSyncVariantBECap.class, SPacketSyncVariantBECap.HANDLER);
        LightmansCurrencyPacketHandler.registerS2C(SPacketSyncVariantChunkCap.class, SPacketSyncVariantChunkCap.HANDLER);
    }

    private static <T extends ServerToClientPacket> void registerS2C(Class<T> clazz, CustomPacket.Handler<T> handler) {
        instance.registerMessage(nextId++, clazz, CustomPacket::encode, handler::decode, handler::handlePacket, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    private static <T extends ClientToServerPacket> void registerC2S(Class<T> clazz, CustomPacket.Handler<T> handler) {
        instance.registerMessage(nextId++, clazz, CustomPacket::encode, handler::decode, handler::handlePacket, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public static PacketDistributor.PacketTarget getTarget(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            return LightmansCurrencyPacketHandler.getTarget(sp);
        }
        return null;
    }

    public static PacketDistributor.PacketTarget getTarget(ServerPlayer player) {
        return PacketDistributor.PLAYER.with(() -> player);
    }

    static {
        nextId = 0;
    }
}

