/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.create.attributes;

import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.integration.create.attributes.LCItemAttributes;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class VariantAttributeType
implements ItemAttributeType {
    private static final ResourceLocation NULL_ID = VersionUtil.modResource("null", "null");
    private static final VariantAttribute NO_VARIANT_ATTRIBUTE = new VariantAttribute(NULL_ID);

    @Nonnull
    public ItemAttribute createAttribute() {
        return new VariantAttribute(VersionUtil.lcResource("null"));
    }

    public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
        if (VariantProvider.getVariantItem(stack) != null) {
            ResourceLocation variantID = IVariantItem.getItemVariant(stack);
            if (variantID != null) {
                return List.of(new VariantAttribute(variantID));
            }
            return List.of(NO_VARIANT_ATTRIBUTE);
        }
        return List.of();
    }

    public static class VariantAttribute
    implements ItemAttribute {
        private ResourceLocation variantID;

        private static VariantAttribute create(ResourceLocation variantID) {
            if (variantID.equals((Object)NULL_ID)) {
                return NO_VARIANT_ATTRIBUTE;
            }
            return new VariantAttribute(variantID);
        }

        private VariantAttribute(ResourceLocation variantID) {
            this.variantID = variantID;
        }

        private boolean isNullType() {
            return this.variantID.equals((Object)NULL_ID);
        }

        public boolean appliesTo(ItemStack stack, Level world) {
            ResourceLocation variant = IVariantItem.getItemVariant(stack);
            if (this.isNullType()) {
                return variant == null;
            }
            return Objects.equals(this.variantID, variant);
        }

        public ItemAttributeType getType() {
            return LCItemAttributes.VARIANT_ATTRIBUTE.get();
        }

        public void save(CompoundTag tag) {
            tag.m_128359_("value", this.variantID.toString());
        }

        public void load(CompoundTag tag) {
            this.variantID = VersionUtil.parseResource(tag.m_128461_("value"));
        }

        public String getTranslationKey() {
            return this.isNullType() ? "lightmanscurrency.model_variant.null" : "lightmanscurrency.model_variant";
        }

        public Object[] getTranslationParameters() {
            Object[] objectArray;
            if (this.isNullType()) {
                objectArray = super.getTranslationParameters();
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.variantID.toString();
            }
            return objectArray;
        }
    }
}

