/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft;

import dan200.computercraft.api.peripheral.AttachedComputerSet;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheral;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class AccessTrackingPeripheral
extends LCPeripheral {
    private final List<AccessTrackingPeripheral> children = new ArrayList<AccessTrackingPeripheral>();
    @Nullable
    private AccessTrackingPeripheral parent;

    public void setParent(AccessTrackingPeripheral parent) {
        if (this.parent != null) {
            LightmansCurrency.LogWarning("Attempted to attach an access tracking peripheral to a second parent!", new Throwable());
            return;
        }
        this.parent = parent;
        this.parent.children.add(this);
        this.parent.getConnectedComputers().forEach(this::onAttachment);
        if (this.parent.getConnectedComputers().hasComputers()) {
            this.onFirstAttachment();
        }
    }

    protected boolean childStillValid(IPeripheral child) {
        return true;
    }

    protected final boolean stillValid() {
        if (this.parent == null) {
            return true;
        }
        return this.parent.childStillValid((IPeripheral)this);
    }

    protected final void queueEvent(String event, Object ... arguments) {
        this.getConnectedComputers().queueEvent(event, arguments);
    }

    protected final void queueEvent(String event, Function<IComputerAccess, Object[]> argumentBuilder) {
        this.getConnectedComputers().forEach(computer -> computer.queueEvent(event, (Object[])argumentBuilder.apply((IComputerAccess)computer)));
    }

    protected final AttachedComputerSet getConnectedComputers() {
        if (this.parent != null) {
            return this.parent.getConnectedComputers();
        }
        return this.computers;
    }

    protected final String getComputerID(IComputerAccess computer) {
        return "computercraft#" + computer.getID();
    }

    protected final PlayerReference getFakePlayer(IComputerAccess computer) {
        return PlayerReference.dummy(this.getComputerID(computer));
    }

    @Override
    protected void onFirstAttachment() {
        super.onFirstAttachment();
        for (AccessTrackingPeripheral child : this.children) {
            child.onFirstAttachment();
        }
    }

    @Override
    protected void onLastDetachment() {
        super.onLastDetachment();
        for (AccessTrackingPeripheral child : this.children) {
            child.onLastDetachment();
        }
    }

    public boolean equals(@Nullable IPeripheral peripheral) {
        return this == peripheral;
    }
}

