/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.common.structures;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.common.loot.LCLootTables;
import io.github.lightman314.lightmanscurrency.common.world.LCStructures;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;

public class LCProcessorListProvider {
    public static void bootstrap(@Nonnull BootstapContext<StructureProcessorList> context) {
        context.m_255272_(LCStructures.PROCESSOR_DESERT_BANKER_ARCHAEOLOGY, (Object)new StructureProcessorList((List)Lists.newArrayList((Object[])new StructureProcessor[]{LCProcessorListProvider.archaeologyRule(LCLootTables.ARCHAEOLOGY_VILLAGE_DESERT_BANKER, Blocks.f_271439_, Blocks.f_271439_.m_49966_(), 10)})));
        context.m_255272_(LCStructures.PROCESSOR_PLAINS_SHOP_ARCHAEOLOGY, (Object)new StructureProcessorList((List)Lists.newArrayList((Object[])new StructureProcessor[]{LCProcessorListProvider.gravelArchaeology(LCLootTables.ARCHAEOLOGY_VILLAGE_PLAINS_SHOP, 4)})));
        context.m_255272_(LCStructures.PROCESSOR_TAIGA_SHOP_ARCHAEOLOGY, (Object)new StructureProcessorList((List)Lists.newArrayList((Object[])new StructureProcessor[]{LCProcessorListProvider.gravelArchaeology(LCLootTables.ARCHAEOLOGY_VILLAGE_TAIGA_SHOP, 4)})));
        context.m_255272_(LCStructures.PROCESSOR_DESERT_SHOP_ARCHAEOLOGY, (Object)new StructureProcessorList((List)Lists.newArrayList((Object[])new StructureProcessor[]{LCProcessorListProvider.sandArchaeology(LCLootTables.ARCHAEOLOGY_VILLAGE_DESERT_SHOP, 10)})));
        context.m_255272_(LCStructures.PROCESSOR_IDAS_TAIGA_LARGE_BANK, (Object)new StructureProcessorList((List)Lists.newArrayList((Object[])new StructureProcessor[]{LCProcessorListProvider.gravelArchaeology(LCLootTables.ARCHAEOLOGY_VILLAGE_IDAS_TAIGA_LARGE_BANK, 6)})));
        context.m_255272_(LCStructures.PROCESSOR_ANCIENT_RUINS, (Object)new StructureProcessorList((List)Lists.newArrayList((Object[])new StructureProcessor[]{LCProcessorListProvider.gravelArchaeology(LCLootTables.ARCHAEOLOGY_ANCIENT_RUINS, 6)})));
    }

    private static CappedProcessor gravelArchaeology(ResourceLocation lootTable, int count) {
        return LCProcessorListProvider.archaeologyRule(lootTable, Blocks.f_49994_, Blocks.f_276445_.m_49966_(), count);
    }

    private static CappedProcessor sandArchaeology(ResourceLocation lootTable, int count) {
        return LCProcessorListProvider.archaeologyRule(lootTable, Blocks.f_49992_, Blocks.f_271439_.m_49966_(), count);
    }

    private static CappedProcessor archaeologyRule(ResourceLocation lootTable, Block original, BlockState replacement, int count) {
        return new CappedProcessor((StructureProcessor)new RuleProcessor((List)Lists.newArrayList((Object[])new ProcessorRule[]{new ProcessorRule((RuleTest)new BlockMatchTest(original), (RuleTest)AlwaysTrueTest.f_73954_, (PosRuleTest)PosAlwaysTrueTest.f_74188_, replacement, (RuleBlockEntityModifier)new AppendLoot(lootTable))})), (IntProvider)ConstantInt.m_146483_((int)count));
    }
}

