/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.client.language;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.stats.StatKey;
import io.github.lightman314.lightmanscurrency.api.stats.StatType;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.common.items.ancient_coins.AncientCoinType;
import io.github.lightman314.lightmanscurrency.common.text.CombinedTextEntry;
import io.github.lightman314.lightmanscurrency.common.text.DualTextEntry;
import io.github.lightman314.lightmanscurrency.common.text.MultiLineTextEntry;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import io.github.lightman314.lightmanscurrency.common.text.TextEntryBiBundle;
import io.github.lightman314.lightmanscurrency.common.text.TextEntryBundle;
import io.github.lightman314.lightmanscurrency.common.text.TimeUnitTextEntry;
import io.github.lightman314.lightmanscurrency.datagen.client.language.TranslationAttachment;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.data.LanguageProvider;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class TranslationProvider
extends LanguageProvider {
    private final PackOutput output;

    protected TranslationProvider(PackOutput output) {
        this(output, "lightmanscurrency", "en_us_dev");
    }

    protected TranslationProvider(PackOutput output, String locale) {
        this(output, "lightmanscurrency", locale);
    }

    protected TranslationProvider(PackOutput output, String modid, String locale) {
        super(output, modid, locale);
        this.output = output;
    }

    protected final void addTranslations() {
        this.createTranslations();
        this.callAttachments(this.output, TranslationProvider::addTranslations);
    }

    protected abstract void createTranslations();

    protected void callAttachments(PackOutput output, Consumer<TranslationAttachment> handler) {
    }

    protected String getColorName(Color color) {
        return color.getPrettyName();
    }

    protected String getWoodTypeName(WoodType type) {
        return type.displayName;
    }

    protected final void translate(TextEntry entry, String translation) {
        this.add(entry.getKey(), translation);
    }

    protected final void translate(CombinedTextEntry entry, String translation) {
        entry.forEachKey(key -> this.add((String)key, translation));
    }

    protected final void translate(MultiLineTextEntry entry, String ... translations) {
        ImmutableList lines = ImmutableList.copyOf((Object[])translations);
        for (int i = 0; i < lines.size(); ++i) {
            this.add(entry.getKey(i), (String)lines.get(i));
        }
    }

    protected final void translate(TimeUnitTextEntry entry, String fullText, String pluralText, String shortText) {
        this.translate(entry.fullText, fullText);
        this.translate(entry.pluralText, pluralText);
        this.translate(entry.shortText, shortText);
    }

    protected final void translate(DualTextEntry entry, String first, String second) {
        this.translate(entry.first, first);
        this.translate(entry.second, second);
    }

    protected final void translate(StatKey<?, ?> statistic, String text) {
        this.add(StatType.getTranslationKey(statistic.key), text);
    }

    protected final void translateWooden(TextEntryBundle<WoodType> bundle, String format) {
        this.translate(bundle, format, this::getWoodTypeName);
    }

    protected final void translateColored(TextEntryBundle<Color> bundle, String format) {
        this.translate(bundle, format, this::getColorName);
    }

    protected final <T> void translate(TextEntryBundle<T> bundle, String format, Function<T, String> keyToText) {
        bundle.forEach((key, entry) -> this.translate((TextEntry)entry, format.formatted(keyToText.apply(key))));
    }

    protected final void translateWoodenAndColored(TextEntryBiBundle<WoodType, Color> bundle, String format) {
        this.translate(bundle, format, this::getWoodTypeName, this::getColorName);
    }

    protected final <S, T> void translate(TextEntryBiBundle<S, T> bundle, String format, Function<S, String> key1ToText, Function<T, String> key2ToText) {
        bundle.forEach((key1, key2, entry) -> this.translate((TextEntry)entry, format.formatted(key1ToText.apply(key1), key2ToText.apply(key2))));
    }

    protected final void translateAncientCoin(AncientCoinType type, String text) {
        ItemStack item = type.asItem();
        this.add(item.m_41778_(), text);
    }

    protected final void translateAncientCoinInitial(AncientCoinType type, String text) {
        this.translate(new TextEntry(type.initialKey()), text);
    }

    protected final void translateGuide(ResourceLocation guide, String name, String landingText) {
        String prefix = "guide." + guide.m_135827_() + "." + guide.m_135815_() + ".";
        this.add(prefix + "name", name);
        this.add(prefix + "landing_text", landingText);
    }

    protected final void translateConfigName(ConfigFile file, String name) {
        file.confirmSetup();
        this.add(ConfigFile.translationForFile(file.getFileID()), name);
    }

    protected final void translateConfigSection(ConfigFile file, String section, String name, String ... comments) {
        file.confirmSetup();
        this.add(ConfigFile.translationForSection(file.getFileID(), section), name);
        this.translateConfigComment(file, section, comments);
    }

    protected final void translateConfigOption(ConfigOption<?> option, String optionName, String ... comments) {
        ConfigFile file = option.getFile();
        if (file == null) {
            LightmansCurrency.LogError("Cannot translate config option as its config file has not been initialized!");
            return;
        }
        String optionKey = option.getFullName();
        this.add(ConfigFile.translationForOption(file.getFileID(), optionKey), optionName);
        this.translateConfigComment(file, optionKey, comments);
    }

    protected final void translateConfigComment(ConfigFile file, String section, String ... translation) {
        file.confirmSetup();
        this.translate(new MultiLineTextEntry(ConfigFile.translationForComment(file.getFileID(), section)), translation);
    }
}

