/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.client;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertType;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.display.ItemEntry;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.display.ScrollingTextEntry;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.display.TextDisplayEntry;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import io.github.lightman314.lightmanscurrency.common.util.TooltipHelper;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaygateTradeButtonRenderer
extends TradeRenderManager<PaygateTradeData> {
    public PaygateTradeButtonRenderer(PaygateTradeData trade) {
        super(trade);
    }

    @Override
    public int tradeButtonWidth(TradeContext context) {
        return ((PaygateTradeData)this.trade).getDescription().isBlank() ? 94 : 189;
    }

    @Override
    public Optional<ScreenPosition> arrowPosition(TradeContext context) {
        return ScreenPosition.ofOptional(36, 1);
    }

    @Override
    public DisplayData inputDisplayArea(TradeContext context) {
        return new DisplayData(1, 1, 34, 16);
    }

    @Override
    public List<DisplayEntry> getInputDisplays(TradeContext context) {
        if (((PaygateTradeData)this.trade).isTicketTrade()) {
            return Lists.newArrayList((Object[])new DisplayEntry[]{ItemEntry.of(TicketItem.CreateTicket(((PaygateTradeData)this.trade).getTicketItem(), ((PaygateTradeData)this.trade).getTicketID(), ((PaygateTradeData)this.trade).getTicketColor()), LCText.TOOLTIP_TICKET_ID.getAsList(((PaygateTradeData)this.trade).getTicketID()))});
        }
        return this.lazyPriceDisplayList(context, this.getTicketPriceTooltip(context));
    }

    private Component getTicketPriceTooltip(TradeContext context) {
        return context.isStorageMode ? LCText.TOOLTIP_TRADE_PAYGATE_SET_TICKET_PRICE.getWithStyle(ChatFormatting.YELLOW) : null;
    }

    @Override
    public DisplayData outputDisplayArea(TradeContext context) {
        return new DisplayData(58, 1, ((PaygateTradeData)this.trade).getDescription().isBlank() ? 34 : 127, 16);
    }

    @Override
    public List<DisplayEntry> getOutputDisplays(TradeContext context) {
        return Lists.newArrayList((Object[])new DisplayEntry[]{((PaygateTradeData)this.trade).getDescription().isBlank() ? TextDisplayEntry.of((Component)PaygateTradeData.formatDurationDisplay(((PaygateTradeData)this.trade).getDuration()), TextRenderUtil.TextFormatting.create(), (List<Component>)Lists.newArrayList((Object[])new Component[]{PaygateTradeData.formatDuration(((PaygateTradeData)this.trade).getDuration()), LCText.GUI_TRADER_PAYGATE_LEVEL.get(((PaygateTradeData)this.trade).getRedstoneLevel())})) : ScrollingTextEntry.of((Component)EasyText.literal(((PaygateTradeData)this.trade).getDescription()), 0xFFFFFF, TooltipHelper.splitTooltips(((PaygateTradeData)this.trade).getDescriptionTooltip(), new ChatFormatting[0]))});
    }

    @Override
    protected void getAdditionalAlertData(TradeContext context, List<AlertData> alerts) {
        TraderData traderData;
        if (context.hasTrader() && (traderData = context.getTrader()) instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)traderData;
            if (paygate.isActive(((PaygateTradeData)this.trade).getOutputSides())) {
                alerts.add(AlertData.of(LCText.TOOLTIP_TRADER_PAYGATE_ALREADY_ACTIVE.get(new Object[0]), paygate.getConflictHandling().allowsConflicts ? AlertType.NEUTRAL : AlertType.WARN));
                int seconds = MathUtil.DivideByAndRoundUp(paygate.getTimeRemaining(((PaygateTradeData)this.trade).getOutputSides()), 20);
                alerts.add(AlertData.neutral(LCText.TOOLTIP_TRADER_PAYGATE_TIME_REMAINING.get(EasyText.empty().m_130946_(String.valueOf(seconds)).m_7220_((Component)LCText.TIME_UNIT_SECOND.shortText.get(new Object[0])))));
            }
            if (!((PaygateTradeData)this.trade).canAfford(context)) {
                alerts.add(AlertData.warn(LCText.TOOLTIP_CANNOT_AFFORD));
            }
        }
    }
}

