/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.categories;

import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategoryType;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TaxEntryCategory
extends NotificationCategory {
    public static final NotificationCategoryType<TaxEntryCategory> TYPE = new NotificationCategoryType(VersionUtil.lcResource("tax_entry"), TaxEntryCategory::new);
    private final long entryID;
    private final Component entryName;

    public TaxEntryCategory(Component entryName, long entryID) {
        this.entryID = entryID;
        this.entryName = entryName;
    }

    public TaxEntryCategory(CompoundTag tag) {
        this.entryName = tag.m_128441_("EntryName") ? Component.Serializer.m_130701_((String)tag.m_128461_("EntryName")) : ((Block)ModBlocks.TAX_COLLECTOR.get()).m_49954_();
        this.entryID = tag.m_128441_("TraderID") ? tag.m_128454_("TraderID") : -1L;
    }

    @Override
    public IconData getIcon() {
        return ItemIcon.ofItem(ModBlocks.TAX_COLLECTOR);
    }

    @Override
    public Component getName() {
        return this.entryName;
    }

    protected NotificationCategoryType<TaxEntryCategory> getType() {
        return TYPE;
    }

    @Override
    public boolean matches(NotificationCategory other) {
        if (other instanceof TaxEntryCategory) {
            TaxEntryCategory otherTax = (TaxEntryCategory)other;
            return otherTax.entryID == this.entryID;
        }
        return false;
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128359_("EntryName", Component.Serializer.m_130703_((Component)this.entryName));
        compound.m_128356_("EntryID", this.entryID);
    }
}

