/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.tax_collector.tabs;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.tax_collector.AdminSettingsClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.TaxCollectorMenu;
import io.github.lightman314.lightmanscurrency.common.menus.tax_collector.TaxCollectorTab;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import net.minecraft.world.entity.player.Player;

public class AdminTab
extends TaxCollectorTab {
    public AdminTab(TaxCollectorMenu menu) {
        super(menu);
    }

    @Override
    public boolean canOpen(Player player) {
        return this.isAdmin() && !this.isServerEntry();
    }

    @Override
    public Object createClientTab(Object screen) {
        return new AdminSettingsClientTab(screen, this);
    }

    public void SetForceAcceptance(boolean newState) {
        TaxEntry entry = ((TaxCollectorMenu)this.menu).getEntry();
        if (entry != null && this.hasAccess() && this.isAdmin()) {
            entry.setForceAcceptance(newState);
            if (((TaxCollectorMenu)this.menu).isClient()) {
                ((TaxCollectorMenu)this.menu).SendMessageToServer(this.builder().setBoolean("ChangeForceAcceptance", newState));
            }
        }
    }

    public void SetInfiniteRange(boolean newState) {
        TaxEntry entry = ((TaxCollectorMenu)this.menu).getEntry();
        if (entry != null && this.hasAccess() && this.isAdmin()) {
            entry.setInfiniteRange(newState);
            if (((TaxCollectorMenu)this.menu).isClient()) {
                ((TaxCollectorMenu)this.menu).SendMessageToServer(this.builder().setBoolean("ChangeInfiniteRange", newState));
            }
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("ChangeForceAcceptance")) {
            this.SetForceAcceptance(message.getBoolean("ChangeForceAcceptance"));
        }
        if (message.contains("ChangeInfiniteRange")) {
            this.SetInfiniteRange(message.getBoolean("ChangeInfiniteRange"));
        }
    }
}

