/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class DebugCommands {
    private static final SimpleCommandExceptionType ERROR_STRUCTURE_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.place.structure.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        LiteralArgumentBuilder placeStructureCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lcdebug").requires(stack -> stack.m_6761_(2) && stack.m_230897_())).then(Commands.m_82127_((String)"placeStructure").then(Commands.m_82129_((String)"structure", (ArgumentType)ResourceKeyArgument.m_212386_((ResourceKey)Registries.f_256944_)).executes(DebugCommands::placeStructure)));
        dispatcher.register(placeStructureCommand);
    }

    private static int placeStructure(CommandContext<CommandSourceStack> commandContext) {
        try {
            CommandSourceStack stack = (CommandSourceStack)commandContext.getSource();
            ServerLevel level = stack.m_81372_();
            Holder.Reference holder = ResourceKeyArgument.m_247318_(commandContext, (String)"structure");
            Structure structure = (Structure)holder.m_203334_();
            ChunkGenerator chunkGenerator = level.m_7726_().m_8481_();
            BlockPos pos = BlockPos.m_274446_((Position)stack.m_81371_());
            StructureStart start = structure.m_226596_(stack.m_5894_(), chunkGenerator, chunkGenerator.m_62218_(), level.m_7726_().m_214994_(), level.m_215082_(), level.m_7328_(), new ChunkPos(pos), 0, (LevelHeightAccessor)level, p_214580_ -> true);
            if (!start.m_73603_()) {
                throw ERROR_STRUCTURE_FAILED.create();
            }
            BoundingBox area = start.m_73601_();
            ChunkPos $$8 = new ChunkPos(SectionPos.m_123171_((int)area.m_162395_()), SectionPos.m_123171_((int)area.m_162398_()));
            ChunkPos $$9 = new ChunkPos(SectionPos.m_123171_((int)area.m_162399_()), SectionPos.m_123171_((int)area.m_162401_()));
            DebugCommands.checkLoaded(level, $$8, $$9);
            ChunkPos.m_45599_((ChunkPos)$$8, (ChunkPos)$$9).forEach(p_289290_ -> start.m_226850_((WorldGenLevel)level, level.m_215010_(), chunkGenerator, level.m_213780_(), new BoundingBox(p_289290_.m_45604_(), level.m_141937_(), p_289290_.m_45605_(), p_289290_.m_45608_(), level.m_151558_(), p_289290_.m_45609_()), p_289290_));
            String structureID = holder.m_205785_().m_135782_().toString();
            stack.m_288197_(() -> Component.m_237110_((String)"commands.place.structure.success", (Object[])new Object[]{structureID, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), true);
            return 1;
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error placing structure.", t);
            return 0;
        }
    }

    private static void checkLoaded(ServerLevel level, ChunkPos pos1, ChunkPos pos2) throws CommandSyntaxException {
        if (ChunkPos.m_45599_((ChunkPos)pos1, (ChunkPos)pos2).anyMatch(p_214542_ -> !level.m_46749_(p_214542_.m_45615_()))) {
            throw BlockPosArgument.f_118234_.create();
        }
    }
}

