/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.ConfigAPI;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.ConfigReloadable;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.ListLikeOption;
import io.github.lightman314.lightmanscurrency.api.config.options.MapLikeOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketEditConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketEditListConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketEditMapConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketResetConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketViewConfig;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class CommandConfig {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder configReloadCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lcconfig").then(CommandConfig.configReloadCommands())).then(CommandConfig.configEditCommands())).then(CommandConfig.configResetCommands())).then(CommandConfig.configViewCommands());
        dispatcher.register(configReloadCommand);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> configReloadCommands() {
        LiteralArgumentBuilder reload = (LiteralArgumentBuilder)Commands.m_82127_((String)"reload").executes(CommandConfig::reloadAll);
        for (ConfigReloadable reloadable : ConfigAPI.getApi().getReloadablesInOrder()) {
            reload.then(((LiteralArgumentBuilder)Commands.m_82127_((String)reloadable.getID().toString()).requires(reloadable::canReload)).executes(context -> CommandConfig.reloadFile((CommandContext<CommandSourceStack>)context, reloadable)));
        }
        return reload;
    }

    static int reloadAll(CommandContext<CommandSourceStack> commandContext) {
        int result = 0;
        boolean alertAdmins = false;
        CommandSourceStack stack = (CommandSourceStack)commandContext.getSource();
        for (ConfigReloadable reloadable : ConfigAPI.getApi().getReloadablesInOrder()) {
            try {
                if (!reloadable.canReload(stack)) continue;
                reloadable.onCommandReload(stack);
                alertAdmins = alertAdmins || reloadable.alertAdmins();
                ++result;
            }
            catch (CommandSyntaxException e) {
                LightmansCurrency.LogWarning("Error reloading " + reloadable.getID() + " config file from command!", new Object[]{e});
            }
        }
        if (result > 0) {
            EasyText.sendCommandSucess(stack, (Component)LCText.COMMAND_CONFIG_RELOAD.get(new Object[0]), alertAdmins);
        }
        return result;
    }

    static int reloadFile(CommandContext<CommandSourceStack> context, ConfigReloadable reloadable) throws CommandSyntaxException {
        CommandSourceStack stack = (CommandSourceStack)context.getSource();
        if (reloadable.canReload(stack)) {
            reloadable.onCommandReload(stack);
            EasyText.sendCommandSucess(stack, (Component)LCText.COMMAND_CONFIG_RELOAD_FILE.get(reloadable.getID()), reloadable.alertAdmins());
            return 1;
        }
        return 0;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> configEditCommands() {
        LiteralArgumentBuilder edit = Commands.m_82127_((String)"edit");
        for (ConfigFile file : ConfigFile.getAvailableFiles()) {
            LiteralArgumentBuilder fileSection = (LiteralArgumentBuilder)Commands.m_82127_((String)file.getFileID().toString()).requires(file::canReload);
            file.getAllOptions().forEach((key, option) -> {
                if (option instanceof ListLikeOption) {
                    fileSection.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> CommandConfig.commandEditList((CommandContext<CommandSourceStack>)context, file, key, -1, true))))).then(Commands.m_82127_((String)"replace").then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> CommandConfig.commandEditList((CommandContext<CommandSourceStack>)context, file, key, IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), true)))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> CommandConfig.commandEditList((CommandContext<CommandSourceStack>)context, file, key, IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), false)))));
                } else if (option instanceof MapLikeOption) {
                    fileSection.then(((LiteralArgumentBuilder)Commands.m_82127_((String)key).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"key", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> CommandConfig.commandEditMap((CommandContext<CommandSourceStack>)context, file, key, true)))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"key", (ArgumentType)StringArgumentType.string()).executes(context -> CommandConfig.commandEditMap((CommandContext<CommandSourceStack>)context, file, key, false)))));
                } else {
                    fileSection.then(Commands.m_82127_((String)key).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> CommandConfig.commandEdit((CommandContext<CommandSourceStack>)context, file, key))));
                }
            });
            edit.then((ArgumentBuilder)fileSection);
        }
        return edit;
    }

    static int commandEdit(CommandContext<CommandSourceStack> commandContext, ConfigFile file, String configOption) throws CommandSyntaxException {
        String input = StringArgumentType.getString(commandContext, (String)"value");
        if (file.isClientOnly()) {
            new SPacketEditConfig(file.getFileID(), configOption, input).sendTo(((CommandSourceStack)commandContext.getSource()).m_81375_());
            return 1;
        }
        Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
        if (optionMap.containsKey(configOption)) {
            ConfigOption<?> option = optionMap.get(configOption);
            Pair<Boolean, ConfigParsingException> result = option.load(input, ConfigOption.LoadSource.COMMAND);
            if (!((Boolean)result.getFirst()).booleanValue()) {
                EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_FAIL_PARSE.get(((ConfigParsingException)result.getSecond()).getMessage()));
                return 0;
            }
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_SUCCESS.get(option.getName(), input), true);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_FAIL_MISSING.get(configOption));
        return 0;
    }

    static int commandEditList(CommandContext<CommandSourceStack> commandContext, ConfigFile file, String configOption, int listIndex, boolean isEdit) throws CommandSyntaxException {
        ConfigOption<?> configOption2;
        String input = isEdit ? StringArgumentType.getString(commandContext, (String)"value") : "";
        if (file.isClientOnly()) {
            new SPacketEditListConfig(file.getFileID(), configOption, input, listIndex, isEdit).sendTo(((CommandSourceStack)commandContext.getSource()).m_81375_());
            return 1;
        }
        Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
        if (optionMap.containsKey(configOption) && (configOption2 = optionMap.get(configOption)) instanceof ListLikeOption) {
            ListLikeOption option = (ListLikeOption)configOption2;
            Pair<Boolean, ConfigParsingException> result = option.editList(input, listIndex, isEdit);
            if (!((Boolean)result.getFirst()).booleanValue()) {
                EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_FAIL_PARSE.get(((ConfigParsingException)result.getSecond()).getMessage()));
                return 0;
            }
            if (!isEdit) {
                EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_LIST_REMOVE_SUCCESS.get(configOption + "[" + listIndex + "]"), true);
            }
            if (listIndex < 0) {
                listIndex = option.getSize() - 1;
            }
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_SUCCESS.get(configOption + "[" + listIndex + "]", input), true);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_FAIL_MISSING.get(configOption));
        return 0;
    }

    static int commandEditMap(CommandContext<CommandSourceStack> commandContext, ConfigFile file, String configOption, boolean isSet) throws CommandSyntaxException {
        ConfigOption<?> configOption2;
        String input = isSet ? StringArgumentType.getString(commandContext, (String)"value") : "";
        String key = StringArgumentType.getString(commandContext, (String)"key");
        if (file.isClientOnly()) {
            new SPacketEditMapConfig(file.getFileID(), configOption, input, key, isSet).sendTo(((CommandSourceStack)commandContext.getSource()).m_81375_());
            return 1;
        }
        Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
        if (optionMap.containsKey(configOption) && (configOption2 = optionMap.get(configOption)) instanceof MapLikeOption) {
            MapLikeOption option = (MapLikeOption)configOption2;
            Pair<Boolean, ConfigParsingException> result = option.editMap(input, key, isSet);
            if (!((Boolean)result.getFirst()).booleanValue()) {
                EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_FAIL_PARSE.get(((ConfigParsingException)result.getSecond()).getMessage()));
                return 0;
            }
            if (!isSet) {
                EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_LIST_REMOVE_SUCCESS.get(configOption + "[" + key + "]"), true);
            }
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_SUCCESS.get(configOption + "[" + key + "]", input), true);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_FAIL_MISSING.get(configOption));
        return 0;
    }

    public static ArgumentBuilder<CommandSourceStack, ?> configResetCommands() {
        LiteralArgumentBuilder view = Commands.m_82127_((String)"reset");
        for (ConfigFile file : ConfigFile.getAvailableFiles()) {
            LiteralArgumentBuilder fileSection = (LiteralArgumentBuilder)Commands.m_82127_((String)file.getFileID().toString()).requires(stack -> file.isClientOnly() ? stack.m_230897_() : stack.m_6761_(2));
            file.getAllOptions().forEach((key, option) -> fileSection.then(Commands.m_82127_((String)key).executes(context -> CommandConfig.commandReset((CommandContext<CommandSourceStack>)context, file, key))));
            view.then((ArgumentBuilder)fileSection);
        }
        return view;
    }

    static int commandReset(CommandContext<CommandSourceStack> commandContext, ConfigFile file, String configOption) throws CommandSyntaxException {
        if (file.isClientOnly()) {
            new SPacketResetConfig(file.getFileID(), configOption).sendTo(((CommandSourceStack)commandContext.getSource()).m_81375_());
            return 1;
        }
        Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
        if (optionMap.containsKey(configOption)) {
            ConfigOption<?> option = optionMap.get(configOption);
            option.setToDefault();
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_SUCCESS.get(option.getName(), option.write()), true);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_FAIL_MISSING.get(configOption));
        return 0;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> configViewCommands() {
        LiteralArgumentBuilder view = Commands.m_82127_((String)"view");
        for (ConfigFile file : ConfigFile.getAvailableFiles()) {
            LiteralArgumentBuilder fileSection = (LiteralArgumentBuilder)Commands.m_82127_((String)file.getFileID().toString()).requires(stack -> stack.m_230897_() || !file.isClientOnly());
            file.getAllOptions().forEach((key, option) -> fileSection.then(Commands.m_82127_((String)key).executes(context -> CommandConfig.commandView((CommandContext<CommandSourceStack>)context, file, key))));
            view.then((ArgumentBuilder)fileSection);
        }
        return view;
    }

    static int commandView(CommandContext<CommandSourceStack> commandContext, ConfigFile file, String configOption) throws CommandSyntaxException {
        if (file.isClientOnly()) {
            new SPacketViewConfig(file.getFileID(), configOption).sendTo(((CommandSourceStack)commandContext.getSource()).m_81375_());
            return 1;
        }
        Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
        if (optionMap.containsKey(configOption)) {
            ConfigOption<?> option = optionMap.get(configOption);
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_VIEW.get(option.getName()), false);
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.literal(option.write()), false);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_FAIL_MISSING.get(configOption));
        return 0;
    }
}

