/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.easy;

import com.google.common.base.Suppliers;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class EasyTextButton
extends EasyButton {
    private Supplier<Component> text;

    protected EasyTextButton(@Nonnull EasyButton.EasyButtonBuilder<?> builder, @Nonnull Supplier<Component> text) {
        super(builder);
        this.text = text;
    }

    protected EasyTextButton(@Nonnull Builder builder) {
        super(builder);
        this.text = builder.text;
    }

    public final void m_93666_(@Nonnull Component text) {
        this.text = () -> text;
    }

    public final void setMessage(@Nonnull Supplier<Component> text) {
        this.text = text;
    }

    private int getTextureY() {
        int i = 1;
        if (!this.f_93623_) {
            i = 0;
        } else if (this.m_198029_()) {
            i = 2;
        }
        return 46 + i * 20;
    }

    @Override
    protected void renderWidget(@Nonnull EasyGuiGraphics gui) {
        gui.renderButtonBG(0, 0, this.m_5711_(), this.m_93694_(), this.f_93625_, this.getTextureY());
        int i = this.getFGColor();
        gui.drawScrollingString(this.text.get(), ScreenArea.of(2, 0, this.f_93618_ - 4, this.f_93619_), i | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
    }

    @Override
    protected void renderTick() {
        super.m_93666_(this.text.get());
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @FieldsAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    public static class Builder
    extends EasyButton.EasySizableButtonBuilder<Builder> {
        private Supplier<Component> text = EasyText::empty;

        protected Builder() {
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder text(Component text) {
            this.text = () -> text;
            return this;
        }

        public Builder text(Supplier<Component> text) {
            this.text = text;
            return this;
        }

        public Builder text(TextEntry text) {
            this.text = Suppliers.memoize(() -> text.get(new Object[0]));
            return this;
        }

        public EasyTextButton build() {
            return new EasyTextButton(this);
        }
    }
}

