/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.tax_collector;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.OwnerSelectionWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.menus.TaxCollectorMenu;
import io.github.lightman314.lightmanscurrency.common.menus.tax_collector.TaxCollectorClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.tax_collector.tabs.OwnershipTab;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class OwnershipClientTab
extends TaxCollectorClientTab<OwnershipTab> {
    private boolean manualMode = false;
    private OwnerSelectionWidget ownerSelectionWidget;
    private EditBox playerOwnerInput;
    private EasyButton playerOwnerButton;

    public OwnershipClientTab(Object screen, OwnershipTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return ItemIcon.ofItem((ItemLike)Items.f_42680_);
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return LCText.TOOLTIP_TAX_COLLECTOR_OWNER.get(new Object[0]);
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        if (firstOpen) {
            this.manualMode = false;
        }
        this.playerOwnerInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 10, screenArea.y + 50, 160, 20, (Component)EasyText.empty()));
        this.playerOwnerInput.m_94199_(16);
        this.playerOwnerButton = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(10, 72))).width(screenArea.width - 20)).text(LCText.BUTTON_OWNER_SET_PLAYER).pressAction(this::SetOwnerPlayer)).addon(EasyAddonHelper.tooltip((Component)LCText.TOOLTIP_WARNING_CANT_BE_UNDONE.getWithStyle(ChatFormatting.YELLOW, ChatFormatting.BOLD)))).build());
        this.ownerSelectionWidget = this.addChild(((OwnerSelectionWidget.Builder)OwnerSelectionWidget.builder().position(screenArea.pos.offset(12, 30))).width(152).rows(6).selected(this::getCurrentOwner).handler(((OwnershipTab)this.commonTab)::SetOwner).oldWidget(this.ownerSelectionWidget).build());
        this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width - 25, 5))).pressAction(this::toggleInputMode)).icon(this::getModeIcon).addon(EasyAddonHelper.tooltip(this::getModeTooltip))).build());
        this.updateMode();
    }

    @Override
    public void tick() {
        if (this.manualMode) {
            this.playerOwnerButton.f_93623_ = !this.playerOwnerInput.m_94155_().isBlank();
        }
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TaxEntry entry = this.getEntry();
        MutableComponent ownerName = LCText.GUI_OWNER_NULL.get(new Object[0]);
        if (entry != null) {
            ownerName = entry.getOwner().getName();
        }
        gui.drawString((Component)LCText.GUI_OWNER_CURRENT.get(ownerName), 8, 6, 0x404040);
    }

    @Nullable
    protected OwnerData getCurrentOwner() {
        TaxEntry entry = ((TaxCollectorMenu)this.menu).getEntry();
        if (entry != null) {
            return entry.getOwner();
        }
        return null;
    }

    private void toggleInputMode(EasyButton button) {
        this.manualMode = !this.manualMode;
        this.updateMode();
    }

    private void updateMode() {
        this.playerOwnerInput.f_93624_ = this.playerOwnerButton.f_93624_ = this.manualMode;
        if (this.manualMode) {
            this.playerOwnerButton.f_93623_ = !this.playerOwnerInput.m_94155_().isBlank();
        }
        this.ownerSelectionWidget.setVisible(!this.manualMode);
    }

    private IconData getModeIcon() {
        return this.manualMode ? ItemIcon.ofItem((ItemLike)Items.f_42116_) : IconUtil.ICON_ALEX_HEAD;
    }

    private Component getModeTooltip() {
        return this.manualMode ? LCText.TOOLTIP_OWNERSHIP_MODE_SELECTION.get(new Object[0]) : LCText.TOOLTIP_OWNERSHIP_MODE_MANUAL.get(new Object[0]);
    }

    private void SetOwnerPlayer() {
        if (this.playerOwnerInput != null) {
            ((OwnershipTab)this.commonTab).SetOwnerPlayer(this.playerOwnerInput.m_94155_());
            this.playerOwnerInput.m_94144_("");
        }
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }
}

