/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageScreen;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.client.gui.easy.tabbed.AdvancedTabbedMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.tabbed.EasyMenuClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.util.IWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.WidgetRotation;
import io.github.lightman314.lightmanscurrency.client.gui.widget.util.LazyWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketCollectCoins;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenTrades;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class TraderStorageScreen
extends AdvancedTabbedMenuScreen<ITraderStorageMenu, TraderStorageMenu, TraderStorageTab, ITraderStorageScreen>
implements ITraderStorageScreen {
    EasyButton buttonShowTrades;
    EasyButton buttonTradeRules;
    private final LazyWidgetPositioner rightEdgePositioner = LazyWidgetPositioner.create(this, LazyWidgetPositioner.createTopdown(), 206, 0, 20);

    @Override
    @Nonnull
    public IWidgetPositioner getRightEdgePositioner() {
        return this.rightEdgePositioner;
    }

    public TraderStorageScreen(TraderStorageMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.resize(206, 236);
        menu.setMessageListener(this::serverMessage);
    }

    @Override
    @Nonnull
    protected IWidgetPositioner getTabButtonPositioner() {
        return LazyWidgetPositioner.create(this, LazyWidgetPositioner.createTopdown(WidgetRotation.LEFT), ScreenPosition.of(-25, 0), 25);
    }

    protected TraderStorageClientTab<?> getCurrentTab() {
        EasyMenuClientTab easyMenuClientTab = this.currentTab();
        if (easyMenuClientTab instanceof TraderStorageClientTab) {
            TraderStorageClientTab tab = (TraderStorageClientTab)easyMenuClientTab;
            return tab;
        }
        return null;
    }

    @Override
    public void init(ScreenArea screenArea) {
        this.rightEdgePositioner.clear();
        this.addChild(this.rightEdgePositioner);
        this.buttonShowTrades = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().pressAction(this::PressTradesButton)).icon(IconUtil.ICON_TRADER).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_TRADER_OPEN_TRADES))).addon(EasyAddonHelper.visibleCheck(this::showRightEdgeWidgets))).build());
        this.buttonTradeRules = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width, 0))).pressAction(this::PressTradeRulesButton)).icon(IconUtil.ICON_TRADE_RULES).addon(EasyAddonHelper.visibleCheck(() -> ((TraderStorageMenu)this.f_97732_).hasPermission("editTradeRules") && this.getCurrentTab().getTradeRuleTradeIndex() >= 0 && this.showRightEdgeWidgets()))).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_TRADER_TRADE_RULES_TRADE))).build());
        this.rightEdgePositioner.addWidgets(this.buttonTradeRules, this.buttonShowTrades);
        TraderData trader = ((TraderStorageMenu)this.f_97732_).getTrader();
        if (trader != null) {
            trader.onStorageScreenInit(this, this::addChild);
        }
        this.currentTab().onOpen();
        this.m_181908_();
    }

    @Override
    protected void renderBackground(@Nonnull EasyGuiGraphics gui) {
        if (((TraderStorageMenu)this.f_97732_).getTrader() == null) {
            this.m_7379_();
            return;
        }
        gui.renderNormalBackground(TraderScreen.GUI_TEXTURE, this);
        if (this.getCurrentTab().shouldRenderInventoryText()) {
            gui.drawString(this.f_169604_, 23, this.f_97727_ - 94, 0x404040);
        }
    }

    @Override
    public void screenTick() {
        if (((TraderStorageMenu)this.f_97732_).getTrader() == null) {
            this.m_7379_();
            return;
        }
        if (!((TraderStorageMenu)this.f_97732_).hasPermission("openStorage")) {
            this.m_7379_();
            new CPacketOpenTrades(((TraderStorageMenu)this.f_97732_).getTrader().getID()).send();
        }
    }

    @Override
    public boolean showRightEdgeWidgets() {
        return this.getCurrentTab().showRightEdgeButtons();
    }

    public void serverMessage(LazyPacketData message) {
        this.getCurrentTab().receiveServerMessage(message);
    }

    private void PressTradesButton(EasyButton button) {
        new CPacketOpenTrades(((TraderStorageMenu)this.f_97732_).getTrader().getID()).send();
    }

    private void PressCollectionButton(EasyButton button) {
        if (((TraderStorageMenu)this.f_97732_).hasPermission("collectCoins")) {
            CPacketCollectCoins.sendToServer();
        } else {
            Permissions.PermissionWarning(((TraderStorageMenu)this.f_97732_).player, "collect stored coins", "collectCoins");
        }
    }

    private void PressTradeRulesButton(EasyButton button) {
        if (this.getCurrentTab().getTradeRuleTradeIndex() < 0) {
            return;
        }
        this.ChangeTab(101, this.builder().setInt("TradeIndex", this.getCurrentTab().getTradeRuleTradeIndex()));
    }
}

