/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.BankAccountSelectionWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.menus.ATMCardMenu;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public class ATMCardScreen
extends EasyMenuScreen<ATMCardMenu> {
    private EasyButton buttonLockAccount;

    public ATMCardScreen(ATMCardMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.resize(200, 200);
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        this.addChild(((BankAccountSelectionWidget.Builder)BankAccountSelectionWidget.builder().position(screenArea.pos.offset(20, 25))).width(screenArea.width - 40).rows(6).filter(this::canAccess).selected(this::getVisibleSelectedAccount).handler(((ATMCardMenu)this.f_97732_)::setSelectedAccount).build());
        this.buttonLockAccount = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(20, screenArea.height - 40))).width(screenArea.width - 40)).text(this::getLockButtonText).pressAction(this::toggleAccountLocked)).addon(EasyAddonHelper.tooltips(this::getLockButtonTooltip))).build());
    }

    private BankReference getVisibleSelectedAccount() {
        BankReference reference = ((ATMCardMenu)this.f_97732_).getSelectedAccount();
        if (reference != null && ((ATMCardMenu)this.f_97732_).isAccountValid()) {
            return reference;
        }
        return null;
    }

    private boolean canAccess(@Nonnull BankReference reference) {
        return reference.allowedAccess(((ATMCardMenu)this.f_97732_).player);
    }

    @Override
    protected void renderBG(@Nonnull EasyGuiGraphics gui) {
        IBankAccount account;
        gui.renderNormalBackground(this);
        gui.renderSlot((IEasyScreen)this, (Slot)((ATMCardMenu)this.f_97732_).f_38839_.get(0));
        BankReference reference = ((ATMCardMenu)this.f_97732_).getSelectedAccount();
        if (reference != null && (account = reference.get()) != null) {
            gui.drawString((Component)account.getName(), 25, 10, 0x404040);
        }
    }

    @Override
    protected void renderTick() {
        this.buttonLockAccount.f_93623_ = ((ATMCardMenu)this.f_97732_).getAccountLocked() || ((ATMCardMenu)this.f_97732_).getSelectedAccount() != null;
    }

    private Component getLockButtonText() {
        return ((ATMCardMenu)this.f_97732_).getAccountLocked() ? LCText.BUTTON_ATM_CARD_UNLOCK.get(new Object[0]) : LCText.BUTTON_ATM_CARD_LOCK.get(new Object[0]);
    }

    private List<Component> getLockButtonTooltip() {
        return ((ATMCardMenu)this.f_97732_).getAccountLocked() ? null : LCText.TOOLTIP_ATM_CARD_LOCK.getAsList(new Object[0]);
    }

    private void toggleAccountLocked() {
        ((ATMCardMenu)this.f_97732_).setAccountLocked(!((ATMCardMenu)this.f_97732_).getAccountLocked());
    }
}

