/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.config;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.client.config.ItemTest;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CustomItemScaleData {
    private final List<Pair<ItemTest, Float>> data;
    public static final CustomItemScaleData EMPTY = new CustomItemScaleData((List<Pair<ItemTest, Float>>)ImmutableList.of());

    public List<Pair<ItemTest, Float>> getRawData() {
        return new ArrayList<Pair<ItemTest, Float>>(this.data);
    }

    public CustomItemScaleData(List<Pair<ItemTest, Float>> data) {
        this.data = ImmutableList.copyOf(data);
    }

    public float getCustomScale(ItemStack item) {
        for (Pair<ItemTest, Float> pair : this.data) {
            if (!((ItemTest)pair.getFirst()).test(item)) continue;
            return ((Float)pair.getSecond()).floatValue();
        }
        return 1.0f;
    }

    public static Pair<ItemTest, Float> parse(String string) throws ConfigParsingException {
        String[] split = string.split(";");
        if (split.length < 2) {
            throw new ConfigParsingException("Missing ';' in '" + string + "'");
        }
        if (split.length > 2) {
            throw new ConfigParsingException("Unexpected ';' in '" + string + "'");
        }
        ItemTest test = ItemTest.parse(split[0]);
        try {
            float scale = Float.parseFloat(split[1]);
            if (scale <= 0.0f) {
                throw new ConfigParsingException(split[1] + " cannot be less than or equal to 0");
            }
            return Pair.of((Object)test, (Object)Float.valueOf(scale));
        }
        catch (NumberFormatException e) {
            throw new ConfigParsingException(split[1] + " is not a valid scale");
        }
    }

    public static String write(Pair<ItemTest, Float> value) {
        return ((ItemTest)value.getFirst()).toString() + ";" + value.getSecond();
    }
}

