/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.variants.block.builtin;

import io.github.lightman314.lightmanscurrency.api.capability.variant.CapabilityVariantData;
import io.github.lightman314.lightmanscurrency.api.variants.block.block_entity.IVariantDataStorage;
import io.github.lightman314.lightmanscurrency.network.message.cap.SPacketSyncVariantBECap;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class VariantDataStorageAttachment
implements IVariantDataStorage,
ICapabilitySerializable<CompoundTag> {
    private final LazyOptional<IVariantDataStorage> optional = LazyOptional.of(() -> this);
    @Nullable
    private ResourceLocation variant = null;
    private boolean locked = false;
    private final BlockEntity parent;

    public VariantDataStorageAttachment(BlockEntity parent) {
        this.parent = parent;
    }

    @Override
    @Nullable
    public ResourceLocation getCurrentVariant() {
        return this.variant;
    }

    @Override
    public boolean isVariantLocked() {
        return this.locked;
    }

    @Override
    public void setVariant(@Nullable ResourceLocation variant, boolean locked) {
        this.variant = variant;
        this.locked = locked;
        this.parent.m_6596_();
        if (!this.parent.m_58904_().f_46443_) {
            new SPacketSyncVariantBECap(this.parent.m_58899_(), this.variant, this.locked).sendToTarget(PacketDistributor.TRACKING_CHUNK.with(() -> this.parent.m_58904_().m_46745_(this.parent.m_58899_())));
        }
    }

    public void syncWith(ServerPlayer player) {
        new SPacketSyncVariantBECap(this.parent.m_58899_(), this.variant, this.locked).sendTo(player);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.variant != null) {
            tag.m_128359_("Variant", this.variant.toString());
        }
        if (this.locked) {
            tag.m_128379_("Locked", true);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.variant = tag.m_128441_("Variant") ? VersionUtil.parseResource(tag.m_128461_("Variant")) : null;
        this.locked = tag.m_128471_("Locked");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction direction) {
        return CapabilityVariantData.CAPABILITY.orEmpty(capability, this.optional);
    }
}

