/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.variants.block.block_entity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.variant.CapabilityVariantData;
import io.github.lightman314.lightmanscurrency.api.variants.block.builtin.VariantChunkDataStorageAttachment;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.util.LazyOptional;

public interface IVariantDataStorage {
    @Nullable
    public ResourceLocation getCurrentVariant();

    public boolean isVariantLocked();

    default public void setVariant(@Nullable ResourceLocation variant) {
        this.setVariant(variant, this.isVariantLocked());
    }

    public void setVariant(@Nullable ResourceLocation var1, boolean var2);

    @Nullable
    public static IVariantDataStorage get(BlockGetter level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be != null) {
            return IVariantDataStorage.get(be);
        }
        if (level instanceof Level) {
            Level l = (Level)level;
            AtomicReference<Object> result = new AtomicReference<Object>(null);
            LevelChunk chunk = l.m_46745_(pos);
            LazyOptional optional2 = chunk.getCapability(VariantChunkDataStorageAttachment.CAP);
            optional2.ifPresent(data -> result.set(data.getData(CapabilityVariantData.getBlockCorner(level.m_8055_(pos), pos))));
            return result.get();
        }
        LightmansCurrency.LogWarning("Unable to obtain the IVariantDataStorage capability as the level " + level.getClass().getName() + " is not a proper level!");
        return null;
    }

    @Nullable
    @Deprecated
    public static IVariantDataStorage get(@Nullable BlockEntity be) {
        if (be == null) {
            return null;
        }
        if (be instanceof IVariantDataStorage) {
            IVariantDataStorage result = (IVariantDataStorage)be;
            return result;
        }
        if (!be.m_58898_()) {
            return null;
        }
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        LazyOptional optional = be.getCapability(CapabilityVariantData.CAPABILITY);
        if (optional.isPresent()) {
            optional.ifPresent(result::set);
        } else {
            LevelChunk chunk = be.m_58904_().m_46745_(be.m_58899_());
            LazyOptional optional2 = chunk.getCapability(VariantChunkDataStorageAttachment.CAP);
            optional2.ifPresent(data -> result.set(data.getData(be.m_58899_())));
        }
        return result.get();
    }

    @Nullable
    public static IVariantDataStorage get(LootContext context) {
        if (context.m_78936_(LootContextParams.f_81462_)) {
            return IVariantDataStorage.get((BlockEntity)context.m_165124_(LootContextParams.f_81462_));
        }
        if (context.m_78936_(LootContextParams.f_81460_)) {
            BlockPos pos = BlockPos.m_274446_((Position)((Position)context.m_165124_(LootContextParams.f_81460_)));
            return IVariantDataStorage.get((BlockGetter)context.m_78952_(), pos);
        }
        return null;
    }
}

