/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.SortTypeKey;
import java.util.Comparator;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class TerminalSortType
implements Comparator<TraderData> {
    private final SortTypeKey key;
    private InvertedSortType inverted = null;

    protected TerminalSortType(ResourceLocation id) {
        this(new SortTypeKey(id, false));
    }

    private TerminalSortType(SortTypeKey key) {
        this.key = key;
    }

    public ResourceLocation getID() {
        return this.key.id();
    }

    public SortTypeKey getKey() {
        return this.key;
    }

    public int sortPriority() {
        return 0;
    }

    protected String getTranslationKey() {
        return "gui." + this.getID().m_135827_() + ".terminal.sort_type." + this.getID().m_135815_();
    }

    public boolean supportsInverted() {
        return true;
    }

    public Component getName() {
        return EasyText.translatable(this.getTranslationKey(), new Object[0]);
    }

    public Component getInvertedName() {
        return EasyText.translatable(this.getTranslationKey() + ".inverted", new Object[0]);
    }

    @Nullable
    public final TerminalSortType getInverted() {
        if (this.supportsInverted() && this.inverted == null) {
            this.inverted = new InvertedSortType(this);
        }
        return this.inverted;
    }

    @Override
    public final int compare(TraderData traderA, TraderData traderB) {
        int result = this.sort(traderA, traderB);
        if (result == 0) {
            return Long.compare(traderA.getID(), traderB.getID());
        }
        return result;
    }

    protected abstract int sort(TraderData var1, TraderData var2);

    private static class InvertedSortType
    extends TerminalSortType {
        private final TerminalSortType parent;

        private InvertedSortType(TerminalSortType parent) {
            super(new SortTypeKey(parent.getID(), true));
            this.parent = parent;
        }

        @Override
        public boolean supportsInverted() {
            return false;
        }

        @Override
        public Component getName() {
            return this.parent.getInvertedName();
        }

        @Override
        protected int sort(TraderData traderA, TraderData traderB) {
            return this.parent.sort(traderB, traderA);
        }
    }
}

