/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.settings.pretty.builtin;

import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.settings.pretty.PrettyTextData;
import io.github.lightman314.lightmanscurrency.api.settings.pretty.PrettyTextWriter;
import io.github.lightman314.lightmanscurrency.common.util.TagUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BookTextWriter
extends PrettyTextWriter {
    public static final PrettyTextWriter INSTANCE = new BookTextWriter();
    public static final int LINES_PER_PAGE = 14;

    private BookTextWriter() {
    }

    @Override
    public boolean worksOnStack(ItemStack stack) {
        return stack.m_41720_() == Items.f_42615_ || InventoryUtil.ItemHasTag(stack, LCTags.Items.SETTINGS_REPLACE_WITH_WRITTEN_BOOK);
    }

    @Override
    public ItemStack writeLinesToStack(@Nullable Player player, ItemStack stack, PrettyTextData data) {
        ItemStack copyStack = new ItemStack((ItemLike)Items.f_42615_);
        CompoundTag tag = stack.m_41784_().m_6426_();
        String titleString = data.machineName().getString();
        if (titleString.length() > 32) {
            titleString = LCText.DATA_NAME_BACKUP.get(new Object[0]).m_130668_(32);
        }
        tag.m_128359_("title", titleString);
        String author = player != null ? player.m_36316_().getName() : LCText.GUI_OWNER_NULL.get(new Object[0]).getString();
        tag.m_128359_("author", author);
        tag.m_128405_("generation", 0);
        ArrayList<String> pages = new ArrayList<String>();
        MutableComponent currentPage = null;
        int lines = 0;
        for (Component line : data.lines()) {
            MutableComponent testPage;
            MutableComponent copy = line.m_6881_();
            MutableComponent mutableComponent = testPage = currentPage == null ? copy : currentPage.m_6881_().m_130946_("\n").m_7220_((Component)copy);
            if (BookTextWriter.pageTooLong((Component)testPage)) {
                pages.add(Component.Serializer.m_130703_((Component)currentPage));
                currentPage = copy;
                lines = 1;
                continue;
            }
            currentPage = testPage;
            if (++lines < 14) continue;
            pages.add(Component.Serializer.m_130703_((Component)currentPage));
            currentPage = null;
            lines = 0;
        }
        if (lines > 0 && currentPage != null) {
            pages.add(Component.Serializer.m_130703_(currentPage));
        }
        tag.m_128365_("pages", (Tag)TagUtil.writeStringList(pages));
        copyStack.m_41751_(tag);
        return copyStack;
    }

    private static boolean pageTooLong(Component page) {
        return Component.Serializer.m_130703_((Component)page).length() > Short.MAX_VALUE;
    }
}

