/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.value.holder;

import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public interface IMoneyHolder
extends IMoneyHandler {
    default public int priority() {
        return 0;
    }

    default public int inversePriority() {
        return this.priority() * -1;
    }

    default public void formatTooltip(@Nonnull List<Component> tooltip) {
        IMoneyHolder.defaultTooltipFormat(tooltip, this.getTooltipTitle(), this.getStoredMoney());
    }

    public static void defaultTooltipFormat(@Nonnull List<Component> tooltip, @Nonnull Component title, @Nonnull MoneyView contents) {
        if (contents.isEmpty()) {
            return;
        }
        tooltip.add(title);
        tooltip.addAll(contents.getAllText(new ChatFormatting[0]));
    }

    public Component getTooltipTitle();

    public static void sortPayFirst(@Nonnull List<IMoneyHolder> list) {
        list.sort(Comparator.comparingInt(IMoneyHolder::priority));
    }

    public static void sortTakeFirst(@Nonnull List<IMoneyHolder> list) {
        list.sort(Comparator.comparingInt(IMoneyHolder::inversePriority));
    }
}

