/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.data.variables.basic;

import io.github.lightman314.lightmanscurrency.api.misc.data.variables.EasyVariable;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IntVariable
extends EasyVariable<Integer> {
    private int value;
    private final int minValue;
    private final int maxValue;

    public IntVariable(int defaultValue, EasyVariable.Builder builder) {
        this(defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE, builder);
    }

    public IntVariable(int defaultValue, int minValue, int maxValue, EasyVariable.Builder builder) {
        super(builder);
        this.value = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public Integer get() {
        return this.value;
    }

    @Override
    protected void setInternal(Integer newValue) {
        if (this.value != (newValue = Integer.valueOf(MathUtil.clamp(newValue, this.minValue, this.maxValue)))) {
            this.value = newValue;
            this.setChanged();
        }
    }

    @Override
    public void save(CompoundTag tag, HolderLookup.Provider lookup) {
        tag.m_128405_(this.key, this.value);
    }

    @Override
    public void load(CompoundTag tag, HolderLookup.Provider lookup) {
        this.value = tag.m_128451_(this.key);
    }
}

