/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.filter;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface IItemTradeFilter {
    @Nullable
    public Predicate<ItemStack> getFilter(ItemStack var1);

    @Nullable
    public List<Component> getCustomTooltip(ItemStack var1);

    default public List<ItemStack> getDisplayableItems(ItemStack stack, @Nullable IItemHandler availableItems) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        Predicate<ItemStack> filter = this.getFilter(stack);
        if (filter == null) {
            return results;
        }
        if (availableItems != null) {
            for (int i = 0; i < availableItems.getSlots(); ++i) {
                ItemStack item = availableItems.getStackInSlot(i);
                if (item.m_41619_() || !filter.test(item) || IItemTradeFilter.isInList(results, item)) continue;
                results.add(item.m_255036_(stack.m_41613_()));
            }
        } else {
            try {
                boolean hasPermissions = LightmansCurrency.getProxy().getHasPermissionsSetting();
                Level level = LightmansCurrency.getProxy().safeGetDummyLevel();
                if (level != null) {
                    CreativeModeTabs.m_269226_((FeatureFlagSet)level.m_246046_(), (boolean)hasPermissions, (HolderLookup.Provider)level.m_9598_());
                }
            }
            catch (Exception e) {
                LightmansCurrency.LogWarning("Failed to rebuild creative tabs, display items may be inaccurate.", e);
            }
            for (CreativeModeTab tab : CreativeModeTabs.m_257478_()) {
                if (tab.m_257962_() != CreativeModeTab.Type.CATEGORY) continue;
                for (ItemStack item : tab.m_260957_()) {
                    if (!filter.test(item) || IItemTradeFilter.isInList(results, item)) continue;
                    results.add(item.m_255036_(stack.m_41613_()));
                }
            }
        }
        return results;
    }

    public static boolean isInList(List<ItemStack> list, ItemStack item) {
        for (ItemStack i : list) {
            if (!InventoryUtil.ItemMatches(i, item)) continue;
            return true;
        }
        return false;
    }
}

