/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreen;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ConfigScreen
extends EasyScreen {
    private final Screen parentScreen;
    public static final int BOTTOM_BUTTON_OFFSET = 25;
    private static final ResourceLocation HEADER_SEPARATOR = VersionUtil.vanillaResource("textures/gui/header_separator.png");
    private static final ResourceLocation FOOTER_SEPARATOR = VersionUtil.vanillaResource("textures/gui/footer_separator.png");
    private static final ResourceLocation MENU_LIST_BACKGROUND = VersionUtil.vanillaResource("textures/gui/menu_list_background.png");
    private static final ResourceLocation INWORLD_MENU_LIST_BACKGROUND = VersionUtil.vanillaResource("textures/gui/inworld_menu_list_background.png");

    public ConfigScreen(Screen parentScreen) {
        super((Component)EasyText.empty());
        this.parentScreen = parentScreen;
    }

    @Override
    protected void preInit() {
        this.resize(this.f_96543_, this.f_96544_);
    }

    public final void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
        this.afterClose();
    }

    protected void afterClose() {
    }

    protected int headerSize() {
        return 33;
    }

    protected int footerSize() {
        return 33;
    }

    @Override
    protected final void renderBG(EasyGuiGraphics gui) {
        ScreenArea area = this.getArea();
        super.m_280273_(gui.getGui());
        gui.setColor(0.125f, 0.125f, 0.125f);
        gui.blit(Screen.f_279548_, 0, 0, 0, 0, this.f_96543_, this.headerSize(), 32, 32);
        gui.resetColor();
        RenderSystem.enableBlend();
        gui.blit(HEADER_SEPARATOR, 0, this.headerSize() - 2, 0, 0, area.width, 2, 32, 2);
        RenderSystem.disableBlend();
        gui.setColor(0.125f, 0.125f, 0.125f, 1.0f);
        gui.blit(Screen.f_279548_, 0, this.headerSize(), 0, 0, area.width, area.height - this.headerSize() - this.footerSize(), 32, 32);
        gui.resetColor();
        gui.setColor(0.125f, 0.125f, 0.125f);
        gui.blit(Screen.f_279548_, 0, area.height - this.footerSize(), 0, 0, this.f_96543_, this.footerSize(), 32, 32);
        gui.resetColor();
        RenderSystem.enableBlend();
        gui.blit(FOOTER_SEPARATOR, 0, area.height - this.footerSize(), 0, 0, area.width, 2, 32, 2);
        RenderSystem.disableBlend();
        TextRenderUtil.drawCenteredText(gui, this.m_96636_(), this.getArea().centerX(), 10, 0xFFFFFF, true);
        this.renderAdditionalBG(gui);
    }

    public Component m_96636_() {
        MutableComponent partialTitle = EasyText.empty();
        List<Component> titleSections = this.getTitleSections();
        if (titleSections.isEmpty()) {
            return partialTitle;
        }
        if (titleSections.size() == 1) {
            return titleSections.get(0);
        }
        for (int i = 0; i < titleSections.size(); ++i) {
            if (i > 0) {
                partialTitle.m_7220_((Component)LCText.CONFIG_TITLE_SEPERATOR.get(new Object[0]));
            }
            partialTitle.m_7220_(titleSections.get(i));
        }
        return partialTitle;
    }

    protected abstract List<Component> getTitleSections();

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    protected void renderAdditionalBG(EasyGuiGraphics gui) {
    }

    @Override
    public boolean m_7043_() {
        return true;
    }
}

