/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;

public interface ConfigReloadable {
    public static final int PRIORITY_MONEY_PHASE = 100;
    public static final int PRIORITY_AFTER_MONEY_CONFIGS = 500;
    public static final int PRIORITY_AFTER_ALL = 1000;

    public ResourceLocation getID();

    default public int getDelayPriority() {
        return 0;
    }

    public void onCommandReload(CommandSourceStack var1) throws CommandSyntaxException;

    public boolean canReload(CommandSourceStack var1);

    public boolean alertAdmins();

    public static ConfigReloadable simpleReloader(final ResourceLocation id, final Consumer<CommandSourceStack> reloader) {
        return new ConfigReloadable(){

            @Override
            public ResourceLocation getID() {
                return id;
            }

            @Override
            public void onCommandReload(CommandSourceStack stack) {
                reloader.accept(stack);
            }

            @Override
            public boolean canReload(CommandSourceStack stack) {
                return stack.m_6761_(2);
            }

            @Override
            public boolean alertAdmins() {
                return true;
            }
        };
    }

    public static ConfigReloadable simpleReloader(final ResourceLocation id, final int priority, final Consumer<CommandSourceStack> reloader) {
        return new ConfigReloadable(){

            @Override
            public ResourceLocation getID() {
                return id;
            }

            @Override
            public int getDelayPriority() {
                return priority;
            }

            @Override
            public void onCommandReload(CommandSourceStack stack) {
                reloader.accept(stack);
            }

            @Override
            public boolean canReload(CommandSourceStack stack) {
                return stack.m_6761_(2);
            }

            @Override
            public boolean alertAdmins() {
                return true;
            }
        };
    }
}

