/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.world;

import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.TDMSyncMessage;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class TDMSavedData
extends SavedData {
    public static final String FILE_ID = "superbwarfare_tdm";
    private final Set<String> entities = Sets.newHashSet();

    public TDMSavedData() {
    }

    public TDMSavedData(Collection<String> entities) {
        this.entities.addAll(entities);
    }

    public CompoundTag m_7176_(CompoundTag pCompoundTag) {
        pCompoundTag.m_128365_("Entities", (Tag)this.saveEntities());
        return pCompoundTag;
    }

    public static TDMSavedData load(CompoundTag pCompoundTag) {
        TDMSavedData tdmSavedData = new TDMSavedData();
        if (pCompoundTag.m_128425_("Entities", 9)) {
            tdmSavedData.loadEntities(pCompoundTag.m_128437_("Entities", 8));
        }
        return tdmSavedData;
    }

    private ListTag saveEntities() {
        ListTag listtag = new ListTag();
        for (String s : this.entities) {
            listtag.add((Object)StringTag.m_129297_((String)s));
        }
        return listtag;
    }

    private void loadEntities(ListTag pTagList) {
        for (int i = 0; i < pTagList.size(); ++i) {
            this.entities.add(pTagList.m_128778_(i));
        }
    }

    public Set<String> getEntities() {
        return this.entities;
    }

    public boolean addEntity(String entity) {
        return this.entities.add(entity);
    }

    public boolean removeEntity(String entity) {
        return this.entities.remove(entity);
    }

    public boolean containsEntity(String entity) {
        return this.entities.contains(entity);
    }

    public void sync() {
        this.m_77762_();
        NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new TDMSyncMessage(this));
    }

    public static boolean enabledTDM(Entity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return ((TDMSavedData)serverLevel.m_8895_().m_164861_(TDMSavedData::load, TDMSavedData::new, FILE_ID)).containsEntity(entity.m_20149_());
        }
        return ClientEventHandler.tdmSavedData.containsEntity(entity.m_20149_());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (!(player2 instanceof ServerPlayer) || !((player2 = (player = (ServerPlayer)player2).m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)player2;
        TDMSavedData data = (TDMSavedData)level.m_8895_().m_164858_(TDMSavedData::load, FILE_ID);
        if (data == null) {
            return;
        }
        NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new TDMSyncMessage(data));
    }
}

