/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.data.gun.Ammo;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.common.ammo.AmmoBoxItem;
import com.atsuishio.superbwarfare.item.common.ammo.AmmoSupplierItem;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public class InventoryTool {
    public static int countItem(@Nullable IItemHandler handler, @NotNull Item item) {
        return InventoryTool.countItem(handler, (ItemStack stack) -> stack.m_150930_(item));
    }

    public static int countItem(@Nullable IItemHandler handler, @NotNull TagKey<Item> item) {
        return InventoryTool.countItem(handler, (ItemStack stack) -> stack.m_204117_(item));
    }

    public static int countItem(@Nullable IItemHandler handler, @NotNull Predicate<ItemStack> predicate) {
        if (handler == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!predicate.test(stack)) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    public static int countItem(@Nullable NonNullList<ItemStack> itemList, @NotNull Item item) {
        if (itemList == null) {
            return 0;
        }
        return itemList.stream().filter(stack -> stack.m_150930_(item)).mapToInt(ItemStack::m_41613_).sum();
    }

    public static int countItem(@Nullable Entity entity, @NotNull Item item) {
        if (entity == null) {
            return 0;
        }
        return entity.getCapability(ForgeCapabilities.ITEM_HANDLER).map(c -> InventoryTool.countItem(c, item)).orElse(0);
    }

    public static int countAmmoItem(@Nullable IItemHandler handler, @Nullable Ammo type) {
        if (handler == null || type == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            int stackAmmo;
            ItemStack stack = handler.getStackInSlot(i);
            Item item = stack.m_41720_();
            if (item instanceof AmmoSupplierItem) {
                AmmoSupplierItem ammoSupplierItem = (AmmoSupplierItem)item;
                if (ammoSupplierItem.type == type) {
                    count += ammoSupplierItem.ammoToAdd * stack.m_41613_();
                }
            }
            if (!(stack.m_41720_() instanceof AmmoBoxItem) || (stackAmmo = type.get(stack)) <= 0) continue;
            count += stackAmmo;
        }
        return count;
    }

    public static int countAmmoItem(@Nullable Entity entity, @Nullable Ammo type) {
        if (entity == null || type == null) {
            return 0;
        }
        return entity.getCapability(ForgeCapabilities.ITEM_HANDLER).map(cap -> InventoryTool.countAmmoItem(cap, type)).orElse(0);
    }

    public static int consumeAmmoItem(@Nullable Entity entity, @Nullable Ammo type, int count) {
        if (entity == null || type == null || count <= 0) {
            return 0;
        }
        return entity.getCapability(ForgeCapabilities.ITEM_HANDLER).map(cap -> InventoryTool.consumeAmmoItem(cap, type, count)).orElse(0);
    }

    public static int consumeAmmoItem(@Nullable IItemHandler handler, @Nullable Ammo type, int count) {
        if (handler == null || type == null) {
            return 0;
        }
        int initialCount = count;
        for (int i = 0; i < handler.getSlots(); ++i) {
            int stackAmmo;
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41720_() instanceof AmmoBoxItem && (stackAmmo = type.get(stack)) > 0) {
                int maxConsumable = Math.min((int)stackAmmo, (int)count);
                type.set(stack, stackAmmo - maxConsumable);
                count -= maxConsumable;
                continue;
            }
            Item maxConsumable = stack.m_41720_();
            if (!(maxConsumable instanceof AmmoSupplierItem)) continue;
            AmmoSupplierItem ammoSupplierItem = (AmmoSupplierItem)maxConsumable;
            if (ammoSupplierItem.type != type) continue;
            int supplyCount = ammoSupplierItem.ammoToAdd;
            int required = count % supplyCount == 0 ? count / supplyCount : count / supplyCount + 1;
            int countToShrink = Math.min((int)stack.m_41613_(), (int)required);
            stack.m_41774_(countToShrink);
            if ((count -= countToShrink * supplyCount) <= 0) break;
        }
        return initialCount - count;
    }

    public static boolean hasItem(@Nullable Entity entity, @NotNull Item item) {
        return !InventoryTool.findFirst(entity, item).m_41619_();
    }

    public static boolean hasItem(@Nullable NonNullList<ItemStack> itemList, @NotNull Item item) {
        return !InventoryTool.findFirst(itemList, item).m_41619_();
    }

    public static ItemStack findFirst(@Nullable Entity entity, @NotNull Item item) {
        if (entity == null) {
            return ItemStack.f_41583_;
        }
        return InventoryTool.findFirst((IItemHandler)entity.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElse(null), (ItemStack stack) -> stack.m_150930_(item));
    }

    public static ItemStack findFirst(@Nullable IItemHandler handler, @NotNull Item item) {
        return InventoryTool.findFirst(handler, (ItemStack stack) -> stack.m_150930_(item));
    }

    public static ItemStack findFirst(@Nullable NonNullList<ItemStack> list, @NotNull Item item) {
        return InventoryTool.findFirst(list, (ItemStack stack) -> stack.m_150930_(item));
    }

    public static ItemStack findFirst(@Nullable NonNullList<ItemStack> list, @NotNull Predicate<ItemStack> predicate) {
        if (list == null) {
            return ItemStack.f_41583_;
        }
        return list.stream().filter(predicate).findFirst().orElse(ItemStack.f_41583_);
    }

    public static ItemStack findFirst(@Nullable IItemHandler handler, @NotNull Predicate<ItemStack> predicate) {
        if (handler == null) {
            return ItemStack.f_41583_;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!predicate.test(stack)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean hasCreativeAmmoBox(@Nullable IItemHandler handler) {
        return !InventoryTool.findFirst(handler, (Item)ModItems.CREATIVE_AMMO_BOX.get()).m_41619_();
    }

    public static boolean hasCreativeAmmoBox(@Nullable NonNullList<ItemStack> itemList) {
        return !InventoryTool.findFirst(itemList, (Item)ModItems.CREATIVE_AMMO_BOX.get()).m_41619_();
    }

    public static boolean hasCreativeAmmoBox(@Nullable Entity entity) {
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            return InventoryTool.hasCreativeAmmoBoxForVehicle(vehicle);
        }
        return InventoryTool.hasItem(entity, (Item)ModItems.CREATIVE_AMMO_BOX.get());
    }

    public static boolean hasCreativeAmmoBoxForVehicle(@NotNull VehicleEntity vehicle) {
        List passengers = vehicle.m_20197_();
        boolean flag = passengers.stream().anyMatch(e -> InventoryTool.hasItem(e, (Item)ModItems.CREATIVE_AMMO_BOX.get())) && vehicle.data().compute().usePassengerCreativeAmmoBox;
        return flag || InventoryTool.hasItem(vehicle, (Item)ModItems.CREATIVE_AMMO_BOX.get());
    }

    public static int consumeItem(@Nullable NonNullList<ItemStack> itemList, Item item, int count) {
        return InventoryTool.consumeItem(itemList, (ItemStack stack) -> stack.m_150930_(item), count);
    }

    public static void consumeItem(LivingEntity living, Item item, int count) {
        living.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> InventoryTool.consumeItem(handler, item, count));
    }

    public static int consumeItem(@Nullable NonNullList<ItemStack> itemList, Predicate<ItemStack> predicate, int count) {
        if (itemList == null || count <= 0) {
            return 0;
        }
        int initialCount = count;
        List<ItemStack> items = itemList.stream().filter(predicate).toList();
        for (ItemStack stack : items) {
            int countToShrink = Math.min((int)stack.m_41613_(), (int)count);
            stack.m_41774_(countToShrink);
            if ((count -= countToShrink) > 0) continue;
            break;
        }
        return initialCount - count;
    }

    public static int consumeItem(@Nullable IItemHandler handler, Item item, int count) {
        return InventoryTool.consumeItem(handler, (ItemStack stack) -> stack.m_150930_(item), count);
    }

    public static int consumeItem(@Nullable IItemHandler handler, Predicate<ItemStack> predicate, int count) {
        if (handler == null || count <= 0) {
            return 0;
        }
        int initialCount = count;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!predicate.test(stack)) continue;
            int countToShrink = Math.min((int)stack.m_41613_(), (int)count);
            stack.m_41774_(countToShrink);
            if ((count -= countToShrink) <= 0) break;
        }
        return initialCount - count;
    }

    public static int insertItem(@Nullable NonNullList<ItemStack> itemList, Item item, int count, int maxStackSize) {
        if (itemList == null || count <= 0) {
            return count;
        }
        ItemStack defaultStack = new ItemStack((ItemLike)item);
        maxStackSize = Math.min((int)maxStackSize, (int)item.getMaxStackSize(defaultStack));
        for (int i = 0; i < itemList.size(); ++i) {
            ItemStack stack = (ItemStack)itemList.get(i);
            if (stack.m_150930_(item) && stack.m_41613_() < maxStackSize) {
                countToAdd = Math.min((int)(maxStackSize - stack.m_41613_()), (int)count);
                stack.m_41769_(countToAdd);
                count -= countToAdd;
            } else if (stack.m_41619_()) {
                countToAdd = Math.min((int)maxStackSize, (int)count);
                itemList.set(i, (Object)new ItemStack((ItemLike)item, countToAdd));
                count -= countToAdd;
            }
            if (count <= 0) break;
        }
        return count;
    }

    public static int insertItem(@Nullable NonNullList<ItemStack> itemList, ItemStack stack) {
        if (itemList == null) {
            return stack.m_41613_();
        }
        int maxStackSize = stack.m_41720_().getMaxStackSize(stack);
        int originalCount = stack.m_41613_();
        for (int i = 0; i < itemList.size(); ++i) {
            ItemStack currentStack = (ItemStack)itemList.get(i);
            if (ItemStack.m_150942_((ItemStack)stack, (ItemStack)currentStack) && currentStack.m_41613_() < maxStackSize) {
                int countToAdd = Math.min((int)(maxStackSize - currentStack.m_41613_()), (int)stack.m_41613_());
                currentStack.m_41769_(countToAdd);
                stack.m_41764_(stack.m_41613_() - countToAdd);
            } else if (currentStack.m_41619_()) {
                itemList.set(i, (Object)stack);
                return stack.m_41613_();
            }
            if (stack.m_41613_() <= 0) break;
        }
        return originalCount - stack.m_41613_();
    }
}

