/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class CustomExplosion
extends Explosion {
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final float damage;
    private int fireTime;
    private float damageMultiplier = 1.0f;

    public CustomExplosion(Level pLevel, @Nullable Entity pSource, @Nullable DamageSource source, @Nullable ExplosionDamageCalculator pDamageCalculator, float damage, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius, Explosion.BlockInteraction pBlockInteraction) {
        super(pLevel, pSource, source, null, pToBlowX, pToBlowY, pToBlowZ, pRadius, false, pBlockInteraction);
        this.level = pLevel;
        this.source = pSource;
        this.radius = pRadius;
        this.damageSource = source == null ? pLevel.m_269111_().m_269093_((Explosion)this) : source;
        this.damageCalculator = pDamageCalculator == null ? new ExplosionDamageCalculator() : pDamageCalculator;
        this.x = pToBlowX;
        this.y = pToBlowY;
        this.z = pToBlowZ;
        this.damage = damage;
    }

    public CustomExplosion(Level pLevel, @Nullable Entity pSource, float damage, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius, Explosion.BlockInteraction pBlockInteraction) {
        this(pLevel, pSource, null, null, damage, pToBlowX, pToBlowY, pToBlowZ, pRadius, pBlockInteraction);
    }

    public CustomExplosion(Level pLevel, @Nullable Entity pSource, @Nullable DamageSource source, float damage, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius, Explosion.BlockInteraction pBlockInteraction) {
        this(pLevel, pSource, source, null, damage, pToBlowX, pToBlowY, pToBlowZ, pRadius, pBlockInteraction);
        ShakeClientMessage.sendToNearbyPlayers(this.level, pToBlowX, pToBlowY, pToBlowZ, 4.0f * this.radius, 20.0 + 0.2 * (double)this.radius, 50.0 + 0.5 * (double)this.radius);
    }

    public CustomExplosion(Level pLevel, @Nullable Entity pSource, @Nullable DamageSource source, float damage, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius) {
        this(pLevel, pSource, source, null, damage, pToBlowX, pToBlowY, pToBlowZ, pRadius, Explosion.BlockInteraction.KEEP);
        ShakeClientMessage.sendToNearbyPlayers(this.level, pToBlowX, pToBlowY, pToBlowZ, this.radius, 5.0 + 0.2 * (double)this.radius, 2.0 + 0.02 * (double)this.radius);
    }

    public CustomExplosion setFireTime(int fireTime) {
        this.fireTime = fireTime;
        return this;
    }

    public CustomExplosion setDamageMultiplier(float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
        return this;
    }

    public CustomExplosion bulletExplode() {
        return this;
    }

    public void m_46061_() {
        Entity entity;
        this.level.m_220400_(this.source, GameEvent.f_157812_, new Vec3(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                block2: for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    for (float f = this.radius * (0.2f + this.level.f_46441_.m_188501_() * 0.15f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = BlockPos.m_274561_((double)d4, (double)d6, (double)d8);
                        BlockState blockstate = this.level.m_8055_(blockpos);
                        FluidState fluidstate = this.level.m_6425_(blockpos);
                        if (!this.level.m_46739_(blockpos)) continue block2;
                        Optional optional = this.damageCalculator.m_6617_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, fluidstate);
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 1.0f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.m_6714_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, f)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.m_46081_().addAll(set);
        float diameter = this.radius * 2.0f;
        int x0 = Mth.m_14107_((double)(this.x - (double)diameter - 1.0));
        int x1 = Mth.m_14107_((double)(this.x + (double)diameter + 1.0));
        int y0 = Mth.m_14107_((double)(this.y - (double)diameter - 1.0));
        int y1 = Mth.m_14107_((double)(this.y + (double)diameter + 1.0));
        int z0 = Mth.m_14107_((double)(this.z - (double)diameter - 1.0));
        int z1 = Mth.m_14107_((double)(this.z + (double)diameter + 1.0));
        List list = this.level.m_45933_(this.source, new AABB((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1));
        ForgeEventFactory.onExplosionDetonate((Level)this.level, (Explosion)this, (List)list, (double)diameter);
        Vec3 position = new Vec3(this.x, this.y, this.z);
        boolean hit = false;
        for (Entity entity2 : list) {
            double zDistance;
            double yDistance;
            double xDistance;
            double distance;
            double distanceRate;
            if (entity2.m_6128_() || !((distanceRate = Math.sqrt(entity2.m_20238_(position)) / (double)diameter) <= 1.0) || (distance = Math.sqrt((xDistance = entity2.m_20185_() - this.x) * xDistance + (yDistance = (entity2 instanceof PrimedTnt ? entity2.m_20186_() : entity2.m_20188_()) - this.y) * yDistance + (zDistance = entity2.m_20189_() - this.z) * zDistance)) == 0.0) continue;
            double seenPercent = Mth.m_14008_((double)CustomExplosion.m_46064_((Vec3)position, (Entity)entity2), (double)(0.01 * (double)((Integer)ExplosionConfig.EXPLOSION_PENETRATION_RATIO.get()).intValue()), (double)Double.POSITIVE_INFINITY);
            double damagePercent = (1.0 - distanceRate) * seenPercent;
            double damageFinal = (damagePercent * damagePercent + damagePercent) / 2.0 * (double)this.damage;
            if (entity2 instanceof Monster) {
                Monster monster = (Monster)entity2;
                DamageHandler.doDamage((Entity)monster, this.damageSource, (float)damageFinal * (1.0f + 0.2f * this.damageMultiplier));
            } else {
                DamageHandler.doDamage(entity2, this.damageSource, (float)damageFinal);
            }
            if (entity2 instanceof LivingEntity) {
                Player player;
                LivingEntity living = (LivingEntity)entity2;
                double force = damageFinal * 0.015;
                force = ProtectionEnchantment.m_45135_((LivingEntity)living, (double)force);
                Vec3 vec31 = position.m_82505_(living.m_20191_().m_82399_()).m_82541_();
                if (entity2 instanceof Player && !(player = (Player)entity2).m_7500_() && !player.m_5833_()) {
                    entity2.m_20256_(entity2.m_20184_().m_82549_(vec31.m_82490_(force)));
                } else {
                    entity2.m_20256_(entity2.m_20184_().m_82549_(vec31.m_82490_(force)));
                }
            }
            if (entity2 instanceof LivingEntity || entity2 instanceof VehicleEntity) {
                hit = true;
            }
            entity2.f_19802_ = 1;
            if (this.fireTime <= 0) continue;
            entity2.m_20254_(this.fireTime);
        }
        if (hit && (entity = this.damageSource.m_7639_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            SoundTool.playLocalSound(player, (SoundEvent)ModSounds.INDICATION.get());
            NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
        }
    }

    public static class Builder {
        private final Level level;
        private Entity directSource;
        @Nullable
        private Entity sourceEntity;
        @Nullable
        private Entity attackerEntity;
        private float damage;
        private float radius;
        @Nullable
        private ParticleTool.ParticleType particleType = ParticleTool.ParticleType.MINI;
        private Supplier<Explosion.BlockInteraction> destroyBlock = () -> (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
        private int fireTime = 0;
        private float damageMultiplier = 1.0f;
        private DamageSource damageSource = null;
        private Vec3 particlePosition = null;
        public Vec3 position;

        public Builder(@NotNull Entity target) {
            this.level = target.m_9236_();
            this.directSource = target;
            this.sourceEntity = target;
            this.attackerEntity = target;
            this.position = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_());
        }

        public Builder directSource(@NotNull Entity directSource) {
            this.directSource = directSource;
            return this;
        }

        public Builder source(Entity source) {
            this.sourceEntity = source;
            return this;
        }

        public Builder attacker(Entity attacker) {
            this.attackerEntity = attacker;
            return this;
        }

        public Builder damage(float damage) {
            this.damage = damage;
            return this;
        }

        public Builder radius(float radius) {
            this.radius = radius;
            return this;
        }

        public Builder withParticleType(@Nullable ParticleTool.ParticleType particleType) {
            this.particleType = particleType;
            return this;
        }

        public Builder destroyBlock(Supplier<Explosion.BlockInteraction> destroyBlock) {
            this.destroyBlock = destroyBlock;
            return this;
        }

        public Builder keepBlock() {
            this.destroyBlock = () -> Explosion.BlockInteraction.KEEP;
            return this;
        }

        public Builder fireTime(int fireTime) {
            this.fireTime = fireTime;
            return this;
        }

        public Builder damageMultiplier(float damageMultiplier) {
            this.damageMultiplier = damageMultiplier;
            return this;
        }

        public Builder damageSource(DamageSource damageSource) {
            this.damageSource = damageSource;
            return this;
        }

        public Builder position(Vec3 position) {
            this.position = position;
            return this;
        }

        public Builder particlePosition(Vec3 particlePosition) {
            this.particlePosition = particlePosition;
            return this;
        }

        public void explode() {
            if (this.level.f_46443_) {
                return;
            }
            DamageSource source = this.damageSource != null ? this.damageSource : ModDamageTypes.causeCustomExplosionDamage(this.level.m_9598_(), this.sourceEntity, this.attackerEntity);
            CustomExplosion customExplosion = new CustomExplosion(this.level, this.directSource, source, this.damage, this.position.f_82479_, this.position.f_82480_, this.position.f_82481_, this.radius, this.destroyBlock.get()).setFireTime(this.fireTime).setDamageMultiplier(this.damageMultiplier);
            customExplosion.m_46061_();
            ForgeEventFactory.onExplosionStart((Level)this.directSource.m_9236_(), (Explosion)customExplosion);
            customExplosion.m_46075_(false);
            ParticleTool.spawnExplosionParticles(this.particleType, this.directSource.m_9236_(), this.particlePosition != null ? this.particlePosition : this.position);
        }
    }
}

