/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe;

import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModRecipes;
import com.atsuishio.superbwarfare.item.M18SmokeGrenade;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SmokeDyeRecipe
extends CustomRecipe {
    public SmokeDyeRecipe(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, pCategory);
    }

    public boolean matches(CraftingContainer pInv, @NotNull Level pLevel) {
        ItemStack itemstack = ItemStack.f_41583_;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < pInv.m_6643_(); ++i) {
            ItemStack stack = pInv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_((Item)ModItems.M18_SMOKE_GRENADE.get())) {
                if (!itemstack.m_41619_()) {
                    return false;
                }
                itemstack = stack;
                continue;
            }
            if (!(stack.m_41720_() instanceof DyeItem)) {
                return false;
            }
            list.add(stack);
        }
        return !itemstack.m_41619_() && !list.isEmpty();
    }

    @NotNull
    public ItemStack assemble(CraftingContainer pContainer, @NotNull RegistryAccess pRegistryAccess) {
        ArrayList list = Lists.newArrayList();
        ItemStack itemstack = ItemStack.f_41583_;
        for (int i = 0; i < pContainer.m_6643_(); ++i) {
            ItemStack stack = pContainer.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (stack.m_150930_((Item)ModItems.M18_SMOKE_GRENADE.get())) {
                if (!itemstack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                itemstack = stack.m_41777_();
                continue;
            }
            if (!(item instanceof DyeItem)) {
                return ItemStack.f_41583_;
            }
            DyeItem dyeItem = (DyeItem)item;
            list.add(dyeItem);
        }
        return !itemstack.m_41619_() && !list.isEmpty() ? SmokeDyeRecipe.dyeItem(itemstack, list) : ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.SMOKE_DYE_SERIALIZER.get();
    }

    public static ItemStack dyeItem(ItemStack pStack, List<DyeItem> pDyes) {
        ItemStack itemstack;
        M18SmokeGrenade grenade;
        int[] colors = new int[3];
        int i = 0;
        int j = 0;
        Item item = pStack.m_41720_();
        if (item instanceof M18SmokeGrenade) {
            grenade = (M18SmokeGrenade)item;
            itemstack = pStack.m_255036_(1);
            int color = grenade.getColor(pStack);
            if (color != 0xFFFFFF) {
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                i += (int)(Math.max(r, Math.max(g, b)) * 255.0f);
                colors[0] = colors[0] + (int)(r * 255.0f);
                colors[1] = colors[1] + (int)(g * 255.0f);
                colors[2] = colors[2] + (int)(b * 255.0f);
                ++j;
            }
            for (DyeItem dyeitem : pDyes) {
                float[] dyeColors = dyeitem.m_41089_().m_41068_();
                int r = (int)(dyeColors[0] * 255.0f);
                int g = (int)(dyeColors[1] * 255.0f);
                int b = (int)(dyeColors[2] * 255.0f);
                i += Math.max(r, Math.max(g, b));
                colors[0] = colors[0] + r;
                colors[1] = colors[1] + g;
                colors[2] = colors[2] + b;
                ++j;
            }
        } else {
            return ItemStack.f_41583_;
        }
        int red = colors[0] / j;
        int green = colors[1] / j;
        int blue = colors[2] / j;
        float rate = (float)i / (float)j;
        float max = Math.max(red, Math.max(green, blue));
        red = (int)((float)red * rate / max);
        green = (int)((float)green * rate / max);
        blue = (int)((float)blue * rate / max);
        int color = (red << 8) + green;
        color = (color << 8) + blue;
        grenade.setColor(itemstack, color);
        return itemstack;
    }
}

