/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraftforge.network.NetworkEvent;

public class SeekingWeaponWarningMessage {
    private final boolean lockOn;
    private final UUID uuid;

    public SeekingWeaponWarningMessage(boolean lockOn, UUID uuid) {
        this.lockOn = lockOn;
        this.uuid = uuid;
    }

    public static SeekingWeaponWarningMessage decode(FriendlyByteBuf buffer) {
        return new SeekingWeaponWarningMessage(buffer.readBoolean(), buffer.m_130259_());
    }

    public static void encode(SeekingWeaponWarningMessage message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.lockOn);
        buffer.m_130077_(message.uuid);
    }

    public static void handler(SeekingWeaponWarningMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player;
            Entity entity;
            if (context.getSender() != null && (entity = EntityFindUtil.findEntity((player = context.getSender()).m_9236_(), String.valueOf(message.uuid))) != null) {
                entity.m_9236_().m_5594_(null, entity.m_20097_(), entity instanceof Pig ? SoundEvents.f_12235_ : (message.lockOn ? (SoundEvent)ModSounds.LOCKED_WARNING.get() : (SoundEvent)ModSounds.LOCKING_WARNING.get()), SoundSource.PLAYERS, 2.0f, 1.0f);
            }
        });
        context.setPacketHandled(true);
    }
}

