/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.init.ModItems;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class DogTagFinishEditMessage {
    private final short[][] colors;
    private final String name;
    private final boolean mainHand;

    public DogTagFinishEditMessage(short[][] colors, String name, boolean mainHand) {
        this.colors = colors;
        this.name = name;
        this.mainHand = mainHand;
    }

    public static void encode(DogTagFinishEditMessage message, FriendlyByteBuf buffer) {
        buffer.m_130130_(Mth.m_14045_((int)message.colors.length, (int)0, (int)16));
        for (short[] color : message.colors) {
            buffer.m_130130_(Mth.m_14045_((int)color.length, (int)0, (int)16));
            for (short c : color) {
                buffer.writeShort((int)c);
            }
        }
        buffer.m_130070_(message.name);
        buffer.writeBoolean(message.mainHand);
    }

    public static DogTagFinishEditMessage decode(FriendlyByteBuf buffer) {
        int rows = buffer.m_130242_();
        if (rows < 0 || rows > 16) {
            throw new IllegalArgumentException("Invalid row count: " + rows);
        }
        short[][] colors = new short[rows][];
        for (int i = 0; i < colors.length; ++i) {
            int columns = buffer.m_130242_();
            if (columns < 0 || columns > 16) {
                throw new IllegalArgumentException("Invalid column count: " + columns);
            }
            colors[i] = new short[columns];
            for (int j = 0; j < colors[i].length; ++j) {
                colors[i][j] = buffer.readShort();
            }
        }
        String name = buffer.m_130277_();
        boolean mainHand = buffer.readBoolean();
        return new DogTagFinishEditMessage(colors, name, mainHand);
    }

    public static void handler(DogTagFinishEditMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayer == null) {
                return;
            }
            ItemStack itemStack = stack = message.mainHand ? serverPlayer.m_21205_() : serverPlayer.m_21206_();
            if (!stack.m_150930_((Item)ModItems.DOG_TAG.get())) {
                return;
            }
            CompoundTag colorsTag = new CompoundTag();
            for (int i = 0; i < message.colors.length; ++i) {
                int[] color = new int[message.colors[i].length];
                for (int j = 0; j < message.colors[i].length; ++j) {
                    color[j] = message.colors[i][j];
                }
                colorsTag.m_128385_("Color" + i, color);
            }
            stack.m_41784_().m_128365_("Colors", (Tag)colorsTag);
            if (!message.name.isEmpty()) {
                stack.m_41714_((Component)Component.m_237113_((String)message.name));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

