/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.receive;

import com.atsuishio.superbwarfare.data.CustomData;
import com.atsuishio.superbwarfare.data.vehicle.DefaultVehicleData;
import com.atsuishio.superbwarfare.tools.BufferSerializer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;

public record VehiclesDataMessage(List<DefaultVehicleData> data) {
    public static void encode(VehiclesDataMessage message, FriendlyByteBuf buf) {
        List<DefaultVehicleData> obj = message.data;
        buf.m_130130_(obj.size());
        for (DefaultVehicleData data : obj) {
            buf.writeBytes(BufferSerializer.serialize(data).copy());
        }
    }

    public static VehiclesDataMessage decode(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        ArrayList<DefaultVehicleData> list = new ArrayList<DefaultVehicleData>();
        for (int i = 0; i < size; ++i) {
            list.add(BufferSerializer.deserialize(buffer, new DefaultVehicleData()));
        }
        return new VehiclesDataMessage(list);
    }

    public static VehiclesDataMessage create() {
        return new VehiclesDataMessage(CustomData.VEHICLE_DATA.values().stream().toList());
    }

    public static void handler(VehiclesDataMessage message) {
        CustomData.VEHICLE_DATA.clear();
        for (DefaultVehicleData entry : message.data) {
            if (CustomData.VEHICLE_DATA.containsKey(entry.id)) continue;
            CustomData.VEHICLE_DATA.put(entry.id, entry);
        }
    }
}

