/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.receive;

import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ShakeClientMessage {
    public double time;
    public double radius;
    public double amplitude;
    public double x;
    public double y;
    public double z;

    public ShakeClientMessage(double time, double radius, double amplitude, double x, double y, double z) {
        this.time = time;
        this.radius = radius;
        this.amplitude = amplitude;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void encode(ShakeClientMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.time);
        buffer.writeDouble(message.radius);
        buffer.writeDouble(message.amplitude);
        buffer.writeDouble(message.x);
        buffer.writeDouble(message.y);
        buffer.writeDouble(message.z);
    }

    public static ShakeClientMessage decode(FriendlyByteBuf buffer) {
        return new ShakeClientMessage(buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    public static void handler(ShakeClientMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ShakeClientMessage.lambda$handler$1(message, (Supplier)context)));
        context.get().setPacketHandled(true);
    }

    public static void sendToNearbyPlayers(Level level, double x, double y, double z, double sendRadius, double time, double amplitude) {
        Vec3 center = new Vec3(x, y, z);
        for (ServerPlayer serverPlayer : level.m_6443_(ServerPlayer.class, new AABB(center, center).m_82400_(sendRadius), e -> true)) {
            NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ShakeClientMessage(time, sendRadius, amplitude, x, y, z));
        }
    }

    public static void sendToNearbyPlayers(Entity source, double sendRadius, double time, double amplitude) {
        if (sendRadius <= 0.0 || time <= 0.0 || amplitude <= 0.0) {
            return;
        }
        ShakeClientMessage.sendToNearbyPlayers(source.m_9236_(), source.m_20185_(), source.m_20186_(), source.m_20189_(), sendRadius, time, amplitude);
    }

    private static /* synthetic */ Runnable lambda$handler$1(ShakeClientMessage message, Supplier context) {
        return () -> ShakeClientMessage.lambda$handler$0(message, (Supplier)context);
    }

    private static /* synthetic */ void lambda$handler$0(ShakeClientMessage message, Supplier context) {
        ClientEventHandler.handleShakeClient(message.time, message.radius, message.amplitude, message.x, message.y, message.z, context);
    }
}

