/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.special;

import com.atsuishio.superbwarfare.client.renderer.gun.RepairToolItemRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.mixin.ICustomKnockback;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.BatteryItem;
import com.atsuishio.superbwarfare.item.gun.GunGeoItem;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.world.phys.EntityResult;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class RepairToolItem
extends GunGeoItem {
    public RepairToolItem() {
        super(new Item.Properties());
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return RepairToolItemRenderer::new;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IClientItemExtensions getClientExtensions() {
        return new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer;
            private static final HumanoidModel.ArmPose POSE = HumanoidModel.ArmPose.create((String)"RepairTool", (boolean)false, (model, entity, arm) -> {
                if (arm != HumanoidArm.LEFT) {
                    model.f_102811_.f_104203_ = -1.1780972f + model.f_102808_.f_104203_ + 0.05f * model.f_102811_.f_104203_;
                    model.f_102811_.f_104204_ = 0.08726646f + model.f_102808_.f_104204_;
                }
            });
            {
                this.renderer = (BlockEntityWithoutLevelRenderer)RepairToolItem.this.getRenderer().get();
            }

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack stack) {
                if (!stack.m_41619_() && entityLiving.m_7655_() == hand) {
                    return POSE;
                }
                return HumanoidModel.ArmPose.EMPTY;
            }
        };
    }

    @Override
    public void onRayHitBlock(Entity shooter, ServerLevel level, @Nullable Entity target, @NotNull GunData data, Vec3 shootDirection, BlockHitResult result, @NotNull Vec3 pos) {
        super.onRayHitBlock(shooter, level, target, data, shootDirection, result, pos);
        BlockPos blockPos = result.m_82425_();
        BlockState state = level.m_8055_(blockPos);
        this.summonRayHitParticle(level, state, pos, shootDirection.m_82490_(-1.0).m_82541_());
    }

    @Override
    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack cell : player.m_150109_().f_35974_) {
                if (!(cell.m_41720_() instanceof BatteryItem)) continue;
                assert (stack.getCapability(ForgeCapabilities.ENERGY).resolve().isPresent());
                IEnergyStorage stackStorage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).resolve().get();
                int stackMaxEnergy = stackStorage.getMaxEnergyStored();
                int stackEnergy = stackStorage.getEnergyStored();
                assert (cell.getCapability(ForgeCapabilities.ENERGY).resolve().isPresent());
                IEnergyStorage cellStorage = (IEnergyStorage)cell.getCapability(ForgeCapabilities.ENERGY).resolve().get();
                int cellEnergy = cellStorage.getEnergyStored();
                int stackEnergyNeed = Math.min(cellEnergy, stackMaxEnergy - stackEnergy);
                if (cellEnergy > 0) {
                    stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(iEnergyStorage -> iEnergyStorage.receiveEnergy(stackEnergyNeed, false));
                }
                cell.getCapability(ForgeCapabilities.ENERGY).ifPresent(cEnergy -> cEnergy.extractEnergy(stackEnergyNeed, false));
            }
        }
    }

    @Override
    public SoundEvent getRayHitBlockSound(GunData data) {
        return (SoundEvent)ModSounds.REPAIRING.get();
    }

    @Override
    public SoundEvent getRayHitEntitySound(GunData data) {
        return (SoundEvent)ModSounds.REPAIRING.get();
    }

    @Override
    public void onRayHitEntity(Entity shooter, ServerLevel level, @NotNull GunData data, EntityResult result, Vec3 shootPosition, Vec3 shootDirection) {
        Entity target = result.getEntity();
        Vec3 pos = result.getHitPos();
        level.m_6263_(null, result.getHitPos().f_82479_, result.getHitPos().f_82480_, result.getHitPos().f_82481_, this.getRayHitEntitySound(data), SoundSource.PLAYERS, 0.7f, (float)((2.0 * Math.random() - 1.0) * (double)0.05f + 1.0));
        if (target instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)target;
            Entity lastDriver = EntityFindUtil.findEntity((Level)level, (String)vehicle.m_20088_().m_135370_(VehicleEntity.LAST_DRIVER_UUID));
            if (lastDriver != null && !SeekTool.IN_SAME_TEAM.test(shooter, lastDriver) && lastDriver.m_5647_() != null || shooter.m_6144_()) {
                vehicle.m_6469_(ModDamageTypes.causeRepairToolDamage(level.m_9598_(), shooter), 0.5f);
                if (shooter instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)shooter;
                    player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 0.1f, 1.0f);
                    NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
                }
            } else {
                vehicle.heal(0.5f + 0.0025f * vehicle.getMaxHealth());
            }
            this.summonRayHitParticle(level, null, pos, shootDirection.m_82490_(-1.0).m_82541_());
        } else if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            if (target.m_6095_().m_204039_(ModTags.EntityTypes.CAN_REPAIR) && !shooter.m_6144_()) {
                living.m_5634_(0.5f + 0.0025f * living.m_21233_());
            } else {
                ICustomKnockback iCustomKnockback = ICustomKnockback.getInstance(living);
                iCustomKnockback.superbWarfare$setKnockbackStrength(0.0);
                float damage = (float)data.compute().damage;
                DamageHandler.doDamage((Entity)living, ModDamageTypes.causeRepairToolDamage(level.m_9598_(), shooter), damage);
                target.f_19802_ = 0;
                iCustomKnockback.superbWarfare$resetKnockbackStrength();
                if (shooter instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)shooter;
                    player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 0.1f, 1.0f);
                    NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
                }
            }
            this.summonRayHitParticle(level, null, pos, shootDirection.m_82490_(-1.0).m_82541_());
        }
    }

    public void summonRayHitParticle(ServerLevel serverLevel, @Nullable BlockState state, Vec3 pos, Vec3 dir) {
        int i;
        if (state != null) {
            BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.f_123794_, state);
            for (int i2 = 0; i2 < 1; ++i2) {
                Vec3 vec3 = this.randomVec(dir, 40.0);
                ParticleTool.sendParticle(serverLevel, particleData, pos.f_82479_ + 0.05 * (double)i2 * dir.f_82479_, pos.f_82480_ + 0.05 * (double)i2 * dir.f_82480_, pos.f_82481_ + 0.05 * (double)i2 * dir.f_82481_, 0, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 10.0, true);
            }
        }
        for (i = 0; i < 3; ++i) {
            Vec3 vec3 = this.randomVec(dir, 20.0);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.05, true);
        }
        for (i = 0; i < 2; ++i) {
            Vec3 vec3 = this.randomVec(dir, 80.0);
            ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.2 + 0.1 * Math.random(), true);
        }
    }
}

