/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.client.TooltipTool;
import com.atsuishio.superbwarfare.client.screens.ArtilleryIndicatorScreen;
import com.atsuishio.superbwarfare.config.server.MiscConfig;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArtilleryEntity;
import com.atsuishio.superbwarfare.item.ItemScreenProvider;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtilleryIndicator
extends Item
implements ItemScreenProvider {
    public static final String TAG_CANNON = "Cannons";
    public static final String TAG_TYPE = "Type";

    public ArtilleryIndicator() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        TooltipTool.addScreenProviderText(pTooltipComponents);
        if (pStack.m_41783_() != null && pStack.m_41783_().m_128441_(TAG_TYPE)) {
            pTooltipComponents.add((Component)Component.m_237110_((String)"des.superbwarfare.artillery_indicator.type", (Object[])new Object[]{Component.m_237115_((String)pStack.m_41783_().m_128461_(TAG_TYPE))}).m_130940_(ChatFormatting.WHITE));
        }
        pTooltipComponents.add((Component)Component.m_237115_((String)"des.superbwarfare.artillery_indicator_1").m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237115_((String)"des.superbwarfare.artillery_indicator_2").m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237115_((String)"des.superbwarfare.artillery_indicator_3").m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237115_((String)"des.superbwarfare.artillery_indicator_4").m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237113_((String)" ").m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237115_((String)"des.superbwarfare.artillery_indicator_5").m_130940_(ChatFormatting.GRAY));
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.SPYGLASS;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        if (pHand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19100_((Object)pPlayer.m_21120_(pHand));
        }
        pPlayer.m_5496_(SoundEvents.f_144231_, 1.0f, 1.0f);
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)pPlayer.m_21120_(pHand));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        pLivingEntity.m_5496_(SoundEvents.f_144232_, 1.0f, 1.0f);
        return pStack;
    }

    @ParametersAreNonnullByDefault
    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        pLivingEntity.m_5496_(SoundEvents.f_144232_, 1.0f, 1.0f);
    }

    public boolean checkFull(ItemStack stack) {
        ListTag tags = stack.m_41784_().m_128437_(TAG_CANNON, 10);
        return tags.size() >= (Integer)MiscConfig.ARTILLERY_INDICATOR_LIST_SIZE.get();
    }

    public boolean addCannon(ItemStack stack, Entity entity) {
        String uuid = entity.m_20149_();
        ListTag tags = stack.m_41784_().m_128437_(TAG_CANNON, 10);
        if (tags.isEmpty()) {
            stack.m_41784_().m_128359_(TAG_TYPE, entity.m_6095_().m_20675_());
        } else if (!stack.m_41784_().m_128461_(TAG_TYPE).equals(entity.m_6095_().m_20675_())) {
            return false;
        }
        ArrayList<CompoundTag> list = new ArrayList<CompoundTag>();
        for (int i = 0; i < tags.size(); ++i) {
            list.add(tags.m_128728_(i));
        }
        for (CompoundTag tag : list) {
            if (!tag.m_128461_("UUID").equals(uuid)) continue;
            return false;
        }
        CompoundTag uuidTag = new CompoundTag();
        uuidTag.m_128359_("UUID", uuid);
        list.add(uuidTag);
        ListTag listTag = new ListTag();
        listTag.addAll(list);
        stack.m_41784_().m_128365_(TAG_CANNON, (Tag)listTag);
        return true;
    }

    public boolean removeCannon(ItemStack stack, String uuid) {
        ListTag tags = stack.m_41784_().m_128437_(TAG_CANNON, 10);
        ArrayList<CompoundTag> list = new ArrayList<CompoundTag>();
        boolean flag = false;
        for (int i = 0; i < tags.size(); ++i) {
            CompoundTag tag = tags.m_128728_(i);
            if (tag.m_128461_("UUID").equals(uuid)) {
                flag = true;
                continue;
            }
            list.add(tags.m_128728_(i));
        }
        if (flag) {
            ListTag listTag = new ListTag();
            listTag.addAll(list);
            stack.m_41784_().m_128365_(TAG_CANNON, (Tag)listTag);
            if (listTag.isEmpty()) {
                stack.m_41784_().m_128473_(TAG_TYPE);
            }
        }
        return flag;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Screen getItemScreen(ItemStack stack, Player player, InteractionHand hand) {
        return new ArtilleryIndicatorScreen(stack, hand);
    }

    public void setTarget(ItemStack stack, Player player) {
        ListTag tags = stack.m_41784_().m_128437_(TAG_CANNON, 10);
        ArrayList<CompoundTag> list = new ArrayList<CompoundTag>();
        for (int i = 0; i < tags.size(); ++i) {
            CompoundTag tag = tags.m_128728_(i);
            Entity entity = EntityFindUtil.findEntity(player.m_9236_(), tag.m_128461_("UUID"));
            if (!(entity instanceof ArtilleryEntity)) continue;
            ArtilleryEntity artilleryEntity = (ArtilleryEntity)entity;
            list.add(tag);
            artilleryEntity.setTarget(stack, (Entity)player, "Main");
        }
        if (list.size() != tags.size()) {
            ListTag listTag = new ListTag();
            listTag.addAll(list);
            stack.m_41784_().m_128365_(TAG_CANNON, (Tag)listTag);
            if (listTag.isEmpty()) {
                stack.m_41784_().m_128473_(TAG_TYPE);
            }
        }
    }

    public InteractionResult bind(ItemStack stack, Player player, Entity entity) {
        if (this.checkFull(stack)) {
            player.m_5661_((Component)Component.m_237115_((String)"des.superbwarfare.artillery_indicator.full").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        if (this.addCannon(stack, entity)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            player.m_5661_((Component)Component.m_237110_((String)"des.superbwarfare.artillery_indicator.add", (Object[])new Object[]{entity.m_5446_()}).m_130940_(ChatFormatting.GREEN), true);
            return InteractionResult.SUCCESS;
        }
        if (this.removeCannon(stack, entity.m_20149_())) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            player.m_5661_((Component)Component.m_237110_((String)"des.superbwarfare.artillery_indicator.remove", (Object[])new Object[]{entity.m_5446_()}).m_130940_(ChatFormatting.RED), true);
            return InteractionResult.SUCCESS;
        }
        player.m_5661_((Component)Component.m_237110_((String)"des.superbwarfare.artillery_indicator.fail", (Object[])new Object[]{entity.m_5446_()}).m_130940_(ChatFormatting.RED), true);
        return InteractionResult.FAIL;
    }
}

