/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.utils;

import com.atsuishio.superbwarfare.data.StringOrVec3;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.vehicle.subdata.CameraPos;
import com.atsuishio.superbwarfare.data.vehicle.subdata.SeatInfo;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.math.Axis;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Matrix4d;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4d;

public final class VehicleVecUtils {
    public static double bombHitPosX;
    public static double bombHitPosY;
    public static double bombHitPosZ;

    public static Vector4d transformPosition(Matrix4d transform, double x, double y, double z) {
        return transform.transform(new Vector4d(x, y, z, 1.0));
    }

    public static double getYRotFromVector(Vec3 vec3) {
        return Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.29577951308232;
    }

    public static double getXRotFromVector(Vec3 vec3) {
        double d0 = vec3.m_165924_();
        return Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.29577951308232;
    }

    public static double getSubmergedHeight(Entity entity) {
        return entity.getFluidTypeHeight(entity.m_9236_().m_6425_(entity.m_20183_()).getFluidType());
    }

    public static Quaternionf eulerToQuaternion(float yaw, float pitch, float roll) {
        double cy = Math.cos((double)((double)yaw * 0.5 * 0.01745329238474369));
        double sy = Math.sin((double)((double)yaw * 0.5 * 0.01745329238474369));
        double cp = Math.cos((double)((double)pitch * 0.5 * 0.01745329238474369));
        double sp = Math.sin((double)((double)pitch * 0.5 * 0.01745329238474369));
        double cr = Math.cos((double)((double)roll * 0.5 * 0.01745329238474369));
        double sr = Math.sin((double)((double)roll * 0.5 * 0.01745329238474369));
        Quaternionf q = new Quaternionf();
        q.w = (float)(cy * cp * cr + sy * sp * sr);
        q.x = (float)(cy * cp * sr - sy * sp * cr);
        q.y = (float)(sy * cp * sr + cy * sp * cr);
        q.z = (float)(sy * cp * cr - cy * sp * sr);
        return q;
    }

    public static double calculateAngle(Vec3 move, Vec3 view) {
        move = move.m_82542_(1.0, 0.0, 1.0).m_82541_();
        view = view.m_82542_(1.0, 0.0, 1.0).m_82541_();
        return VectorTool.calculateAngle(move, view);
    }

    public static Vec3 entityEyePos(Entity entity, float partialTicks) {
        return new Vec3(Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(entity.f_19855_ + (double)entity.m_20192_()), (double)entity.m_20188_()), Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_()));
    }

    public static Vec3 simulate3P(Entity entity, float partialTicks, double distance, double height) {
        return new Vec3(Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_()) - distance * entity.m_20252_((float)partialTicks).f_82479_, Mth.m_14139_((double)partialTicks, (double)(entity.f_19855_ + (double)entity.m_20192_() + height), (double)(entity.m_20188_() + height)) - distance * entity.m_20252_((float)partialTicks).f_82480_, Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_()) - distance * entity.m_20252_((float)partialTicks).f_82481_);
    }

    public static void setDriverAngle(VehicleEntity vehicle, Player player) {
        if (vehicle.hasTurret()) {
            Vec3 barrelVector = vehicle.getBarrelVector(1.0f);
            double xRot = VehicleVecUtils.getXRotFromVector(barrelVector);
            double yRot = VehicleVecUtils.getYRotFromVector(barrelVector);
            player.f_19860_ = (float)(-xRot);
            player.m_146926_((float)(-xRot));
            player.f_19859_ = (float)(-yRot);
            player.m_146922_((float)(-yRot));
            player.m_5616_((float)(-yRot));
        } else {
            player.f_19860_ = vehicle.m_146909_();
            player.m_146926_(vehicle.m_146909_());
            player.f_19859_ = vehicle.m_146908_();
            player.m_146922_(vehicle.m_146908_());
        }
    }

    public static float getDamageSourceAngle(VehicleEntity vehicle, DamageSource source, float multiplier) {
        Entity attacker = source.m_7640_();
        if (attacker == null) {
            attacker = source.m_7639_();
        }
        if (attacker != null) {
            Vec3 toVec = new Vec3(vehicle.m_20185_(), vehicle.m_20186_() + (double)(vehicle.m_20206_() / 2.0f), vehicle.m_20189_()).m_82505_(attacker.m_20182_()).m_82541_();
            return (float)Math.max((double)(1.0 - (double)multiplier * toVec.m_82526_(vehicle.m_20252_(1.0f))), (double)0.5);
        }
        return 1.0f;
    }

    public static void setPassengerPitch(VehicleEntity vehicle, Entity entity, float minPitch, float maxPitch, float passengerRot) {
        if (passengerRot == 180.0f) {
            float min = minPitch + vehicle.m_146909_();
            float max = maxPitch + vehicle.m_146909_();
            float f = Mth.m_14177_((float)entity.m_146909_());
            float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
            entity.f_19860_ += f1 - f;
            entity.m_146926_(entity.m_146909_() + f1 - f);
        } else {
            float a = -passengerRot;
            float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            float min = -maxPitch - r * vehicle.m_146909_() - r2 * vehicle.getRoll();
            float max = -minPitch - r * vehicle.m_146909_() - r2 * vehicle.getRoll();
            float f = Mth.m_14177_((float)entity.m_146909_());
            float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
            entity.f_19860_ += f1 - f;
            entity.m_146926_(entity.m_146909_() + f1 - f);
        }
    }

    public static void setPassengerYaw(VehicleEntity vehicle, Entity entity, float minYaw, float maxYaw, float passengerRot) {
        if (passengerRot == 180.0f) {
            float f2 = Mth.m_14177_((float)(entity.m_146908_() - vehicle.m_146908_() + passengerRot));
            float f3 = Mth.m_14036_((float)f2, (float)minYaw, (float)maxYaw);
            entity.f_19859_ += f3 - f2;
            entity.m_146922_(entity.m_146908_() + f3 - f2);
        } else {
            float f2 = Mth.m_14177_((float)(entity.m_146908_() - vehicle.m_146908_()));
            float f3 = Mth.m_14036_((float)f2, (float)(passengerRot + minYaw), (float)(passengerRot + maxYaw));
            entity.f_19859_ += f3 - f2;
            entity.m_146922_(entity.m_146908_() + f3 - f2);
        }
        entity.m_5618_(vehicle.m_146908_() + passengerRot);
    }

    public static void setPassengerPitchOnTurret(VehicleEntity vehicle, Entity entity, float turretMinPitch, float turretMaxPitch) {
        float a = vehicle.getTurretYaw(1.0f);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float min = -turretMaxPitch - r * vehicle.m_146909_() - r2 * vehicle.getRoll();
        float max = -turretMinPitch - r * vehicle.m_146909_() - r2 * vehicle.getRoll();
        float f = Mth.m_14177_((float)entity.m_146909_());
        float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
        entity.f_19860_ += f1 - f;
        entity.m_146926_(entity.m_146909_() + f1 - f);
    }

    public static void setPassengerYawOnTurret(VehicleEntity vehicle, Entity entity, float minYaw, float maxYaw, float passengerRot, boolean rotateWithTurret) {
        if (passengerRot != 180.0f) {
            float f2 = Mth.m_14177_((float)(entity.m_146908_() - vehicle.m_146908_()));
            float f3 = Mth.m_14036_((float)f2, (float)(passengerRot + minYaw), (float)(passengerRot + maxYaw));
            entity.f_19859_ += f3 - f2;
            entity.m_146922_(entity.m_146908_() + f3 - f2);
        } else {
            float f2 = Mth.m_14177_((float)(entity.m_146908_() - vehicle.m_146908_() + 180.0f));
            float f3 = Mth.m_14036_((float)f2, (float)minYaw, (float)maxYaw);
            entity.f_19859_ += f3 - f2;
            entity.m_146922_(entity.m_146908_() + f3 - f2);
        }
        if (rotateWithTurret) {
            entity.m_5618_(vehicle.getBarrelYRot(1.0f) + passengerRot);
        }
        VehicleVecUtils.clampZoomYaw(vehicle, entity);
    }

    public static void clampZoomYaw(VehicleEntity vehicle, Entity entity) {
        if (!entity.m_9236_().f_46443_) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return;
        }
        if (vehicle.getTurretControllerIndex() == vehicle.getSeatIndex(entity)) {
            float f2 = Mth.m_14177_((float)(entity.m_146908_() - vehicle.getBarrelYRot(1.0f)));
            float f3 = Mth.m_14036_((float)f2, (float)-20.0f, (float)20.0f);
            entity.f_19859_ += f3 - f2;
            entity.m_146922_(entity.m_146908_() + f3 - f2);
        }
    }

    public static Vec3 getViewVec(VehicleEntity vehicle, Entity entity, float partialTicks) {
        GunData data = vehicle.getGunData(vehicle.getSeatIndex(entity));
        if (data == null) {
            return vehicle.m_20252_(partialTicks);
        }
        StringOrVec3 stringOrVec3 = data.compute().shootPos.viewDirection;
        if (stringOrVec3 == null) {
            return vehicle.getShootVec(entity, partialTicks);
        }
        if (stringOrVec3.isString()) {
            if (stringOrVec3.string.equals("Bomb")) {
                bombHitPosX = Mth.m_14139_((double)(0.1 * (double)partialTicks), (double)bombHitPosX, (double)vehicle.bombHitPos((Entity)entity).f_82479_);
                bombHitPosY = Mth.m_14139_((double)(0.1 * (double)partialTicks), (double)bombHitPosY, (double)vehicle.bombHitPos((Entity)entity).f_82480_);
                bombHitPosZ = Mth.m_14139_((double)(0.1 * (double)partialTicks), (double)bombHitPosZ, (double)vehicle.bombHitPos((Entity)entity).f_82481_);
                return VehicleVecUtils.getViewPos(vehicle, entity, partialTicks).m_82505_(new Vec3(bombHitPosX, bombHitPosY, bombHitPosZ));
            }
            return vehicle.getVectorFromString(stringOrVec3.string, partialTicks, vehicle.getSeatIndex(entity));
        }
        Vec3 vec3 = stringOrVec3.vec3;
        Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.f_82479_ + stringOrVec3.vec3.f_82479_, vec3.f_82480_ + stringOrVec3.vec3.f_82480_, vec3.f_82481_ + stringOrVec3.vec3.f_82481_);
        Vector4d worldPositionO = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        Vec3 startPos = new Vec3(worldPositionO.x, worldPositionO.y, worldPositionO.z);
        Vec3 endPos = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        return startPos.m_82505_(endPos).m_82541_();
    }

    public static Vec3 getViewPos(VehicleEntity vehicle, Entity entity, float partialTicks) {
        GunData data = vehicle.getGunData(vehicle.getSeatIndex(entity));
        if (data == null) {
            return VehicleVecUtils.entityEyePos(entity, partialTicks);
        }
        Vec3 vec3 = data.compute().shootPos.viewPosition;
        if (vec3 == null) {
            return vehicle.getCameraPos(entity, partialTicks);
        }
        Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
    }

    public static Vec3 getSeekVec(VehicleEntity vehicle, Entity entity, float partialTicks) {
        GunData data = vehicle.getGunData(vehicle.getSeatIndex(entity));
        if (data == null) {
            return vehicle.m_20252_(partialTicks);
        }
        StringOrVec3 stringOrVec3 = data.compute().seekWeaponInfo.seekDirection;
        if (stringOrVec3 == null) {
            return vehicle.getShootVec(entity, partialTicks);
        }
        if (stringOrVec3.isString()) {
            return vehicle.getVectorFromString(stringOrVec3.string, partialTicks, vehicle.getSeatIndex(entity));
        }
        Vec3 vec3 = stringOrVec3.vec3;
        Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.f_82479_ + stringOrVec3.vec3.f_82479_, vec3.f_82480_ + stringOrVec3.vec3.f_82480_, vec3.f_82481_ + stringOrVec3.vec3.f_82481_);
        Vector4d worldPositionO = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        Vec3 startPos = new Vec3(worldPositionO.x, worldPositionO.y, worldPositionO.z);
        Vec3 endPos = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        return startPos.m_82505_(endPos).m_82541_();
    }

    public static Vec3 getShootVec(VehicleEntity vehicle, Entity entity, float partialTicks) {
        GunData data = vehicle.getGunData(vehicle.getSeatIndex(entity));
        if (data == null) {
            return vehicle.m_20252_(partialTicks);
        }
        StringOrVec3 stringOrVec3 = data.fireDirection();
        if (stringOrVec3.isString()) {
            return vehicle.getVectorFromString(stringOrVec3.string, partialTicks, vehicle.getSeatIndex(entity));
        }
        Vec3 vec3 = data.firePosition();
        Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.f_82479_ + stringOrVec3.vec3.f_82479_, vec3.f_82480_ + stringOrVec3.vec3.f_82480_, vec3.f_82481_ + stringOrVec3.vec3.f_82481_);
        Vector4d worldPositionO = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        Vec3 startPos = new Vec3(worldPositionO.x, worldPositionO.y, worldPositionO.z);
        Vec3 endPos = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        return startPos.m_82505_(endPos).m_82541_();
    }

    public static Vec3 getShootVec(VehicleEntity vehicle, String weaponName, float partialTicks) {
        GunData data = vehicle.getGunData(weaponName);
        if (data == null) {
            return vehicle.m_20252_(partialTicks);
        }
        StringOrVec3 stringOrVec3 = data.fireDirection();
        if (stringOrVec3.isString()) {
            return vehicle.getVectorFromString(stringOrVec3.string, partialTicks);
        }
        Vec3 vec3 = data.firePosition();
        Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.f_82479_ + stringOrVec3.vec3.f_82479_, vec3.f_82480_ + stringOrVec3.vec3.f_82480_, vec3.f_82481_ + stringOrVec3.vec3.f_82481_);
        Vector4d worldPositionO = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        Vec3 startPos = new Vec3(worldPositionO.x, worldPositionO.y, worldPositionO.z);
        Vec3 endPos = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        return startPos.m_82505_(endPos).m_82541_();
    }

    public static Vec3 getCameraPos(VehicleEntity vehicle, Entity entity, float partialTicks) {
        int index = vehicle.getSeatIndex(entity);
        SeatInfo seat = vehicle.computed().seats().get(index);
        if (seat == null) {
            return VehicleVecUtils.entityEyePos(entity, partialTicks);
        }
        CameraPos data = seat.cameraPos;
        if (data == null) {
            return VehicleVecUtils.entityEyePos(entity, partialTicks);
        }
        if (data.useSimulate3P) {
            Vec2 simulate3PPos = data.simulate3PPos;
            return VehicleVecUtils.simulate3P(entity, partialTicks, simulate3PPos.f_82470_, simulate3PPos.f_82471_);
        }
        if (data.useFixedCameraPos) {
            Vec3 vec3 = data.position;
            Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.transform, partialTicks), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        }
        return VehicleVecUtils.entityEyePos(entity, partialTicks);
    }

    public static Vec3 getCameraDirection(VehicleEntity vehicle, Entity entity, float partialTicks) {
        int index = vehicle.getSeatIndex(entity);
        SeatInfo seat = vehicle.computed().seats().get(index);
        if (seat == null) {
            return entity.m_20252_(partialTicks);
        }
        CameraPos data = seat.cameraPos;
        if (data == null) {
            return entity.m_20252_(partialTicks);
        }
        if (data.useSimulate3P) {
            return entity.m_20252_(partialTicks);
        }
        StringOrVec3 stringOrVec3 = data.direction;
        if (stringOrVec3.isString()) {
            if (stringOrVec3.string.equals("Default")) {
                if (VehicleVecUtils.getZoomDirection(vehicle, entity, partialTicks) != null && ClientEventHandler.zoomVehicle) {
                    return vehicle.getZoomDirection(entity, partialTicks);
                }
                return entity.m_20252_(partialTicks);
            }
            return vehicle.getVectorFromString(stringOrVec3.string, partialTicks, vehicle.getSeatIndex(entity));
        }
        Vec3 vec3 = data.position;
        Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.transform, partialTicks), vec3.f_82479_ + stringOrVec3.vec3.f_82479_, vec3.f_82480_ + stringOrVec3.vec3.f_82480_, vec3.f_82481_ + stringOrVec3.vec3.f_82481_);
        Vec3 startPos = VehicleVecUtils.getCameraPos(vehicle, entity, partialTicks);
        Vec3 endPos = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        return startPos.m_82505_(endPos).m_82541_();
    }

    public static Vec3 getZoomPos(VehicleEntity vehicle, Entity entity, float partialTicks) {
        int index = vehicle.getSeatIndex(entity);
        SeatInfo seat = vehicle.computed().seats().get(index);
        if (seat == null) {
            return VehicleVecUtils.entityEyePos(entity, partialTicks);
        }
        CameraPos data = seat.cameraPos;
        if (data == null) {
            return VehicleVecUtils.entityEyePos(entity, partialTicks);
        }
        Vec3 vec3 = data.zoomPosition;
        if (vec3 != null) {
            Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.transform, partialTicks), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        }
        return VehicleVecUtils.getCameraPos(vehicle, entity, partialTicks);
    }

    public static Vec3 getZoomDirection(VehicleEntity vehicle, Entity entity, float partialTicks) {
        int index = vehicle.getSeatIndex(entity);
        SeatInfo seat = vehicle.computed().seats().get(index);
        if (seat == null) {
            return entity.m_20252_(partialTicks);
        }
        CameraPos data = seat.cameraPos;
        if (data == null) {
            return entity.m_20252_(partialTicks);
        }
        StringOrVec3 stringOrVec3 = data.zoomDirection;
        if (stringOrVec3 != null) {
            if (stringOrVec3.isString()) {
                return vehicle.getVectorFromString(stringOrVec3.string, partialTicks, vehicle.getSeatIndex(entity));
            }
            Vec3 vec3 = data.zoomPosition;
            Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.transform, partialTicks), vec3.f_82479_ + stringOrVec3.vec3.f_82479_, vec3.f_82480_ + stringOrVec3.vec3.f_82480_, vec3.f_82481_ + stringOrVec3.vec3.f_82481_);
            Vec3 startPos = vehicle.getShootPos(entity, partialTicks);
            Vec3 endPos = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
            return startPos.m_82505_(endPos).m_82541_();
        }
        return null;
    }

    public static Matrix4d getVehicleYOffsetTransform(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transform = new Matrix4d();
        transform.translate(Mth.m_14139_((double)partialTicks, (double)vehicle.f_19854_, (double)vehicle.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(vehicle.f_19855_ + vehicle.getRotateOffsetHeight()), (double)(vehicle.m_20186_() + vehicle.getRotateOffsetHeight())), Mth.m_14139_((double)partialTicks, (double)vehicle.f_19856_, (double)vehicle.m_20189_()));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-Mth.m_14179_((float)partialTicks, (float)vehicle.f_19859_, (float)vehicle.m_146908_())));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)vehicle.f_19860_, (float)vehicle.m_146909_())));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(Mth.m_14179_((float)partialTicks, (float)vehicle.prevRoll, (float)vehicle.getRoll())));
        return transform;
    }

    public static Matrix4d getVehicleFlatTransform(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transform = new Matrix4d();
        transform.translate(Mth.m_14139_((double)partialTicks, (double)vehicle.f_19854_, (double)vehicle.m_20185_()), Mth.m_14139_((double)partialTicks, (double)vehicle.f_19855_, (double)vehicle.m_20186_()), Mth.m_14139_((double)partialTicks, (double)vehicle.f_19856_, (double)vehicle.m_20189_()));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-Mth.m_14179_((float)partialTicks, (float)vehicle.f_19859_, (float)vehicle.m_146908_())));
        return transform;
    }

    public static Matrix4d getClientVehicleTransform(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transform = new Matrix4d();
        transform.translate(Mth.m_14139_((double)partialTicks, (double)vehicle.f_19854_, (double)vehicle.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(vehicle.f_19855_ + vehicle.getRotateOffsetHeight()), (double)(vehicle.m_20186_() + vehicle.getRotateOffsetHeight())), Mth.m_14139_((double)partialTicks, (double)vehicle.f_19856_, (double)vehicle.m_20189_()));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_((float)((double)(-Mth.m_14179_((float)partialTicks, (float)vehicle.f_19859_, (float)vehicle.m_146908_())) + ClientMouseHandler.freeCameraYaw)));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_((float)((double)Mth.m_14179_((float)partialTicks, (float)vehicle.f_19860_, (float)vehicle.m_146909_()) + ClientMouseHandler.freeCameraPitch)));
        return transform;
    }

    public static Matrix4d getTurretTransform(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transformV = vehicle.getVehicleTransform(partialTicks);
        Matrix4d transform = new Matrix4d();
        Vec3 pos = vehicle.getTurretPos();
        if (pos == null) {
            return transformV;
        }
        Vector4d worldPosition = VehicleVecUtils.transformPosition(transform, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)vehicle.turretYRotO, (float)vehicle.getTurretYRot())));
        return transformV;
    }

    public static Vec3 getTurretVector(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transform = VehicleVecUtils.getTurretTransform(vehicle, partialTicks);
        Vector4d rootPosition = VehicleVecUtils.transformPosition(transform, 0.0, 0.0, 0.0);
        Vector4d targetPosition = VehicleVecUtils.transformPosition(transform, 0.0, 0.0, 1.0);
        return new Vec3(rootPosition.x, rootPosition.y, rootPosition.z).m_82505_(new Vec3(targetPosition.x, targetPosition.y, targetPosition.z));
    }

    public static Matrix4d getBarrelTransform(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transformT = VehicleVecUtils.getTurretTransform(vehicle, partialTicks);
        Matrix4d transform = new Matrix4d();
        Vec3 pos = vehicle.getBarrelPosition();
        Vector4d worldPosition = VehicleVecUtils.transformPosition(transform, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = vehicle.getTurretYaw(partialTicks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)partialTicks, (float)vehicle.turretXRotO, (float)vehicle.getTurretXRot());
        float xV = Mth.m_14179_((float)partialTicks, (float)vehicle.f_19860_, (float)vehicle.m_146909_());
        float z = Mth.m_14179_((float)partialTicks, (float)vehicle.prevRoll, (float)vehicle.getRoll());
        transformT.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformT;
    }

    public static Matrix4d getGunTransform(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transformT = VehicleVecUtils.getTurretTransform(vehicle, partialTicks);
        Matrix4d transform = new Matrix4d();
        Vec3 pos = vehicle.getPassengerWeaponStationPosition();
        Vector4d worldPosition = VehicleVecUtils.transformPosition(transform, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformT.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)vehicle.gunYRotO, (float)vehicle.getGunYRot()) - Mth.m_14179_((float)partialTicks, (float)vehicle.turretYRotO, (float)vehicle.getTurretYRot())));
        return transformT;
    }

    public static Matrix4d getPassengerWeaponStationBarrelTransform(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transformG = VehicleVecUtils.getGunTransform(vehicle, partialTicks);
        Matrix4d transform = new Matrix4d();
        Vec3 pos = vehicle.getPassengerWeaponStationBarrelPosition();
        Vector4d worldPosition = VehicleVecUtils.transformPosition(transform, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        transformG.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = vehicle.getTurretYaw(partialTicks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)partialTicks, (float)vehicle.gunXRotO, (float)vehicle.getGunXRot());
        float xV = Mth.m_14179_((float)partialTicks, (float)vehicle.f_19860_, (float)vehicle.m_146909_());
        float z = Mth.m_14179_((float)partialTicks, (float)vehicle.prevRoll, (float)vehicle.getRoll());
        transformG.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformG;
    }

    public static Vec3 getPassengerWeaponStationVector(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transform = VehicleVecUtils.getPassengerWeaponStationBarrelTransform(vehicle, partialTicks);
        Vector4d rootPosition = VehicleVecUtils.transformPosition(transform, 0.0, 0.0, 0.0);
        Vector4d targetPosition = VehicleVecUtils.transformPosition(transform, 0.0, 0.0, 1.0);
        return new Vec3(rootPosition.x, rootPosition.y, rootPosition.z).m_82505_(new Vec3(targetPosition.x, targetPosition.y, targetPosition.z));
    }
}

