/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.data.DefaultDataSupplier;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.vehicle.DefaultVehicleData;
import com.atsuishio.superbwarfare.data.vehicle.VehicleData;
import com.atsuishio.superbwarfare.data.vehicle.subdata.DestroyInfo;
import com.atsuishio.superbwarfare.entity.projectile.MelonBombEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Matrix4d;
import org.joml.Vector4d;

public class Tom6Entity
extends GeoVehicleEntity {
    public static final EntityDataAccessor<Boolean> MELON = SynchedEntityData.m_135353_(Tom6Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Tom6Entity(EntityType<Tom6Entity> type, Level world) {
        super(type, world);
    }

    @Override
    public DefaultVehicleData computeProperties(VehicleData vehicleData, DefaultVehicleData rawData) {
        if (((Boolean)this.f_19804_.m_135370_(MELON)).booleanValue()) {
            rawData.destroyInfo = new DestroyInfo(rawData.destroyInfo.crashPassengers, rawData.destroyInfo.explodePassengers, rawData.destroyInfo.explodeBlocks, this.getMelonExplosionDamage(), this.getMelonExplosionRadius(), ParticleTool.ParticleType.HUGE);
        }
        return (DefaultVehicleData)super.computeProperties((DefaultDataSupplier)vehicleData, (Object)rawData);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MELON, (Object)false);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Melon", ((Boolean)this.f_19804_.m_135370_(MELON)).booleanValue());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(MELON, (Object)compound.m_128471_("Melon"));
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        if (player.m_21205_().m_150930_(Items.f_42028_) && !((Boolean)this.f_19804_.m_135370_(MELON)).booleanValue()) {
            this.f_19804_.m_135381_(MELON, (Object)true);
            player.m_21205_().m_41774_(1);
            player.m_9236_().m_5594_(player, this.m_20097_(), SoundEvents.f_12635_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        Entity passenger = this.m_146895_();
        if (this.upInputDown() && !this.m_20096_() && ((Boolean)this.f_19804_.m_135370_(MELON)).booleanValue() && passenger instanceof Player) {
            Player player = (Player)passenger;
            this.f_19804_.m_135381_(MELON, (Object)false);
            Matrix4d transform = this.getVehicleTransform(1.0f);
            Vector4d worldPosition = this.transformPosition(transform, 0.0, 0.3, 0.0);
            MelonBombEntity melonBomb = new MelonBombEntity((LivingEntity)player, player.m_9236_());
            melonBomb.setExplosionDamage(this.getMelonExplosionDamage());
            melonBomb.setExplosionRadius(this.getMelonExplosionRadius());
            melonBomb.m_6034_(worldPosition.x, worldPosition.y, worldPosition.z);
            melonBomb.m_6686_(this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_, (float)this.m_20184_().m_82553_(), 0.0f);
            passenger.m_9236_().m_7967_((Entity)melonBomb);
            this.m_9236_().m_5594_(null, this.m_20097_(), SoundEvents.f_12056_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.setUpInputDown(false);
        }
    }

    public float getMelonExplosionDamage() {
        GunData gunData = this.getGunData("MelonBomb");
        if (gunData != null) {
            return (float)gunData.compute().explosionDamage;
        }
        return 0.0f;
    }

    public float getMelonExplosionRadius() {
        GunData gunData = this.getGunData("MelonBomb");
        if (gunData != null) {
            return (float)gunData.compute().explosionRadius;
        }
        return 0.0f;
    }

    @Override
    public boolean engineRunning() {
        return this.m_146895_() != null && Math.abs((double)this.m_20184_().m_82553_()) > 0.0;
    }

    @Override
    public float getEngineSoundVolume() {
        return (float)this.m_20184_().m_82553_();
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return ModKeyMappings.FREE_CAMERA.m_90857_() ? 0.0 : 0.6;
    }

    @Override
    public boolean useAircraftCamera(int seatIndex) {
        return ModKeyMappings.FREE_CAMERA.m_90857_() && !ClientEventHandler.zoom;
    }

    @Override
    public double getMouseSensitivity() {
        return ModKeyMappings.FREE_CAMERA.m_90857_() ? 0.3 : 0.0;
    }
}

