/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.ProjectileInfo;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArtilleryEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Matrix4d;
import org.joml.Vector3f;
import org.joml.Vector4d;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class AnnihilatorEntity
extends ArtilleryEntity {
    public static final EntityDataAccessor<Float> LASER_LEFT_LENGTH = SynchedEntityData.m_135353_(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> LASER_MIDDLE_LENGTH = SynchedEntityData.m_135353_(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> LASER_RIGHT_LENGTH = SynchedEntityData.m_135353_(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public AnnihilatorEntity(EntityType<AnnihilatorEntity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 3.0f) * damage.floatValue()));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LASER_LEFT_LENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LASER_MIDDLE_LENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LASER_RIGHT_LENGTH, (Object)Float.valueOf(0.0f));
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        if (player.m_21205_().m_41720_() == ModItems.FIRING_PARAMETERS.get() && player.m_6047_()) {
            this.setTarget(player.m_21206_());
            return InteractionResult.SUCCESS;
        }
        if (player.m_21206_().m_41720_() == ModItems.FIRING_PARAMETERS.get() && player.m_6047_()) {
            this.setTarget(player.m_21206_());
            return InteractionResult.SUCCESS;
        }
        if (stack.m_204117_(ModTags.Items.TOOLS_CROWBAR) && !player.m_6047_()) {
            if (((Float)this.f_19804_.m_135370_(CHARGE_PROGRESS)).floatValue() >= 1.0f) {
                this.vehicleShoot((LivingEntity)player, "Main");
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }

    public void setTarget(ItemStack stack) {
        int targetX = stack.m_41784_().m_128451_("TargetX");
        int targetY = stack.m_41784_().m_128451_("TargetY");
        int targetZ = stack.m_41784_().m_128451_("TargetZ");
        this.f_19804_.m_135381_(TARGET_POS, (Object)new Vector3f((float)targetX, (float)targetY, (float)targetZ));
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        String weaponName = "Main";
        GunData data = this.getGunData(weaponName);
        if (data != null) {
            ProjectileInfo projectileInfo = data.compute().projectile();
            String projectileType = projectileInfo.type;
            String projectileTypeStr = projectileType.trim().toLowerCase(Locale.ROOT);
            int rpm = (int)Math.ceil((float)(20.0f / ((float)this.vehicleWeaponRpm(weaponName) / 60.0f)));
            if (projectileTypeStr.equals("ray") && ((Float)this.f_19804_.m_135370_(CHARGE_PROGRESS)).floatValue() < 1.0f && this.getEnergy() > data.compute().ammoCostPerShoot) {
                float chargeSpeed = 1.0f / (float)rpm;
                this.f_19804_.m_135381_(CHARGE_PROGRESS, (Object)Float.valueOf(Mth.m_14036_((float)(((Float)this.f_19804_.m_135370_(CHARGE_PROGRESS)).floatValue() + chargeSpeed), (float)0.0f, (float)1.0f)));
            }
        }
    }

    private float laserLength(Vec3 pos, LivingEntity living, GunData data) {
        BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(pos, pos.m_82549_(this.getBarrelVector(1.0f).m_82490_(512.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        Vec3 hitPos = result.m_82450_();
        BlockPos blockPos = result.m_82425_();
        float hardness = this.m_9236_().m_8055_(blockPos).m_60734_().m_155943_();
        if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() && ((Boolean)ExplosionConfig.EXTRA_EXPLOSION_EFFECT.get()).booleanValue() && hardness != -1.0f) {
            Block.m_49892_((BlockState)this.m_9236_().m_8055_(blockPos), (LevelAccessor)this.m_9236_(), (BlockPos)blockPos, null);
            this.m_9236_().m_46961_(blockPos, true);
        }
        this.causeLaserExplode(hitPos, data, (Entity)living);
        this.m_9236_().m_254849_((Entity)living, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, (float)(data.compute().explosionRadius * 0.5), (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
        return (float)pos.m_82554_(hitPos);
    }

    private float laserLengthEntity(Vec3 pos, LivingEntity living, GunData data) {
        if (this.m_9236_() instanceof ServerLevel) {
            AABB aabb;
            double blockReach;
            double distance = 262144.0;
            HitResult hitResult = TraceTool.pickNew(pos, 512.0, this.getBarrelVector(1.0f), this);
            if (hitResult.m_6662_() != HitResult.Type.MISS && (distance = hitResult.m_82450_().m_82557_(pos)) > (blockReach = 5.0) * blockReach) {
                Vec3 posB = hitResult.m_82450_();
                hitResult = BlockHitResult.m_82426_((Vec3)posB, (Direction)Direction.m_122366_((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_), (BlockPos)BlockPos.m_274446_((Position)posB));
            }
            Vec3 viewVec = this.getBarrelVector(1.0f);
            Vec3 toVec = pos.m_82520_(viewVec.f_82479_ * 512.0, viewVec.f_82480_ * 512.0, viewVec.f_82481_ * 512.0);
            EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)this, (Vec3)pos, (Vec3)toVec, (AABB)(aabb = this.m_20191_().m_82369_(viewVec.m_82490_(512.0)).m_82400_(1.0)), p -> !p.m_5833_(), (double)distance);
            if (entityhitresult != null) {
                Vec3 targetPos = entityhitresult.m_82450_();
                double distanceToTarget = pos.m_82557_(targetPos);
                if (distanceToTarget > distance || distanceToTarget > 262144.0) {
                    hitResult = BlockHitResult.m_82426_((Vec3)targetPos, (Direction)Direction.m_122366_((double)viewVec.f_82479_, (double)viewVec.f_82480_, (double)viewVec.f_82481_), (BlockPos)BlockPos.m_274446_((Position)targetPos));
                } else if (distanceToTarget < distance) {
                    hitResult = entityhitresult;
                }
                if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity passenger = this.m_146895_();
                    Entity target = ((EntityHitResult)hitResult).m_82443_();
                    DamageHandler.doDamage(target, ModDamageTypes.causeLaserDamage(this.m_9236_().m_9598_(), this, passenger), (float)data.compute().damage);
                    target.f_19802_ = 0;
                    this.causeLaserExplode(targetPos, data, (Entity)living);
                    return (float)pos.m_82554_(hitResult.m_82450_());
                }
            }
        }
        return 512.0f;
    }

    private void causeLaserExplode(Vec3 vec3, GunData gunData, Entity living) {
        float radius = (float)gunData.compute().explosionRadius;
        ParticleTool.ParticleType particleType = radius <= 4.0f ? ParticleTool.ParticleType.SMALL : (radius > 4.0f && radius < 10.0f ? ParticleTool.ParticleType.MEDIUM : (radius >= 10.0f && radius < 20.0f ? ParticleTool.ParticleType.HUGE : ParticleTool.ParticleType.GIANT));
        this.createCustomExplosion().damage((float)gunData.compute().explosionDamage).radius(radius).attacker(living).position(vec3).withParticleType(particleType).explode();
    }

    @Override
    public void vehicleShoot(LivingEntity living, String weaponName) {
        GunData data = this.getGunData(weaponName);
        this.shoot(living, data);
    }

    @Override
    public void vehicleShoot(LivingEntity living, UUID uuid, Vec3 targetPos) {
        GunData data = this.getGunData((Entity)living);
        this.shoot(living, data);
    }

    public void shoot(LivingEntity living, GunData gunData) {
        if (gunData == null) {
            return;
        }
        if (this.m_9236_() instanceof ServerLevel) {
            this.f_19804_.m_135381_(CHARGE_PROGRESS, (Object)Float.valueOf(0.0f));
            this.consumeEnergy(gunData.compute().ammoCostPerShoot);
            Matrix4d transform = this.getBarrelTransform(1.0f);
            Vector4d worldPosition1 = this.transformPosition(transform, 2.703, -0.045, 15.75);
            Vector4d worldPosition2 = this.transformPosition(transform, 0.0, -0.045, 15.75);
            Vector4d worldPosition3 = this.transformPosition(transform, -2.703, -0.045, 15.75);
            Vec3 barrelLeftPos = new Vec3(worldPosition1.x, worldPosition1.y, worldPosition1.z);
            Vec3 barrelMiddlePos = new Vec3(worldPosition2.x, worldPosition2.y, worldPosition2.z);
            Vec3 barrelRightPos = new Vec3(worldPosition3.x, worldPosition3.y, worldPosition3.z);
            for (int i = 0; i < 10; ++i) {
                Mod.queueServerWork(i, () -> {
                    this.f_19804_.m_135381_(LASER_LEFT_LENGTH, (Object)Float.valueOf(Math.min((float)this.laserLength(barrelLeftPos, living, gunData), (float)this.laserLengthEntity(barrelLeftPos, living, gunData))));
                    this.f_19804_.m_135381_(LASER_MIDDLE_LENGTH, (Object)Float.valueOf(Math.min((float)this.laserLength(barrelMiddlePos, living, gunData), (float)this.laserLengthEntity(barrelMiddlePos, living, gunData))));
                    this.f_19804_.m_135381_(LASER_RIGHT_LENGTH, (Object)Float.valueOf(Math.min((float)this.laserLength(barrelRightPos, living, gunData), (float)this.laserLengthEntity(barrelRightPos, living, gunData))));
                });
            }
            int reloadTime = (int)Mth.m_14036_((float)(20.0f / ((float)Math.max((int)this.vehicleWeaponRpm("Main"), (int)1) / 60.0f)), (float)1.0f, (float)2.1474836E9f);
            Mod.queueServerWork(reloadTime - 20, () -> {
                if (this.m_6084_()) {
                    this.m_9236_().m_5594_(null, this.m_20097_(), gunData.compute().soundInfo.vehicleReload, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            });
            gunData.shakePlayers(this);
            this.playShootSound3p(living, gunData, barrelMiddlePos);
        }
    }

    @Override
    public boolean canShoot(LivingEntity living) {
        GunData gunData = this.getGunData(this.getSeatIndex((Entity)living));
        return gunData != null && gunData.canShoot(this.getAmmoSupplier()) && this.canConsume(gunData.compute().ammoCostPerShoot);
    }

    private PlayState movementPredicate(AnimationState<AnnihilatorEntity> event) {
        if (((Float)this.f_19804_.m_135370_(CHARGE_PROGRESS)).floatValue() < 1.0f) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.annihilator.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.annihilator.idle"));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }
}

