/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.DestroyableProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SmallCannonShellEntity
extends FastThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean aa;

    public SmallCannonShellEntity(EntityType<? extends SmallCannonShellEntity> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
        this.damage = 40.0f;
        this.explosionDamage = 80.0f;
        this.explosionRadius = 5.0f;
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.SMALL_SHELL.get();
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (this.m_19749_() != null && this.m_19749_().m_20202_() != null && entity == this.m_19749_().m_20202_()) {
            return;
        }
        if (this.m_9236_() instanceof ServerLevel) {
            LivingEntity living;
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).m_9236_().m_5776_() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
            }
            DamageHandler.doDamage(entity, ModDamageTypes.causeProjectileHitDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.damage);
            if (entity instanceof LivingEntity) {
                entity.f_19802_ = 0;
            }
            if (this.f_19797_ > 0) {
                this.causeExplode(result.m_82450_(), true);
            }
            this.m_146870_();
        }
    }

    @Override
    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        Block block;
        float hardness;
        super.m_8060_(blockHitResult);
        BlockPos resultPos = blockHitResult.m_82425_();
        BlockState state = this.m_9236_().m_8055_(resultPos);
        if (this.m_9236_() instanceof ServerLevel && (hardness = this.m_9236_().m_8055_(resultPos).m_60734_().m_155943_()) != -1.0f && ((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() && ((Boolean)ExplosionConfig.EXTRA_EXPLOSION_EFFECT.get()).booleanValue()) {
            boolean destroy;
            boolean bl = destroy = Math.random() < Mth.m_14008_((double)(1.0f - hardness / 50.0f), (double)0.1, (double)1.0);
            if (destroy) {
                this.m_9236_().m_46961_(resultPos, true);
            }
        }
        if ((block = state.m_60734_()) instanceof BellBlock) {
            BellBlock bell = (BellBlock)block;
            bell.m_49712_(this.m_9236_(), resultPos, blockHitResult.m_82434_());
        }
        if (this.m_9236_() instanceof ServerLevel) {
            this.causeExplode(blockHitResult.m_82450_(), false);
        }
        this.m_146870_();
    }

    private void causeExplode(Vec3 vec3, boolean hitEntity) {
        new CustomExplosion.Builder((Entity)this).attacker(this.m_19749_()).damage(this.explosionDamage).radius(this.explosionRadius).position(vec3).withParticleType(ParticleTool.ParticleType.SMALL).destroyBlock(() -> hitEntity ? Explosion.BlockInteraction.KEEP : ((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP)).damageMultiplier(1.25f).explode();
    }

    @Override
    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123762_, this.f_19854_, this.f_19855_, this.f_19856_, 1, 0.0, 0.0, 0.0, 0.02, true);
        }
        if (this.m_20096_()) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        if (this.f_19797_ > 200 || this.m_20069_()) {
            if (this.m_9236_() instanceof ServerLevel && !this.m_20096_()) {
                this.causeExplode(this.m_20182_(), false);
            }
            this.m_146870_();
        }
        if (this.aa) {
            this.crushProjectile(this.m_20184_());
        }
    }

    public void crushProjectile(Vec3 velocity) {
        if (this.m_9236_() instanceof ServerLevel) {
            AABB frontBox = this.m_20191_().m_82400_(0.5).m_82369_(velocity);
            Optional<Projectile> target = this.m_9236_().m_142425_(EntityTypeTest.m_156916_(Projectile.class), frontBox, entity -> entity != this).stream().filter(entity -> !(entity instanceof SmallCannonShellEntity) && ((double)entity.m_20205_() >= 0.3 || (double)entity.m_20206_() >= 0.3)).min(Comparator.comparingDouble(e -> e.m_20182_().m_82554_(this.m_20182_())));
            if (target.isPresent()) {
                this.causeExplode(target.get().m_20182_(), false);
                Projectile projectile = target.get();
                if (projectile instanceof DestroyableProjectile) {
                    LivingEntity living;
                    DestroyableProjectile destroyableProjectile = (DestroyableProjectile)projectile;
                    Entity entity2 = this.m_19749_();
                    if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).m_9236_().m_5776_() && living instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)living;
                        living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                        NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
                    }
                    DamageHandler.doDamage((Entity)destroyableProjectile, ModDamageTypes.causeProjectileHitDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.damage);
                } else {
                    target.get().m_146870_();
                }
                this.m_146870_();
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void antiAir(boolean antiAir) {
        this.aa = antiAir;
    }

    @Override
    public boolean isFastMoving() {
        return false;
    }
}

